/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.api.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class LaserDrillEntry {
    public static List<ResourceLocation> default_files = null;
    public static List<LaserDrillEntry>[] LASER_DRILL_ENTRIES;
    public static List<LaserDrillEntryExtended> LASER_DRILL_UNIQUE_VALUES;
    private int laserMeta;
    private ItemStack stack;
    private int weight;
    private List<Biome> whitelist;
    private List<Biome> blacklist;

    public LaserDrillEntry(int laserMeta, ItemStack stack, int weight, List<Biome> whitelist, List<Biome> blacklist) {
        this.laserMeta = laserMeta;
        this.stack = stack;
        this.weight = weight;
        this.whitelist = whitelist;
        this.blacklist = blacklist;
    }

    public static void addOreFile(ResourceLocation l) {
        if (default_files == null) {
            default_files = new LinkedList<ResourceLocation>();
        }
        default_files.add(l);
    }

    public static void loadLaserConfigs(File configDir) {
        Path ores_path = configDir.toPath().resolve("laser_drill_ores");
        if (!Files.exists(ores_path, new LinkOption[0])) {
            ores_path.toFile().mkdir();
        }
        for (ResourceLocation resourceLocation : default_files) {
            Path l_path = ores_path.resolve(resourceLocation.func_110623_a());
            if (Files.exists(l_path, new LinkOption[0])) continue;
            InputStream in = null;
            try {
                int read;
                in = LaserDrillEntry.class.getClassLoader().getResourceAsStream("assets/" + resourceLocation.func_110624_b() + "/" + resourceLocation.func_110623_a());
                FileOutputStream out = new FileOutputStream(l_path.toFile());
                byte[] buffer = new byte[4096];
                while ((read = in.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, read);
                }
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        LASER_DRILL_ENTRIES = new LinkedList[256];
        for (int i = 0; i < LASER_DRILL_ENTRIES.length; ++i) {
            LaserDrillEntry.LASER_DRILL_ENTRIES[i] = new LinkedList<LaserDrillEntry>();
        }
        LASER_DRILL_UNIQUE_VALUES = new ArrayList<LaserDrillEntryExtended>();
        try {
            DirectoryStream<Path> ds = Files.newDirectoryStream(ores_path, "*.{json}");
            for (Path p : ds) {
                LaserDrillEntry.loadConfig(p.toFile());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void loadConfig(File f) {
        try {
            JsonReader j = new JsonReader((Reader)new FileReader(f));
            JsonArray head = new JsonParser().parse(j).getAsJsonArray();
            for (JsonElement o : head) {
                ItemStack itemStack;
                JsonObject ore = o.getAsJsonObject();
                String itemName = ore.getAsJsonPrimitive("item").getAsString();
                if (itemName.startsWith("ore")) {
                    if (!OreDictionary.doesOreNameExist((String)itemName) || OreDictionary.getOres((String)itemName).size() <= 0) continue;
                    itemStack = ((ItemStack)OreDictionary.getOres((String)itemName).get(0)).func_77946_l();
                } else {
                    String[] item_strings = itemName.split(":");
                    ResourceLocation item_location = new ResourceLocation(item_strings[0], item_strings[1]);
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(item_location);
                    if (item == null) continue;
                    itemStack = item_strings.length > 2 ? new ItemStack(item, 1, Integer.parseInt(item_strings[2])) : new ItemStack(item);
                }
                if (itemStack.func_190926_b()) continue;
                int color = ore.getAsJsonPrimitive("color").getAsInt();
                JsonArray rarities = ore.getAsJsonArray("rarity");
                for (JsonElement r : rarities) {
                    JsonObject rarity_data = r.getAsJsonObject();
                    LinkedList<Biome> whitelist = new LinkedList<Biome>();
                    LinkedList<Biome> blacklist = new LinkedList<Biome>();
                    String[] blacklist_strings = rarity_data.getAsJsonPrimitive("blacklist").getAsString().split(",");
                    for (int i = 0; i < blacklist_strings.length; ++i) {
                        Biome biome;
                        if (blacklist_strings[i].isEmpty() || (biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(blacklist_strings[i].trim()))) == null) continue;
                        blacklist.add(biome);
                    }
                    String[] whitelist_strings = rarity_data.getAsJsonPrimitive("whitelist").getAsString().split(",");
                    for (int i = 0; i < whitelist_strings.length; ++i) {
                        Biome biome;
                        if (whitelist_strings[i].isEmpty() || (biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(whitelist_strings[i].trim()))) == null) continue;
                        whitelist.add(biome);
                    }
                    int amount = rarity_data.get("weight").getAsInt();
                    int min_depth = rarity_data.get("depth_min").getAsInt();
                    int max_depth = rarity_data.get("depth_max").getAsInt();
                    for (int d = min_depth; d <= max_depth; ++d) {
                        LASER_DRILL_ENTRIES[d].add(new LaserDrillEntry(color, itemStack, amount, whitelist, blacklist));
                    }
                    LaserDrillEntry.findForOre(itemStack, new LaserDrillEntryExtended(color, itemStack)).getRarities().add(new OreRarity(amount, whitelist, blacklist, max_depth, min_depth));
                }
            }
            j.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static LaserDrillEntryExtended findForOre(ItemStack itemStack, LaserDrillEntryExtended defaultEntry) {
        for (LaserDrillEntryExtended laserDrillUniqueValue : LASER_DRILL_UNIQUE_VALUES) {
            if (!itemStack.func_77969_a(laserDrillUniqueValue.getStack())) continue;
            return laserDrillUniqueValue;
        }
        LASER_DRILL_UNIQUE_VALUES.add(defaultEntry);
        return defaultEntry;
    }

    public int getLaserMeta() {
        return this.laserMeta;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public int getWeight() {
        return this.weight;
    }

    public List<Biome> getBlacklist() {
        return this.blacklist;
    }

    public List<Biome> getWhitelist() {
        return this.whitelist;
    }

    public String toString() {
        return this.stack.func_82833_r();
    }

    public static class OreRarity {
        private int weight;
        private List<Biome> whitelist;
        private List<Biome> blacklist;
        private int maxY;
        private int minY;

        public OreRarity(int weight, List<Biome> whitelist, List<Biome> blacklist, int maxY, int minY) {
            this.weight = weight;
            this.whitelist = whitelist;
            this.blacklist = blacklist;
            this.maxY = maxY;
            this.minY = minY;
        }

        public int getWeight() {
            return this.weight;
        }

        public List<Biome> getWhitelist() {
            return this.whitelist;
        }

        public List<Biome> getBlacklist() {
            return this.blacklist;
        }

        public int getMaxY() {
            return this.maxY;
        }

        public int getMinY() {
            return this.minY;
        }
    }

    public static class LaserDrillEntryExtended {
        private int laserMeta;
        private ItemStack stack;
        private List<OreRarity> rarities;

        public LaserDrillEntryExtended(int laserMeta, ItemStack stack) {
            this.laserMeta = laserMeta;
            this.stack = stack;
            this.rarities = new ArrayList<OreRarity>();
        }

        public int getLaserMeta() {
            return this.laserMeta;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public List<OreRarity> getRarities() {
            return this.rarities;
        }
    }
}

