/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalcultivation.gui.container;

import cofh.core.gui.container.ContainerInventoryItem;
import cofh.core.gui.slot.ISlotValidator;
import cofh.core.gui.slot.SlotLocked;
import cofh.core.gui.slot.SlotValidated;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalcultivation.gui.slot.SlotBagCreative;
import cofh.thermalcultivation.item.ItemSeedBag;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.IPlantable;

public class ContainerSeedBag
extends ContainerInventoryItem
implements ISlotValidator {
    static final String NAME = "item.thermalcultivation.seed_bag.name";
    boolean isCreative;
    int storageIndex;
    int rowSize;

    public ContainerSeedBag(ItemStack stack, InventoryPlayer inventory) {
        super(stack, inventory);
        this.isCreative = ItemSeedBag.isCreative((ItemStack)stack);
        this.storageIndex = ItemSeedBag.getStorageIndex(stack);
        this.rowSize = MathHelper.clamp((int)this.storageIndex, (int)9, (int)14);
        int rows = MathHelper.clamp((int)this.storageIndex, (int)2, (int)9);
        int slots = this.rowSize * rows;
        int yOffset = 17;
        this.bindPlayerInventory(inventory);
        switch (this.storageIndex) {
            case 0: {
                this.func_75146_a(new SlotBagCreative(this, (IInventory)this.containerWrapper, 0, 80, 26));
                this.rowSize = 1;
                break;
            }
            case 1: {
                yOffset += 9;
                for (int i = 0; i < 9; ++i) {
                    this.func_75146_a((Slot)new SlotValidated((ISlotValidator)this, (IInventory)this.containerWrapper, i, 8 + i % this.rowSize * 18, yOffset + i / this.rowSize * 18));
                }
                break;
            }
            default: {
                for (int i = 0; i < slots; ++i) {
                    this.func_75146_a((Slot)new SlotValidated((ISlotValidator)this, (IInventory)this.containerWrapper, i, 8 + i % this.rowSize * 18, yOffset + i / this.rowSize * 18));
                }
            }
        }
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        int xOffset = this.getPlayerInventoryHorizontalOffset();
        int yOffset = this.getPlayerInventoryVerticalOffset();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (i == inventoryPlayer.field_70461_c) {
                this.func_75146_a((Slot)new SlotLocked((IInventory)inventoryPlayer, i, xOffset + i * 18, yOffset + 58));
                continue;
            }
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, xOffset + i * 18, yOffset + 58));
        }
    }

    public String getInventoryName() {
        return this.containerWrapper.func_145818_k_() ? this.containerWrapper.func_70005_c_() : StringHelper.localize((String)NAME);
    }

    protected int getPlayerInventoryVerticalOffset() {
        return 30 + 18 * MathHelper.clamp((int)this.storageIndex, (int)2, (int)9);
    }

    protected int getPlayerInventoryHorizontalOffset() {
        return 8 + 9 * (this.rowSize - 9);
    }

    public boolean isItemValid(ItemStack stack) {
        Item current = ItemSeedBag.getCurrentSeed(this.getContainerStack());
        return this.containerWrapper.func_94041_b(0, stack) && stack.func_77973_b() instanceof IPlantable && (current == null || current.equals(stack.func_77973_b()));
    }
}

