/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class InventoryHelper {
    @Nullable
    public static IItemHandler getInventoryAtLocation(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return InventoryHelper.getInventoryFromTile(tile, EnumFacing.UP);
    }

    @Nullable
    public static IItemHandler getInventoryFromTile(@Nullable TileEntity tile, @Nullable EnumFacing side) {
        if (tile == null) {
            return null;
        }
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        }
        if (tile instanceof ISidedInventory) {
            return new SidedInvWrapper((ISidedInventory)tile, side);
        }
        if (tile instanceof IInventory) {
            return new InvWrapper((IInventory)tile);
        }
        return null;
    }

    @Nonnull
    public static ItemStack insertStackIntoInventory(@Nonnull ItemStack itemStack, IItemHandler inventory) {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)itemStack, (boolean)false);
    }

    @Nonnull
    public static ItemStack insertStackIntoInventoryOnce(@Nonnull ItemStack itemStack, IItemHandler inventory) {
        int originalStackSize = itemStack.func_190916_E();
        for (int slotIndex = 0; slotIndex < inventory.getSlots() && !(itemStack = inventory.insertItem(slotIndex, itemStack, false)).func_190926_b() && itemStack.func_190916_E() == originalStackSize; ++slotIndex) {
        }
        if (itemStack.func_190926_b()) {
            itemStack = ItemStack.field_190927_a;
        }
        return itemStack;
    }

    public static List<Integer> getNonEmptySlotsInInventory(IItemHandler inventory) {
        ArrayList<Integer> nonEmptySlotIndexes = new ArrayList<Integer>(inventory.getSlots());
        for (int slotNum = 0; slotNum < inventory.getSlots(); ++slotNum) {
            if (inventory.getStackInSlot(slotNum).func_190926_b()) continue;
            nonEmptySlotIndexes.add(slotNum);
        }
        return nonEmptySlotIndexes;
    }

    public static int getRandomNonEmptySlotInInventory(IItemHandler inventory, Random random) {
        List<Integer> nonEmptySlots = InventoryHelper.getNonEmptySlotsInInventory(inventory);
        if (!nonEmptySlots.isEmpty()) {
            return nonEmptySlots.get(random.nextInt(nonEmptySlots.size()));
        }
        return 0;
    }

    @Nonnull
    public static ItemStack removeRandomSingleItemFromInventory(IItemHandler inventory, Random random) {
        int randomNonEmptySlotIndex = InventoryHelper.getRandomNonEmptySlotInInventory(inventory, random);
        if (!inventory.getStackInSlot(randomNonEmptySlotIndex).func_190926_b()) {
            return inventory.extractItem(randomNonEmptySlotIndex, 1, false);
        }
        return ItemStack.field_190927_a;
    }

    public static NonNullList<ItemStack> itemStackArrayToList(ItemStack[] array) {
        NonNullList list = NonNullList.func_191197_a((int)array.length, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < array.length; ++i) {
            if (array[i].func_190926_b()) continue;
            list.set(i, (Object)array[i]);
        }
        return list;
    }
}

