/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.helpers;

import net.minecraft.util.text.TextFormatting;

public class ColorHelper {
    private static final TextFormatting[] colorRange = new TextFormatting[]{TextFormatting.DARK_RED, TextFormatting.RED, TextFormatting.GOLD, TextFormatting.YELLOW, TextFormatting.DARK_GREEN, TextFormatting.GREEN, TextFormatting.AQUA};
    private static final TextFormatting[] booleanColorRange = new TextFormatting[]{TextFormatting.DARK_RED, TextFormatting.RED, TextFormatting.DARK_GREEN, TextFormatting.GREEN};

    public static String getRelativeColor(double val, double min, double max) {
        if (min == max) {
            return TextFormatting.RESET.toString();
        }
        if (max > min && val > max || min > max && val < max) {
            return TextFormatting.WHITE.toString() + TextFormatting.BOLD;
        }
        if (max > min && val < min || min > max && val > min) {
            return colorRange[0].toString() + TextFormatting.BOLD;
        }
        int index = (int)((val - min) / (max - min) * (double)(colorRange.length - 1));
        return colorRange[Math.max(0, Math.min(colorRange.length - 1, index))].toString();
    }

    public static int fromRGBA(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int getRelativeColorInt(double val, double min, double max) {
        if (min == max) {
            return 0;
        }
        if (val > max) {
            return 2021041;
        }
        double full = max - min;
        double f1 = (max - val) / full;
        double f2 = (val - min) / full;
        int[] minColor = new int[]{150, 0, 0};
        int[] maxColor = new int[]{0, 100, 0};
        int[] color = new int[]{(int)((double)maxColor[0] * f2 + (double)minColor[0] * f1), (int)((double)maxColor[1] * f2 + (double)minColor[1] * f1), (int)((double)maxColor[2] * f2 + (double)minColor[2] * f1)};
        return ColorHelper.fromRGBA(color[0], color[1], color[2], 255);
    }

    public static String getBooleanColor(boolean val) {
        return ColorHelper.getBooleanColor(val, false);
    }

    public static String getBooleanColor(boolean val, boolean modified) {
        return booleanColorRange[(val ? 2 : 0) + (modified ? 1 : 0)].toString();
    }
}

