/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import squeek.applecore.api.food.FoodValues;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.compat.IByteIO;
import squeek.spiceoflife.foodtracker.FoodEaten;
import squeek.spiceoflife.foodtracker.capability.IFoodHistory;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroup;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.foodtracker.foodqueue.FixedHungerQueue;
import squeek.spiceoflife.foodtracker.foodqueue.FixedSizeQueue;
import squeek.spiceoflife.foodtracker.foodqueue.FixedTimeQueue;
import squeek.spiceoflife.foodtracker.foodqueue.FoodQueue;
import squeek.spiceoflife.helpers.FoodHelper;
import squeek.spiceoflife.helpers.MiscHelper;
import squeek.spiceoflife.items.ItemFoodJournal;

public class FoodHistory
implements IFoodHistory,
ICapabilitySerializable<NBTTagCompound> {
    public static final ResourceLocation CAPABILITY_ID = new ResourceLocation("spiceoflife", "History");
    public static final String TAG_KEY = "spiceoflifeHistory";
    @CapabilityInject(value=IFoodHistory.class)
    public static final Capability<IFoodHistory> CAPABILITY = null;
    public final EntityPlayer player;
    protected FoodQueue history = FoodHistory.getNewFoodQueue();
    public int totalFoodsEatenAllTime = 0;
    public boolean wasGivenFoodJournal = false;
    public long ticksActive = 0L;

    public FoodHistory() {
        this(null);
    }

    public FoodHistory(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public void onHistoryTypeChanged() {
        FoodQueue oldHistory = this.history;
        this.history = FoodHistory.getNewFoodQueue();
        this.history.addAll(oldHistory);
    }

    public static FoodQueue getNewFoodQueue() {
        if (ModConfig.USE_HUNGER_QUEUE) {
            return new FixedHungerQueue(ModConfig.FOOD_HISTORY_LENGTH);
        }
        if (ModConfig.USE_TIME_QUEUE) {
            return new FixedTimeQueue((long)ModConfig.FOOD_HISTORY_LENGTH * 24000L);
        }
        return new FixedSizeQueue(ModConfig.FOOD_HISTORY_LENGTH);
    }

    @Override
    public void deltaTicksActive(long delta) {
        this.ticksActive += delta;
    }

    @Override
    public boolean addFood(FoodEaten foodEaten) {
        return this.addFood(foodEaten, true);
    }

    @Override
    public boolean addFood(FoodEaten foodEaten, boolean countsTowardsAllTime) {
        boolean isAtThreshold;
        if (countsTowardsAllTime) {
            ++this.totalFoodsEatenAllTime;
        }
        boolean bl = isAtThreshold = countsTowardsAllTime && this.totalFoodsEatenAllTime == ModConfig.FOOD_EATEN_THRESHOLD;
        if (this.player != null && !this.player.field_70170_p.field_72995_K) {
            if (ModConfig.GIVE_FOOD_JOURNAL_ON_DIMINISHING_RETURNS && !this.wasGivenFoodJournal && isAtThreshold) {
                ItemFoodJournal.giveToPlayer(this.player);
                this.wasGivenFoodJournal = true;
            }
            if (ModConfig.CLEAR_HISTORY_ON_FOOD_EATEN_THRESHOLD && isAtThreshold) {
                this.history.clear();
                return true;
            }
        }
        return this.history.add(foodEaten);
    }

    @Override
    public int getFoodCountIgnoringFoodGroups(@Nonnull ItemStack food) {
        return this.getFoodCountForFoodGroup(food, null);
    }

    @Override
    public int getFoodCountForFoodGroup(@Nonnull ItemStack food, FoodGroup foodGroup) {
        int count = 0;
        for (FoodEaten foodEaten : this.history) {
            if (foodEaten.itemStack == ItemStack.field_190927_a || !food.func_77969_a(foodEaten.itemStack) && !foodEaten.getFoodGroups().contains(foodGroup)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean containsFoodOrItsFoodGroups(@Nonnull ItemStack food) {
        Set<FoodGroup> foodGroups = FoodGroupRegistry.getFoodGroupsForFood(food);
        for (FoodEaten foodEaten : this.history) {
            if (foodEaten.itemStack == ItemStack.field_190927_a || !food.func_77969_a(foodEaten.itemStack) && !MiscHelper.collectionsOverlap(foodGroups, foodEaten.getFoodGroups())) continue;
            return true;
        }
        return false;
    }

    @Override
    public FoodValues getTotalFoodValuesIgnoringFoodGroups(@Nonnull ItemStack food) {
        return this.getTotalFoodValuesForFoodGroup(food, null);
    }

    @Override
    public FoodValues getTotalFoodValuesForFoodGroup(@Nonnull ItemStack food, FoodGroup foodGroup) {
        int totalHunger = 0;
        float totalSaturation = 0.0f;
        for (FoodEaten foodEaten : this.history) {
            if (foodEaten.itemStack == ItemStack.field_190927_a || !food.func_77969_a(foodEaten.itemStack) && !foodEaten.getFoodGroups().contains(foodGroup)) continue;
            totalHunger += foodEaten.foodValues.hunger;
            totalSaturation += foodEaten.foodValues.getUnboundedSaturationIncrement();
        }
        if (totalHunger == 0) {
            return new FoodValues(0, 0.0f);
        }
        return new FoodValues(totalHunger, totalSaturation);
    }

    @Override
    public FoodQueue getHistory() {
        return this.history;
    }

    @Override
    public int getHistoryLengthInRelevantUnits() {
        return ModConfig.USE_HUNGER_QUEUE ? ((FixedHungerQueue)this.history).hunger() : this.history.size();
    }

    @Override
    public FoodEaten getLastEatenFood() {
        return (FoodEaten)this.history.peekLast();
    }

    @Override
    public Set<FoodGroup> getDistinctFoodGroups() {
        HashSet<FoodGroup> distinctFoodGroups = new HashSet<FoodGroup>();
        for (FoodEaten foodEaten : this.history) {
            if (foodEaten.itemStack == ItemStack.field_190927_a) continue;
            distinctFoodGroups.addAll(foodEaten.getFoodGroups());
        }
        return distinctFoodGroups;
    }

    @Override
    public void reset() {
        this.history.clear();
        this.totalFoodsEatenAllTime = 0;
        this.wasGivenFoodJournal = false;
        this.ticksActive = 0L;
    }

    @Override
    public void validate() {
        ArrayList<FoodEaten> invalidFoods = new ArrayList<FoodEaten>();
        for (FoodEaten foodEaten : this.history) {
            if (FoodHelper.isValidFood(foodEaten.itemStack)) continue;
            invalidFoods.add(foodEaten);
        }
        this.history.removeAll(invalidFoods);
        this.totalFoodsEatenAllTime -= invalidFoods.size();
    }

    @Nonnull
    public static FoodHistory get(EntityPlayer player) {
        FoodHistory history;
        if (player.hasCapability(CAPABILITY, null) && (history = (FoodHistory)player.getCapability(CAPABILITY, null)) != null) {
            return history;
        }
        throw new RuntimeException("[The Spice Of Life] Food history capability not found for " + player.toString());
    }

    @Override
    public void pack(IByteIO data) {
        data.writeLong(this.ticksActive);
        data.writeShort(this.getHistory().size());
        for (FoodEaten foodEaten : this.getHistory()) {
            foodEaten.pack(data);
        }
    }

    @Override
    public void unpack(IByteIO data) {
        this.ticksActive = data.readLong();
        int historySize = data.readShort();
        for (int i = 0; i < historySize; ++i) {
            FoodEaten foodEaten = new FoodEaten();
            foodEaten.unpack(data);
            this.addFood(foodEaten);
        }
    }

    @Override
    public void writeToNBTData(NBTTagCompound data) {
        NBTTagCompound rootPersistentCompound = this.player.getEntityData().func_74775_l("PlayerPersisted");
        NBTTagCompound nonPersistentCompound = new NBTTagCompound();
        NBTTagCompound persistentCompound = new NBTTagCompound();
        if (!this.history.isEmpty() && (data != null || ModConfig.FOOD_HISTORY_PERSISTS_THROUGH_DEATH)) {
            NBTTagCompound nbtHistory = new NBTTagCompound();
            this.history.writeToNBTData(nbtHistory);
            if (ModConfig.FOOD_HISTORY_PERSISTS_THROUGH_DEATH) {
                persistentCompound.func_74782_a("History", (NBTBase)nbtHistory);
            } else {
                nonPersistentCompound.func_74782_a("History", (NBTBase)nbtHistory);
            }
        }
        if (this.totalFoodsEatenAllTime > 0) {
            persistentCompound.func_74768_a("Total", this.totalFoodsEatenAllTime);
        }
        if (this.wasGivenFoodJournal) {
            persistentCompound.func_74757_a("FoodJournal", this.wasGivenFoodJournal);
        }
        if (this.ticksActive > 0L) {
            persistentCompound.func_74772_a("Ticks", this.ticksActive);
        }
        if (data != null && !nonPersistentCompound.func_82582_d()) {
            data.func_74782_a(TAG_KEY, (NBTBase)nonPersistentCompound);
        }
        if (!persistentCompound.func_82582_d()) {
            rootPersistentCompound.func_74782_a(TAG_KEY, (NBTBase)persistentCompound);
        }
        if (!this.player.getEntityData().func_74764_b("PlayerPersisted")) {
            this.player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)rootPersistentCompound);
        }
    }

    @Override
    public void readFromNBTData(NBTTagCompound data) {
        NBTTagCompound rootPersistentCompound = this.player.getEntityData().func_74775_l("PlayerPersisted");
        if (data != null && data.func_74764_b(TAG_KEY) || rootPersistentCompound.func_74764_b(TAG_KEY)) {
            NBTTagCompound nonPersistentCompound = data != null ? data.func_74775_l(TAG_KEY) : new NBTTagCompound();
            NBTTagCompound persistentCompound = rootPersistentCompound.func_74775_l(TAG_KEY);
            NBTTagCompound nbtHistory = ModConfig.FOOD_HISTORY_PERSISTS_THROUGH_DEATH ? persistentCompound.func_74775_l("History") : nonPersistentCompound.func_74775_l("History");
            this.history.readFromNBTData(nbtHistory);
            this.totalFoodsEatenAllTime = persistentCompound.func_74762_e("Total");
            this.wasGivenFoodJournal = persistentCompound.func_74767_n("FoodJournal");
            this.ticksActive = persistentCompound.func_74763_f("Ticks");
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeToNBTData(compound);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.readFromNBTData(nbt);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CAPABILITY;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CAPABILITY ? this : null);
    }
}

