/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.teamacronymcoders.base.Base;
import com.teamacronymcoders.base.registrysystem.config.ConfigEntry;
import com.teamacronymcoders.base.registrysystem.config.ConfigEntryBuilder;
import com.teamacronymcoders.base.registrysystem.config.ConfigRegistry;
import com.teamacronymcoders.base.util.ItemStackUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictUtils {
    private static Map<String, ItemStack> preferredItemStacks;
    private static List<String> preferredModIds;
    private static List<String> defaultModIds;

    private OreDictUtils() {
    }

    public static void addDefaultModId(String modid) {
        OreDictUtils.addDefaultModId(defaultModIds.size() - 1, modid);
    }

    public static void addDefaultModId(int position, String modid) {
        if (position > defaultModIds.size()) {
            position = defaultModIds.size();
        }
        defaultModIds.add(position, modid);
    }

    public static void setup() {
        preferredItemStacks = Maps.newHashMap();
        preferredModIds = Lists.newArrayList();
        String defaultModIdsString = defaultModIds.stream().collect(Collectors.joining(","));
        ConfigEntry preferredMods = ConfigEntryBuilder.getBuilder("preferredOreDictIds", defaultModIdsString).setArray(true).setCategory("materials").setComment("List for Prioritizing OreDict returns by modid").build();
        Base.instance.getRegistry(ConfigRegistry.class, "CONFIG").addEntry(preferredMods);
        preferredModIds = Arrays.asList(preferredMods.getStringArray());
    }

    @Nonnull
    public static ItemStack getPreferredItemStack(String oreDictName) {
        ItemStack itemStack;
        if (!preferredItemStacks.containsKey(oreDictName)) {
            int bestMatchLevel = preferredModIds.size();
            ItemStack preferredItemStack = ItemStack.field_190927_a;
            NonNullList itemStackList = OreDictionary.getOres((String)oreDictName);
            for (ItemStack itemStack2 : itemStackList) {
                String modid;
                if (!ItemStackUtils.isValid(itemStack2) || !preferredModIds.contains(modid = ItemStackUtils.getModIdFromItemStack(itemStack2))) continue;
                int newMatch = preferredModIds.indexOf(modid);
                bestMatchLevel = newMatch < bestMatchLevel ? newMatch : bestMatchLevel;
                preferredItemStack = itemStack2;
            }
            if (preferredItemStack.func_190926_b() && !itemStackList.isEmpty()) {
                preferredItemStack = (ItemStack)itemStackList.get(0);
            }
            preferredItemStacks.put(oreDictName, preferredItemStack);
        }
        return ItemStackUtils.isValid(itemStack = preferredItemStacks.get(oreDictName)) ? itemStack.func_77946_l() : ItemStack.field_190927_a;
    }

    static {
        defaultModIds = Lists.newArrayList((Object[])new String[]{"base"});
    }
}

