/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.items.minecart;

import com.google.common.collect.Lists;
import com.teamacronymcoders.base.IBaseMod;
import com.teamacronymcoders.base.IModAware;
import com.teamacronymcoders.base.client.models.IHasModel;
import com.teamacronymcoders.base.entities.EntityMinecartBase;
import com.teamacronymcoders.base.items.minecart.DispenseItemMinecartBase;
import com.teamacronymcoders.base.util.ItemStackUtils;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockRailBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ItemMinecartBase
extends ItemMinecart
implements IHasModel,
IModAware {
    private IBaseMod mod;
    private String name;

    public ItemMinecartBase(String name) {
        super(EntityMinecart.Type.TNT);
        this.name = "minecart_" + name;
        this.func_77655_b(this.name);
        this.field_77787_bX = true;
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new DispenseItemMinecartBase());
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos blockPos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = player.func_184586_b(hand);
        return this.placeCart(itemStack, world, blockPos, this.getEntityFromItem(world, itemStack));
    }

    public EnumActionResult placeCart(ItemStack itemStack, World world, BlockPos blockPos, EntityMinecartBase entityMinecart) {
        if (ItemStackUtils.isValid(itemStack) && BlockRailBase.func_176562_d((World)world, (BlockPos)blockPos)) {
            if (itemStack.func_82837_s()) {
                entityMinecart.func_96094_a(itemStack.func_82833_r());
            }
            if (!world.field_72995_K) {
                entityMinecart.field_70165_t = (float)blockPos.func_177958_n() + 0.5f;
                entityMinecart.field_70163_u = (float)blockPos.func_177956_o() + 0.5f;
                entityMinecart.field_70161_v = (float)blockPos.func_177952_p() + 0.5f;
                world.func_72838_d((Entity)entityMinecart);
            }
            itemStack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public List<String> getModelNames(List<String> modelNames) {
        modelNames.add(this.name);
        return modelNames;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.addAll((Collection)this.getAllSubItems(Lists.newArrayList()));
        }
    }

    @Override
    public Item getItem() {
        return this;
    }

    @Override
    public IBaseMod getMod() {
        return this.mod;
    }

    @Override
    public void setMod(IBaseMod mod) {
        this.mod = mod;
    }

    @Nonnull
    public abstract EntityMinecartBase getEntityFromItem(World var1, ItemStack var2);
}

