/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.tileentity;

import melonslise.lambda.common.block.BlockLaserTripmine;
import melonslise.lambda.common.sound.LambdaSounds;
import melonslise.lambda.utility.LambdaSelectors;
import melonslise.lambda.utility.LambdaUtilities;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;

public class TileEntityLaserTripmine
extends TileEntity
implements ITickable {
    protected EntityLivingBase placer;
    protected Vec3d end;
    protected Vec3d start;
    protected int ticks = 60;
    private static final String keyPlacer = "placer";
    private static final String keyActive = "active";

    public void func_73660_a() {
        if (this.ticks == 0) {
            EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockLaserTripmine.FACING);
            Vec3d offset = new Vec3d(facing.func_176730_m()).func_186678_a(0.5);
            this.start = new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5).func_178788_d(offset);
            BlockPos end = LambdaUtilities.getFirstBlockInDirection(this.field_145850_b, this.field_174879_c, facing, LambdaSelectors.SOLIDS, 24);
            this.end = new Vec3d((double)end.func_177958_n() + 0.5, (double)end.func_177956_o() + 0.5, (double)end.func_177952_p() + 0.5).func_178788_d(offset);
            if (!this.field_145850_b.func_72839_b(null, LambdaUtilities.createAABB(this.start, this.end)).isEmpty()) {
                this.field_145850_b.func_175698_g(this.field_174879_c);
            }
        } else {
            if (this.ticks == 60) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, LambdaSounds.weapon_tripmine_charge, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else if (this.ticks == 1) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, LambdaSounds.weapon_tripmine_activate, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            --this.ticks;
            this.func_70296_d();
        }
    }

    public void setPlacer(EntityLivingBase placer) {
        EntityLivingBase old = this.placer;
        this.placer = placer;
        if (old != this.placer) {
            this.func_70296_d();
        }
    }

    public EntityLivingBase getPlacer() {
        return this.placer;
    }

    public int getChargeTicks() {
        return this.ticks;
    }

    public Vec3d getLaserStart() {
        return this.start;
    }

    public Vec3d getLaserEnd() {
        return this.end;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b(keyPlacer)) {
            this.placer = (EntityLivingBase)((WorldServer)this.field_145850_b).func_175733_a(nbt.func_186857_a(keyPlacer));
        }
        this.ticks = nbt.func_74767_n(keyActive) ? 0 : 60;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.placer != null) {
            nbt.func_186854_a(keyPlacer, this.placer.func_110124_au());
        }
        nbt.func_74757_a(keyActive, this.ticks == 0);
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_74757_a(keyActive, this.ticks == 0);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound nbt) {
        super.handleUpdateTag(nbt);
        this.ticks = nbt.func_74767_n(keyActive) ? 0 : 60;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return super.func_189518_D_();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.ticks == 0 && this.start != null && this.end != null ? new AxisAlignedBB(this.start.field_72450_a, this.start.field_72448_b, this.start.field_72449_c, this.end.field_72450_a, this.end.field_72448_b, this.end.field_72449_c) : super.getRenderBoundingBox();
    }
}

