/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.network.message.client;

import io.netty.buffer.ByteBuf;
import melonslise.lambda.common.entity.alien.EntityVortigaunt;
import melonslise.lambda.common.sound.LambdaSounds;
import melonslise.lambda.common.sound.moving.MovingSoundVortigaunt;
import melonslise.lambda.utility.LambdaUtilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageVortigaunt
implements IMessage {
    private int id;
    private int value;
    private EVortigauntAction action;

    public MessageVortigaunt() {
    }

    public MessageVortigaunt(EntityVortigaunt entity, EVortigauntAction action, int value) {
        this.id = entity.func_145782_y();
        this.action = action;
        this.value = value;
    }

    public void fromBytes(ByteBuf buffer) {
        this.id = buffer.readInt();
        this.action = LambdaUtilities.readEnum(buffer, EVortigauntAction.class);
        this.value = buffer.readShort();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.id);
        LambdaUtilities.writeEnum(buffer, this.action);
        buffer.writeShort((int)((short)this.value));
    }

    public static enum EVortigauntAction {
        CLAW,
        START_CHARGE,
        CHARGE;

    }

    public static class Handler
    implements IMessageHandler<MessageVortigaunt, IMessage> {
        public IMessage onMessage(final MessageVortigaunt message, MessageContext context) {
            final Minecraft mc = Minecraft.func_71410_x();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Entity entity = mc.field_71441_e.func_73045_a(message.id);
                    if (!(entity instanceof EntityVortigaunt)) {
                        return;
                    }
                    EntityVortigaunt vortigaunt = (EntityVortigaunt)entity;
                    switch (message.action) {
                        case CLAW: {
                            vortigaunt.claw = message.value;
                            break;
                        }
                        case START_CHARGE: {
                            vortigaunt.charge = message.value;
                            mc.func_147118_V().func_147682_a((ISound)new MovingSoundVortigaunt(vortigaunt, LambdaSounds.zap, vortigaunt.func_184176_by()));
                            break;
                        }
                        case CHARGE: {
                            vortigaunt.charge = message.value;
                            break;
                        }
                    }
                }
            };
            mc.func_152344_a(runnable);
            return null;
        }
    }
}

