/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.item.weapon;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import melonslise.lambda.common.item.api.AItemUsable;
import melonslise.lambda.common.item.api.ISuitDisplayProvider;
import melonslise.lambda.common.network.LambdaNetworks;
import melonslise.lambda.common.network.message.client.MessageSound;
import melonslise.lambda.common.network.message.client.MessageTauBeam;
import melonslise.lambda.common.network.message.client.MessageTauParticles;
import melonslise.lambda.common.sound.LambdaSounds;
import melonslise.lambda.utility.LambdaSelectors;
import melonslise.lambda.utility.LambdaUtilities;
import melonslise.lambda.utility.SuitRenderUtilities;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTau
extends AItemUsable
implements ISuitDisplayProvider {
    protected Item ammo;
    public static final String keyCharge = "charge";

    public ItemTau(String name, Item ammo) {
        super(name);
        this.ammo = ammo;
    }

    protected boolean fire(EntityPlayer player, EnumHand hand, ItemStack stack, int ammo, int charge, int cooldown) {
        if (player.func_70055_a(Material.field_151586_h) || this.getCooldown(stack) > 0 || !LambdaUtilities.consumeItem(player, this.ammo, ammo)) {
            return false;
        }
        this.setCooldown(stack, cooldown);
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, LambdaSounds.weapon_tau_shot, SoundCategory.PLAYERS, 1.0f, 1.0f);
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, LambdaSounds.weapon_tau_discharge, SoundCategory.PLAYERS, 1.0f, 1.0f);
        Vec3d look = player.func_70040_Z();
        Vec3d start = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d end = LambdaUtilities.sampleSphereCap(look, (float)Math.PI / (180.0f - (float)(charge - 1) * 10.0f)).func_186678_a(64.0).func_178787_e(start);
        this.fireBeam(player, start, end, charge, true);
        if (charge <= 1) {
            return true;
        }
        Vec3d motion = look.func_186678_a((double)charge * -0.22);
        player.func_70024_g(motion.field_72450_a, motion.field_72448_b * 0.8, motion.field_72449_c);
        player.field_70133_I = true;
        return true;
    }

    protected void fireBeam(EntityPlayer player, Vec3d start, Vec3d end, int charge, boolean first) {
        ArrayList<RayTraceResult> results = LambdaUtilities.rayTraceBlocks(player.field_70170_p, start, end, false, true, LambdaSelectors.SHATTERABLES);
        RayTraceResult result = null;
        if (!results.isEmpty() && !LambdaSelectors.SHATTERABLES.apply((Object)player.field_70170_p.func_180495_p(results.get(results.size() - 1).func_178782_a()))) {
            result = results.get(results.size() - 1);
            results.remove(results.size() - 1);
            end = result.field_72307_f;
        }
        ArrayList<RayTraceResult> targets = LambdaUtilities.rayTraceEntities(player.field_70170_p, start, end, Lists.newArrayList((Object[])new Entity[]{player}), LambdaSelectors.PROJECTILE_TARGETS);
        int hitsLeft = charge;
        boolean stopOnEntity = false;
        while (!targets.isEmpty() && hitsLeft > 0) {
            RayTraceResult result1 = LambdaUtilities.getClosestIntersectedEntity(start, targets, null);
            if (result1.field_72308_g.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 6.0f * (float)hitsLeft)) {
                result1.field_72308_g.field_70172_ad = 0;
            }
            targets.remove(result1);
            if (--hitsLeft > 0) continue;
            end = result1.field_72307_f;
            stopOnEntity = true;
        }
        LambdaUtilities.sendToAllTrackingAndPlayer((EntityPlayerMP)player, LambdaNetworks.network, new MessageTauBeam((EntityPlayer)(first ? player : null), start, end, charge != 1));
        double distance = start.func_72436_e(end);
        for (RayTraceResult result1 : results) {
            if (!(start.func_72436_e(result1.field_72307_f) < distance)) continue;
            player.field_70170_p.func_175655_b(result1.func_178782_a(), false);
        }
        if (hitsLeft <= 0 || stopOnEntity || result == null) {
            return;
        }
        Vec3i normal = result.field_178784_b.func_176730_m();
        int chargeParticles = charge;
        if (this.reflectBeam(player, start, end, new Vec3d(normal), hitsLeft)) {
            chargeParticles = 1;
        }
        LambdaNetworks.network.sendToAllTracking((IMessage)new MessageTauParticles(end, normal, chargeParticles), new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.getDimension(), end.field_72450_a, end.field_72448_b, end.field_72449_c, 0.0));
    }

    protected boolean reflectBeam(EntityPlayer player, Vec3d start, Vec3d end, Vec3d normal, int charge) {
        Vec3d direction = end.func_178788_d(start).func_72432_b();
        if (!this.canReflect(normal.func_72430_b(direction))) {
            return false;
        }
        start = end.func_178787_e(normal.func_186678_a(0.01));
        end = direction.func_178788_d(normal.func_186678_a(2.0 * direction.func_72430_b(normal))).func_186678_a(64.0).func_178787_e(start);
        this.fireBeam(player, start, end, charge, false);
        return true;
    }

    protected boolean canReflect(double angle) {
        return (angle = Math.abs(angle)) > 0.0 && angle < 0.5;
    }

    @Override
    public boolean continueUsing(EntityPlayer player, EnumHand hand, ItemStack oldStack, ItemStack newStack, int ticks, int type) {
        if (!super.continueUsing(player, hand, oldStack, newStack, ticks, type)) {
            return false;
        }
        return type != 1 || !player.func_70055_a(Material.field_151586_h) && this.getCooldown(oldStack) <= 0 && LambdaUtilities.hasItem(player, this.getAmmo());
    }

    @Override
    protected boolean startPrimaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return true;
    }

    @Override
    protected void primaryUsingTick(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        if (!player.field_70170_p.field_72995_K) {
            this.fire(player, hand, stack, 2, 1, 4);
        }
        int charge = this.getCharge(stack);
        if (!player.func_70055_a(Material.field_151586_h) && LambdaUtilities.hasItem(player, this.ammo)) {
            if (charge != 1) {
                this.setCharge(stack, 1);
            }
        } else if (charge != 0) {
            this.setCharge(stack, 0);
        }
    }

    @Override
    protected void stopPrimaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        if (this.getCharge(stack) != 0) {
            this.setCharge(stack, 0);
        }
    }

    @Override
    protected boolean startSecondaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (player.func_70055_a(Material.field_151586_h) || this.getCooldown(stack) > 0 || !LambdaUtilities.hasItem(player, this.getAmmo())) {
            return false;
        }
        if (!player.field_70170_p.field_72995_K) {
            LambdaUtilities.sendToAllTrackingAndPlayer((EntityPlayerMP)player, LambdaNetworks.network, new MessageSound(player.func_145782_y(), MessageSound.ESound.TAU_CHARGE));
        }
        this.setCharge(stack, 1);
        return true;
    }

    @Override
    protected void secondaryUsingTick(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        if (!player.field_70170_p.field_72995_K && ticks % 6 == 0 && ticks <= 78 && LambdaUtilities.consumeItem(player, this.getAmmo(), 1)) {
            this.increaseCharge(stack);
        }
    }

    @Override
    protected void stopSecondaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        if (!player.field_70170_p.field_72995_K) {
            this.fire(player, hand, stack, 0, this.getCharge(stack), 4);
        }
        this.setCharge(stack, 0);
    }

    public Item getAmmo() {
        return this.ammo;
    }

    protected int getCharge(ItemStack stack) {
        return LambdaUtilities.getTag(stack).func_74765_d(keyCharge);
    }

    protected void setCharge(ItemStack stack, int charge) {
        LambdaUtilities.getTag(stack).func_74777_a(keyCharge, charge >= 0 ? (short)charge : (short)0);
    }

    protected void increaseCharge(ItemStack stack) {
        this.setCharge(stack, this.getCharge(stack) + 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(I18n.func_135052_a((String)"item.lambda.weapon.tau.flavor.name", (Object[])new Object[0]));
    }

    @Override
    public void renderDisplay(RenderGameOverlayEvent.Pre event, int color, ItemStack stack, EnumHand hand) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
            SuitRenderUtilities.renderCrosshair(event.getResolution(), color, 48, 24);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            int total = LambdaUtilities.getStackTotal(LambdaUtilities.findStacks((Collection<ItemStack>)Minecraft.func_71410_x().field_71439_g.field_71069_bz.func_75138_a(), this.ammo));
            SuitRenderUtilities.renderAmmo(event.getResolution(), color, Integer.toString(total), 0);
        }
    }
}

