/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.item.weapon;

import com.google.common.collect.Lists;
import java.util.Collection;
import melonslise.lambda.common.item.api.AItemUsable;
import melonslise.lambda.common.item.api.ISuitDisplayProvider;
import melonslise.lambda.common.network.LambdaNetworks;
import melonslise.lambda.common.network.message.client.MessageGluonBeam;
import melonslise.lambda.common.network.message.client.MessageSound;
import melonslise.lambda.common.sound.LambdaSounds;
import melonslise.lambda.utility.LambdaSelectors;
import melonslise.lambda.utility.LambdaUtilities;
import melonslise.lambda.utility.SuitRenderUtilities;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class ItemGluon
extends AItemUsable
implements ISuitDisplayProvider {
    protected Item ammo;

    public ItemGluon(String name, Item ammo) {
        super(name);
        this.ammo = ammo;
    }

    protected boolean fire(EntityPlayer player, EnumHand hand, ItemStack stack, int ammo) {
        RayTraceResult result1;
        Vec3d end;
        if (player.func_70055_a(Material.field_151586_h) || this.getCooldown(stack) > 0 || !LambdaUtilities.consumeItem(player, this.ammo, ammo)) {
            return false;
        }
        Vec3d start = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        RayTraceResult result = player.field_70170_p.func_147447_a(start, end = player.func_70040_Z().func_186678_a(64.0).func_178787_e(start), false, true, false);
        if (result != null) {
            end = result.field_72307_f;
        }
        if ((result1 = LambdaUtilities.rayTraceClosestEntity(player.field_70170_p, start, end, Lists.newArrayList((Object[])new Entity[]{player}), LambdaSelectors.PROJECTILE_TARGETS)) != null && result1.field_72308_g.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 4.0f)) {
            result1.field_72308_g.field_70172_ad = 0;
        }
        return true;
    }

    @Override
    public boolean continueUsing(EntityPlayer player, EnumHand hand, ItemStack oldStack, ItemStack newStack, int ticks, int type) {
        return super.continueUsing(player, hand, oldStack, newStack, ticks, type) && !player.func_70055_a(Material.field_151586_h) && this.getCooldown(oldStack) <= 0 && LambdaUtilities.hasItem(player, this.ammo);
    }

    @Override
    protected boolean startPrimaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (player.func_70055_a(Material.field_151586_h) || this.getCooldown(stack) > 0 || !LambdaUtilities.hasItem(player, this.ammo)) {
            return false;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        LambdaUtilities.sendToAllTrackingAndPlayer((EntityPlayerMP)player, LambdaNetworks.network, new MessageSound(player.func_145782_y(), MessageSound.ESound.GLUON_CHARGE));
        LambdaUtilities.sendToAllTrackingAndPlayer((EntityPlayerMP)player, LambdaNetworks.network, new MessageGluonBeam(player.func_145782_y()));
        return true;
    }

    @Override
    protected void primaryUsingTick(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        if (!player.field_70170_p.field_72995_K && ticks % 2 == 0 && this.fire(player, hand, stack, 1) && ticks == 78) {
            LambdaUtilities.sendToAllTrackingAndPlayer((EntityPlayerMP)player, LambdaNetworks.network, new MessageSound(player.func_145782_y(), MessageSound.ESound.GLUON_BEAM));
        }
    }

    @Override
    protected void stopPrimaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        this.setCooldown(stack, 10);
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, LambdaSounds.weapon_gluon_discharge, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    protected boolean startSecondaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return false;
    }

    public Item getAmmo() {
        return this.ammo;
    }

    @Override
    public void renderDisplay(RenderGameOverlayEvent.Pre event, int color, ItemStack stack, EnumHand hand) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
            SuitRenderUtilities.renderCrosshair(event.getResolution(), color, 72, 24);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            int total = LambdaUtilities.getStackTotal(LambdaUtilities.findStacks((Collection<ItemStack>)Minecraft.func_71410_x().field_71439_g.field_71069_bz.func_75138_a(), this.ammo));
            SuitRenderUtilities.renderAmmo(event.getResolution(), color, Integer.toString(total), 0);
        }
    }
}

