/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.item.weapon;

import melonslise.lambda.common.entity.projectile.EntityBolt;
import melonslise.lambda.common.item.api.AItemReloadable;
import melonslise.lambda.common.sound.LambdaSounds;
import melonslise.lambda.utility.LambdaUtilities;
import melonslise.lambda.utility.SuitRenderUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class ItemCrossbow
extends AItemReloadable {
    public ItemCrossbow(String name, int size, Item ammo) {
        super(name, size, ammo);
    }

    public boolean fire(EntityPlayer player, EnumHand hand, ItemStack stack, int ammo, int cooldown) {
        if (LambdaUtilities.getReloading((Entity)player).get() || this.getMagazine(stack) <= 0 || this.getCooldown(stack) > 0) {
            return false;
        }
        this.consumeMagazine(stack, ammo);
        this.setCooldown(stack, cooldown);
        EntityBolt bolt = new EntityBolt(player.field_70170_p, 14.0f, 1);
        bolt.fire((EntityLivingBase)player, hand, 2.5, 0.0f);
        player.field_70170_p.func_72838_d((Entity)bolt);
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, LambdaSounds.weapon_crossbow_shot, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        super.func_77663_a(stack, world, entity, slot, selected);
        if (world.field_72995_K || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (!selected && player.func_184592_cb() != stack || LambdaUtilities.getReloading((Entity)player).get() || this.getCooldown(stack) != 10) {
            return;
        }
        entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, LambdaSounds.weapon_crossbow_load, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    protected boolean startPrimaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack) {
        super.startPrimaryUsing(player, hand, stack);
        return true;
    }

    @Override
    protected void primaryUsingTick(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        if (!player.field_70170_p.field_72995_K) {
            this.fire(player, hand, stack, 1, 15);
        }
    }

    @Override
    protected boolean startSecondaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack) {
        LambdaUtilities.getZooming((Entity)player).toggleZooming(hand);
        return false;
    }

    @Override
    public int getReloadTime(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return 15;
    }

    @Override
    public int onStartReloading(EntityPlayer player, EnumHand hand, ItemStack stack) {
        LambdaUtilities.getZooming((Entity)player).stopZooming(hand);
        return super.onStartReloading(player, hand, stack);
    }

    @Override
    public void onUpdateReloading(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        if (!player.field_70170_p.field_72995_K && ticks == 10) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, LambdaSounds.weapon_crossbow_load, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public void renderDisplay(RenderGameOverlayEvent.Pre event, int color, ItemStack stack, EnumHand hand) {
        super.renderDisplay(event, color, stack, hand);
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
            SuitRenderUtilities.renderCrosshair(event.getResolution(), color, 0, 24);
        }
    }
}

