/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.event;

import melonslise.lambda.common.block.LambdaBlocks;
import melonslise.lambda.common.capability.LambdaCapabilities;
import melonslise.lambda.common.entity.LambdaEntities;
import melonslise.lambda.common.entity.alien.EntityBarnacle;
import melonslise.lambda.common.item.LambdaItems;
import melonslise.lambda.common.item.api.armor.AItemSuit;
import melonslise.lambda.common.sound.LambdaSounds;
import melonslise.lambda.utility.LambdaUtilities;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;

@Mod.EventBusSubscriber(modid="lambda")
public class LambdaEvents {
    private LambdaEvents() {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        LambdaBlocks.register(event);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        LambdaItems.register(event);
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        LambdaEntities.register(event);
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        LambdaSounds.register(event);
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent event) {
        LambdaCapabilities.attach(event);
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.PlayerChangedDimensionEvent event) {
        LambdaUtilities.getPower((Entity)event.player).synchronize();
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        LambdaUtilities.getPower((Entity)event.player).synchronize();
    }

    @SubscribeEvent
    public static void onMount(EntityMountEvent event) {
        Entity mount = event.getEntityBeingMounted();
        if (event.isDismounting() && mount instanceof EntityBarnacle && mount.func_70089_S() && event.getEntityMounting().func_70089_S()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer && !event.getSource().func_76363_c() && LambdaUtilities.isWearingHazard(entity)) {
            ((AItemSuit)entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b()).applyReduction(event);
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            LambdaUtilities.getUsingItem((Entity)event.player).updateUsing();
            LambdaUtilities.getUsingTile((Entity)event.player).updateUsing();
            LambdaUtilities.getReloading((Entity)event.player).updateReloading();
            LambdaUtilities.getZooming((Entity)event.player).updateZooming();
        }
    }
}

