/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.entity.projectile;

import com.google.common.collect.Lists;
import melonslise.lambda.common.entity.api.AEntityProjectile;
import melonslise.lambda.common.sound.LambdaSounds;
import melonslise.lambda.utility.LambdaSelectors;
import melonslise.lambda.utility.LambdaUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityHornet
extends AEntityProjectile {
    protected Entity target;
    protected double speed = 0.8;
    protected boolean homing;
    public static final String keyHoming = "homing";

    public EntityHornet(World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
        this.func_189654_d(true);
    }

    public EntityHornet(World world, boolean homing) {
        this(world);
        this.homing = homing;
    }

    protected void func_70088_a() {
    }

    @Override
    protected void onHit(RayTraceResult result) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.func_184185_a(LambdaSounds.alien_hornet_buzz, 1.0f, 1.0f);
        if (result.field_72308_g != null) {
            this.damage(result.field_72308_g);
        }
        this.func_70106_y();
    }

    protected void damage(Entity entity) {
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, LambdaSounds.alien_hornet_hit, SoundCategory.PLAYERS, 1.0f, 1.0f);
        if (entity.func_70097_a(DamageSource.func_188403_a((Entity)this, (EntityLivingBase)this.owner), 3.0f)) {
            entity.field_70172_ad = 0;
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        LambdaUtilities.rotateTowardsMotion(this, 0.9f);
        if (!this.field_70170_p.field_72995_K && (this.func_70090_H() || this.field_70173_aa > 120)) {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K && this.homing) {
            Vec3d position = this.func_174791_d();
            if (this.target == null) {
                if (this.field_70173_aa % 3 == 0) {
                    this.target = LambdaUtilities.getClosestEntity(position, LambdaUtilities.subtract(this.field_70170_p.func_175674_a((Entity)this, LambdaUtilities.createAABB(position, position).func_186662_g(3.0), LambdaSelectors.HORNET_TARGETS), Lists.newArrayList((Object[])new EntityLivingBase[]{this.owner})), null);
                }
            } else {
                this.fire(this.field_70165_t, this.field_70163_u, this.field_70161_v, LambdaUtilities.getCenter(this.target.func_174813_aQ()).func_178788_d(position).func_72432_b(), this.speed, 0.0f);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a(keyHoming, this.homing);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.homing = nbt.func_74767_n(keyHoming);
    }
}

