/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.entity.api;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import melonslise.lambda.utility.LambdaSelectors;
import melonslise.lambda.utility.LambdaUtilities;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class AEntityProjectile
extends Entity {
    protected int ticksAir;
    public EntityLivingBase owner;
    public static final String keyOwner = "owner";

    public AEntityProjectile(World world) {
        super(world);
    }

    public void fire(EntityLivingBase entity, double speed, float inaccuracy) {
        this.owner = entity;
        this.fire(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v, entity.func_70040_Z(), speed, inaccuracy);
    }

    public void fire(EntityLivingBase entity, EnumHand hand, double speed, float inaccuracy) {
        this.owner = entity;
        Vec3d start = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
        double length = MathHelper.func_151237_a((double)(inaccuracy == 0.0f ? 64.0 : 7.853981633974483 / (double)MathHelper.func_76129_c((float)inaccuracy)), (double)0.0, (double)64.0);
        Vec3d end = entity.func_70040_Z().func_186678_a(length).func_178787_e(start);
        RayTraceResult result = this.field_70170_p.func_147447_a(start, end, false, true, false);
        if (result != null) {
            end = result.field_72307_f;
        }
        Vec3d offset = start.func_178787_e(LambdaUtilities.getHeldOffset(entity, hand, new Vec3d(-0.3, -0.15, 0.5)));
        this.fire(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c, end.func_178788_d(offset), speed, inaccuracy);
    }

    public void fire(double x, double y, double z, Vec3d direction, double speed, float inaccuracy) {
        this.func_70107_b(x, y, z);
        Vec3d motion = direction = direction.func_72432_b();
        if (inaccuracy != 0.0f) {
            motion = LambdaUtilities.sampleSphereCap(direction, inaccuracy);
        }
        motion = motion.func_186678_a(speed);
        this.field_70159_w = motion.field_72450_a;
        this.field_70181_x = motion.field_72448_b;
        this.field_70179_y = motion.field_72449_c;
        LambdaUtilities.rotateTowardsMotion(this, 1.0f);
    }

    public void func_70071_h_() {
        RayTraceResult result1;
        super.func_70071_h_();
        if (this.field_70173_aa > 600) {
            this.func_70106_y();
            return;
        }
        ++this.ticksAir;
        Vec3d start = this.func_174791_d();
        Vec3d end = start.func_72441_c(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        RayTraceResult result = null;
        ArrayList<RayTraceResult> results = LambdaUtilities.rayTraceBlocks(this.field_70170_p, start, start.func_72441_c(this.field_70159_w, this.field_70181_x, this.field_70179_y), false, true, this.getPenetratedBlocks());
        if (!(results.isEmpty() || this.getPenetratedBlocks() != null && this.getPenetratedBlocks().apply((Object)this.field_70170_p.func_180495_p(results.get(results.size() - 1).func_178782_a())))) {
            result = results.get(results.size() - 1);
            end = results.get((int)(results.size() - 1)).field_72307_f;
            results.remove(results.size() - 1);
        }
        if ((result1 = LambdaUtilities.rayTraceClosestEntity(this.field_70170_p, start, end, this.ticksAir >= 20 ? Lists.newArrayList((Object[])new Entity[]{this}) : Lists.newArrayList((Object[])new Entity[]{this, this.owner}), LambdaSelectors.PROJECTILE_TARGETS)) != null) {
            end = result1.field_72307_f;
            result = result1;
        }
        double distance = start.func_72436_e(end);
        for (RayTraceResult result2 : results) {
            if (!(start.func_72436_e(result2.field_72307_f) < distance) || ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)result2)) continue;
            this.onHit(result2);
        }
        if (result != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)result)) {
            this.onHit(result);
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.func_70090_H()) {
            for (int a = 0; a < 4; ++a) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            double multiplier = this.getWaterResistance();
            this.field_70159_w *= multiplier;
            this.field_70181_x *= multiplier;
            this.field_70179_y *= multiplier;
        }
        if (!this.func_189652_ae()) {
            this.field_70181_x -= this.getGravity();
        }
    }

    protected Predicate<IBlockState> getPenetratedBlocks() {
        return null;
    }

    protected abstract void onHit(RayTraceResult var1);

    public double getWaterResistance() {
        return 0.9;
    }

    public double getGravity() {
        return 0.04;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        if (this.owner != null) {
            nbt.func_186854_a(keyOwner, this.owner.func_110124_au());
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b(keyOwner)) {
            this.owner = (EntityLivingBase)((WorldServer)this.field_70170_p).func_175733_a(nbt.func_186857_a(keyOwner));
        }
    }

    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * AEntityProjectile.func_184183_bd()) * d0;
    }
}

