/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.entity.alien;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.Set;
import melonslise.lambda.common.entity.api.AEntityAlien;
import melonslise.lambda.common.network.LambdaNetworks;
import melonslise.lambda.common.network.message.client.MessageVortigaunt;
import melonslise.lambda.common.network.message.client.MessageVortigauntTarget;
import melonslise.lambda.common.sound.LambdaSounds;
import melonslise.lambda.utility.LambdaSelectors;
import melonslise.lambda.utility.LambdaUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityVortigaunt
extends AEntityAlien {
    public static final float fleeHealth = 6.0f;
    public static final float arcDamage = 7.0f;
    public static final float arcHeal = 3.0f;
    public static final double reach = 2.0;
    public static final double range = 10.0;
    public int arc;
    public int charge;
    public int claw;
    public int cooldownArc;
    public int cooldownClaw;
    public Vec3d target;
    public Set<BlockPos> positions = new HashSet<BlockPos>();
    public float rotationHand;
    public float oldRotationHand;

    public EntityVortigaunt(World world) {
        super(world);
        this.func_70105_a(0.9f, 1.8f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIFlee(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIClaw(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AICharge(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIFollow(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    public void claw(EntityLivingBase entity) {
        if (entity != null && this.func_70068_e((Entity)entity) <= 4.0) {
            this.func_70652_k((Entity)entity);
            this.func_184185_a(this.getStrikeSound(), this.func_70599_aP(), this.func_70647_i());
        } else {
            this.func_184185_a(this.getMissSound(), this.func_70599_aP(), this.func_70647_i());
        }
    }

    public void shoot() {
        if (!this.field_70170_p.field_72995_K) {
            RayTraceResult result1;
            Vec3d start = new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
            RayTraceResult result = this.field_70170_p.func_147447_a(start, this.target, false, true, false);
            if (result != null) {
                this.target = result.field_72307_f;
            }
            if ((result1 = LambdaUtilities.rayTraceClosestEntity(this.field_70170_p, start, this.target, Lists.newArrayList((Object[])new Entity[]{this}), LambdaSelectors.PROJECTILE_TARGETS)) != null) {
                if (result1.field_72308_g.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 7.0f)) {
                    this.func_70691_i(3.0f);
                }
                this.target = result1.field_72307_f;
            }
            LambdaNetworks.network.sendToAllTracking((IMessage)new MessageVortigauntTarget(this, this.target), (Entity)this);
        }
        this.func_184185_a(this.getArcSound(), this.func_70599_aP(), 1.6f);
        this.cooldownArc = 20;
        this.arc = 5;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.oldRotationHand = this.rotationHand;
        if (this.claw > 0) {
            if (this.claw % 6 == 0) {
                this.claw(this.func_70638_az());
            }
            --this.claw;
            if (this.claw == 0) {
                this.cooldownClaw = 6;
            }
        }
        if (this.arc > 0) {
            --this.arc;
        }
        if (this.charge > 0) {
            --this.charge;
            if (this.charge == 0) {
                this.shoot();
            }
        }
        if (this.cooldownArc > 0) {
            --this.cooldownArc;
        }
        if (this.cooldownClaw > 0) {
            --this.cooldownClaw;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.charge > 0) {
                this.rotationHand = MathHelper.func_76126_a((float)((float)this.charge * 0.2f));
            } else {
                int clawTicks = this.claw - 1;
                if (clawTicks > 0) {
                    if (clawTicks <= 6 || clawTicks > 12) {
                        if (clawTicks > 12) {
                            clawTicks -= 12;
                        }
                        this.rotationHand = MathHelper.func_76134_b((float)((float)clawTicks * 1.1f));
                    } else {
                        this.rotationHand = MathHelper.func_76134_b((float)((float)(clawTicks - 6) * 1.1f));
                    }
                }
            }
        }
    }

    protected SoundEvent getMissSound() {
        return LambdaSounds.alien_zombie_miss;
    }

    protected SoundEvent getStrikeSound() {
        return LambdaSounds.alien_zombie_strike;
    }

    @Override
    protected SoundEvent getAlertSound() {
        return LambdaSounds.alien_vortigaunt_alert;
    }

    protected SoundEvent func_184615_bR() {
        return LambdaSounds.alien_vortigaunt_die;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return LambdaSounds.alien_vortigaunt_pain;
    }

    protected SoundEvent func_184639_G() {
        if (this.func_70638_az() == null) {
            return LambdaSounds.alien_vortigaunt_word;
        }
        return null;
    }

    protected SoundEvent getArcSound() {
        return LambdaSounds.alien_vortigaunt_shoot;
    }

    protected SoundEvent getChargeSound() {
        return LambdaSounds.zap;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.arc > 0 && this.target != null ? new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.target.field_72450_a, this.target.field_72448_b, this.target.field_72449_c) : super.func_184177_bl();
    }

    public static class AIFace
    extends EntityAIBase {
        protected EntityVortigaunt entity;

        public AIFace(EntityVortigaunt entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.entity.func_70638_az();
            return target != null && target.func_70089_S() && this.entity.func_110143_aJ() > 6.0f && this.entity.func_70635_at().func_75522_a((Entity)target);
        }

        public void func_75246_d() {
            this.entity.func_70671_ap().func_75651_a((Entity)this.entity.func_70638_az(), 30.0f, 30.0f);
        }
    }

    public static class AIFollow
    extends EntityAIBase {
        protected EntityVortigaunt entity;

        public AIFollow(EntityVortigaunt entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.entity.func_70638_az();
            if (target != null && target.func_70089_S() && this.entity.func_110143_aJ() > 6.0f && this.entity.claw == 0 && this.entity.charge == 0) {
                return this.entity.func_70068_e((Entity)target) > 100.0 || !this.entity.func_70635_at().func_75522_a((Entity)target);
            }
            return false;
        }

        public void func_75249_e() {
            this.entity.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            this.entity.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            this.entity.func_70661_as().func_75497_a((Entity)this.entity.func_70638_az(), 1.0);
            this.entity.func_70671_ap().func_75651_a((Entity)this.entity.func_70638_az(), 30.0f, 30.0f);
        }
    }

    public static class AICharge
    extends EntityAIBase {
        protected EntityVortigaunt entity;

        public AICharge(EntityVortigaunt entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.entity.func_70638_az();
            if (target != null && target.func_70089_S() && this.entity.charge == 0 && this.entity.cooldownArc == 0 && this.entity.claw == 0 && this.entity.func_110143_aJ() > 6.0f && this.entity.func_70635_at().func_75522_a((Entity)target)) {
                double distance = this.entity.func_70068_e((Entity)target);
                return distance > 4.0 && distance <= 100.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            EntityLivingBase target = this.entity.func_70638_az();
            return target != null && target.func_70089_S() && this.entity.charge != 0 && this.entity.claw == 0 && this.entity.func_110143_aJ() > 6.0f;
        }

        public void func_75249_e() {
            this.entity.charge = 25;
            LambdaNetworks.network.sendToAllTracking((IMessage)new MessageVortigaunt(this.entity, MessageVortigaunt.EVortigauntAction.START_CHARGE, 25), (Entity)this.entity);
        }

        public void func_75251_c() {
            this.entity.charge = 0;
            LambdaNetworks.network.sendToAllTracking((IMessage)new MessageVortigaunt(this.entity, MessageVortigaunt.EVortigauntAction.CHARGE, 0), (Entity)this.entity);
        }

        public void func_75246_d() {
            EntityLivingBase target = this.entity.func_70638_az();
            if (target != null && this.entity.func_70635_at().func_75522_a((Entity)target)) {
                Vec3d start = new Vec3d(this.entity.field_70165_t, this.entity.field_70163_u + (double)this.entity.field_70131_O / 2.0, this.entity.field_70161_v);
                this.entity.target = new Vec3d(target.field_70165_t, target.field_70163_u + (double)target.field_70131_O / 2.0, target.field_70161_v).func_178788_d(start).func_72432_b().func_186678_a(64.0).func_178787_e(start);
            }
        }
    }

    public static class AIClaw
    extends EntityAIBase {
        protected EntityVortigaunt entity;

        public AIClaw(EntityVortigaunt entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.entity.func_70638_az();
            return target != null && target.func_70089_S() && this.entity.claw == 0 && this.entity.cooldownClaw == 0 && this.entity.func_70068_e((Entity)target) <= 4.0 && this.entity.func_70635_at().func_75522_a((Entity)target);
        }

        public boolean func_75253_b() {
            EntityLivingBase target = this.entity.func_70638_az();
            return target != null && target.func_70089_S() && this.entity.claw != 0 && this.entity.func_110143_aJ() > 6.0f;
        }

        public void func_75249_e() {
            this.entity.claw = 18;
            LambdaNetworks.network.sendToAllTracking((IMessage)new MessageVortigaunt(this.entity, MessageVortigaunt.EVortigauntAction.CLAW, 18), (Entity)this.entity);
        }

        public void func_75251_c() {
            this.entity.claw = 0;
            LambdaNetworks.network.sendToAllTracking((IMessage)new MessageVortigaunt(this.entity, MessageVortigaunt.EVortigauntAction.CLAW, 0), (Entity)this.entity);
        }
    }

    public static class AIFlee
    extends EntityAIBase {
        protected EntityVortigaunt entity;

        public AIFlee(EntityVortigaunt entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.entity.func_70643_av();
            return target != null && target.func_70089_S() && this.entity.func_110143_aJ() <= 6.0f;
        }

        public void func_75249_e() {
            this.entity.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            this.entity.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            if (this.entity.func_70661_as().func_75500_f()) {
                EntityLivingBase target = this.entity.func_70643_av();
                Vec3d position = RandomPositionGenerator.func_75461_b((EntityCreature)this.entity, (int)16, (int)7, (Vec3d)new Vec3d(target.field_70165_t, target.field_70163_u, target.field_70161_v));
                if (position != null) {
                    this.entity.func_70661_as().func_75492_a(position.field_72450_a, position.field_72448_b, position.field_72449_c, 1.0);
                }
            }
        }
    }
}

