/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.entity.alien;

import melonslise.lambda.common.entity.alien.EntityHeadcrabZombie;
import melonslise.lambda.common.entity.api.AEntityAlien;
import melonslise.lambda.common.sound.LambdaSounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityHeadcrab
extends AEntityAlien {
    public static final double distance = 7.0;
    protected EntityAINearestAttackableTarget target1;
    protected EntityAINearestAttackableTarget target2;
    protected EntityAIHurtByTarget target3;

    public EntityHeadcrab(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.3f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIJump(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AILatch(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIFollow(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIBite(this));
        this.target3 = new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]);
        this.target1 = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null);
        this.target2 = new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 0, true, false, null);
        this.toggleTargeting(true);
    }

    protected void toggleTargeting(boolean enable) {
        if (enable) {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)this.target3);
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.target1);
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)this.target2);
        } else {
            this.field_70715_bh.func_85156_a((EntityAIBase)this.target3);
            this.field_70715_bh.func_85156_a((EntityAIBase)this.target1);
            this.field_70715_bh.func_85156_a((EntityAIBase)this.target2);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    public void jump(Entity entity) {
        Vec3d motion = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v).func_178788_d(this.func_174791_d()).func_72432_b().func_186678_a(2.0);
        this.field_70159_w = motion.field_72450_a;
        this.field_70181_x = motion.field_72448_b;
        this.field_70179_y = motion.field_72449_c;
    }

    public boolean bite(Entity entity) {
        if (!this.canLatchToHead(entity)) {
            return false;
        }
        if (!this.func_70652_k(entity)) {
            return false;
        }
        this.func_184185_a(this.getBiteSound(), this.func_70599_aP(), this.func_70647_i());
        if (entity instanceof EntityLivingBase && this.func_184218_aH()) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 80, 10));
        }
        return true;
    }

    public void func_70074_a(EntityLivingBase entity) {
        Entity target = this.func_184187_bx();
        EntityHeadcrabZombie zombie = new EntityHeadcrabZombie(this.field_70170_p);
        zombie.func_70012_b(target.field_70165_t, target.field_70163_u, target.field_70161_v, target.field_70177_z, target.field_70125_A);
        this.field_70170_p.func_72838_d((Entity)zombie);
        this.func_70106_y();
    }

    public double getSquareDistanceToHead(Entity entity) {
        return this.func_70092_e(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
    }

    public boolean canLatchToHead(Entity entity) {
        return this.getSquareDistanceToHead(entity) <= (double)0.36f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76379_h) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public double func_70033_W() {
        return 0.4;
    }

    @Override
    protected SoundEvent getAlertSound() {
        return LambdaSounds.alien_headcrab_alert;
    }

    protected SoundEvent getAttackSound() {
        return LambdaSounds.alien_headcrab_attack;
    }

    protected SoundEvent func_184615_bR() {
        return LambdaSounds.alien_headcrab_die;
    }

    protected SoundEvent func_184639_G() {
        if (!this.func_184218_aH() && this.func_70638_az() == null) {
            return LambdaSounds.alien_headcrab_idle;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return LambdaSounds.alien_headcrab_pain;
    }

    protected SoundEvent getBiteSound() {
        return LambdaSounds.alien_headcrab_bite;
    }

    public static class AIBite
    extends EntityAIBase {
        protected EntityHeadcrab entity;
        private int ticks = 0;

        public AIBite(EntityHeadcrab entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            Entity target = this.entity.func_184187_bx();
            if (this.entity.func_184218_aH() && !this.entity.field_70122_E && target != null && target.func_70089_S()) {
                if (target instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)target;
                    return !player.func_184812_l_() && !player.func_175149_v();
                }
                return true;
            }
            return false;
        }

        public void func_75249_e() {
            this.entity.toggleTargeting(false);
        }

        public void func_75251_c() {
            this.ticks = 0;
            Entity target = this.entity.func_184187_bx();
            this.entity.func_184210_p();
            if (target instanceof EntityPlayerMP) {
                ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketSetPassengers(target));
            }
            this.entity.toggleTargeting(true);
        }

        public void func_75246_d() {
            Entity target = this.entity.func_184187_bx();
            ++this.ticks;
            if (this.ticks % 20 == 0) {
                this.ticks = 0;
                if (!this.entity.bite(target)) {
                    this.entity.func_184210_p();
                    if (target instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketSetPassengers(target));
                    }
                }
            }
        }
    }

    public static class AILatch
    extends EntityAIBase {
        protected EntityHeadcrab entity;

        public AILatch(EntityHeadcrab entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.entity.func_70638_az();
            return !this.entity.func_184218_aH() && !this.entity.field_70122_E && target != null && target.func_70089_S();
        }

        public void func_75246_d() {
            EntityLivingBase target = this.entity.func_70638_az();
            if (this.entity.bite((Entity)target) && target.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && this.entity.func_184205_a((Entity)target, true) && target instanceof EntityPlayerMP) {
                ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketSetPassengers((Entity)target));
            }
        }
    }

    public static class AIFollow
    extends EntityAIBase {
        protected EntityHeadcrab entity;

        public AIFollow(EntityHeadcrab entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.entity.func_70638_az();
            if (!this.entity.func_184218_aH() && target != null && target.func_70089_S()) {
                return this.entity.getSquareDistanceToHead((Entity)target) > 49.0 || !this.entity.func_70635_at().func_75522_a((Entity)target);
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        public void func_75249_e() {
            this.entity.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            this.entity.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            this.entity.func_70661_as().func_75497_a((Entity)this.entity.func_70638_az(), 1.0);
            this.entity.func_70671_ap().func_75651_a((Entity)this.entity.func_70638_az(), 30.0f, 30.0f);
        }
    }

    public static class AIJump
    extends EntityAIBase {
        protected EntityHeadcrab entity;
        private int ticks = 0;

        public AIJump(EntityHeadcrab entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.entity.func_70638_az();
            return this.entity.field_70122_E && !this.entity.func_184218_aH() && target != null && target.func_70089_S() && this.entity.getSquareDistanceToHead((Entity)target) <= 49.0 && this.entity.func_70635_at().func_75522_a((Entity)target);
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        public void func_75246_d() {
            ++this.ticks;
            if (this.ticks % 30 == 0) {
                this.ticks = 0;
                this.entity.jump((Entity)this.entity.func_70638_az());
                this.entity.func_184185_a(this.entity.getAttackSound(), this.entity.func_70599_aP(), this.entity.func_70647_i());
            }
        }
    }
}

