/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.entity.alien;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import melonslise.lambda.common.loot.LambdaLoot;
import melonslise.lambda.common.network.LambdaNetworks;
import melonslise.lambda.common.network.message.client.MessageBarnacle;
import melonslise.lambda.common.sound.LambdaSounds;
import melonslise.lambda.utility.LambdaSelectors;
import melonslise.lambda.utility.LambdaUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBarnacle
extends EntityMob {
    public static final double tongueSpeed = 0.06;
    public double tongueLength;
    protected int biteDelay;

    public EntityBarnacle(World world) {
        super(world);
        this.func_70105_a(0.8f, 1.0f);
        this.func_189654_d(true);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
    }

    public Entity getTarget() {
        List passengers = this.func_184188_bt();
        return passengers.isEmpty() ? null : (Entity)passengers.get(0);
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
    }

    public void func_70071_h_() {
        BlockPos position = this.func_180425_c();
        if (!this.field_70170_p.field_72995_K && !this.field_70170_p.func_180495_p(position.func_177984_a()).func_185904_a().func_76220_a()) {
            this.func_70106_y();
        }
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        super.func_70071_h_();
        if (this.func_70089_S()) {
            Entity target = this.getTarget();
            if (target == null) {
                BlockPos ground = LambdaUtilities.getFirstBlockInDirection(this.field_70170_p, position, EnumFacing.DOWN, LambdaSelectors.SOLIDS, 24).func_177984_a();
                this.tongueLength = this.field_70163_u - (double)ground.func_177956_o() > -this.tongueLength + 0.06 ? (this.tongueLength -= 0.06) : (double)ground.func_177956_o() - this.field_70163_u;
                if (this.field_70170_p.field_72995_K) {
                    return;
                }
                Iterator iterator = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB((double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), (double)position.func_177958_n() + 1.0, (double)position.func_177956_o() + this.tongueLength, (double)position.func_177952_p() + 1.0)).iterator();
                while (this.func_184188_bt().isEmpty() && iterator.hasNext()) {
                    Entity entity = (Entity)iterator.next();
                    if (!this.isLiftable(entity)) continue;
                    this.startPulling(entity);
                }
            } else if (this.canChew(target)) {
                if (this.field_70170_p.field_72995_K) {
                    return;
                }
                if (this.biteDelay == 0) {
                    this.func_184185_a(this.getBiteSound(), this.func_70599_aP(), this.func_70647_i());
                }
                ++this.biteDelay;
                if (this.biteDelay % 30 == 0 && !this.bite(target)) {
                    target.func_184210_p();
                }
            } else {
                this.pull(target);
            }
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean isLiftable(Entity entity) {
        return entity.func_70089_S() && entity.field_70131_O <= 2.0f && entity.field_70130_N <= 2.0f;
    }

    public boolean bite(Entity entity) {
        this.func_184185_a(this.getChewSound(), this.func_70599_aP(), this.func_70647_i());
        if (!this.func_70652_k(entity)) {
            return false;
        }
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 80, 10));
        }
        return true;
    }

    public boolean canChew(Entity entity) {
        double y = entity.field_70163_u + (double)entity.field_70131_O;
        return y >= this.field_70163_u + (double)this.field_70131_O / 2.0;
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public double func_70042_X() {
        return this.tongueLength - (double)this.getTarget().field_70131_O;
    }

    public boolean startPulling(Entity entity) {
        if (!entity.func_184205_a((Entity)this, true)) {
            return false;
        }
        this.tongueLength = entity.field_70163_u + (double)entity.field_70131_O - this.field_70163_u;
        LambdaNetworks.network.sendToAllTracking((IMessage)new MessageBarnacle(this, this.tongueLength), (Entity)this);
        this.biteDelay = 0;
        this.func_184185_a(this.getAlertSound(), this.func_70599_aP(), this.func_70647_i());
        return true;
    }

    public void pull(Entity entity) {
        this.tongueLength += 0.06;
    }

    @Nullable
    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_190926_b()) {
            return null;
        }
        EntityItem item = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
        item.func_174869_p();
        if (this.captureDrops) {
            this.capturedDrops.add(item);
        } else {
            this.field_70170_p.func_72838_d((Entity)item);
        }
        return item;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LambdaLoot.ENTITIES_BARNACLE;
    }

    protected SoundEvent getAlertSound() {
        return LambdaSounds.alien_barnacle_alert;
    }

    protected SoundEvent getBiteSound() {
        return LambdaSounds.alien_barnacle_bite;
    }

    protected SoundEvent getChewSound() {
        return LambdaSounds.alien_barnacle_chew;
    }

    protected SoundEvent func_184615_bR() {
        return LambdaSounds.alien_barnacle_die;
    }

    protected SoundEvent getTongueSound() {
        return LambdaSounds.alien_barnacle_tongue;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        AxisAlignedBB box = super.func_184177_bl();
        return new AxisAlignedBB(box.field_72340_a, box.field_72338_b + this.tongueLength, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f);
    }
}

