/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.capability.entity;

import melonslise.lambda.common.block.api.ITileUsable;
import melonslise.lambda.common.capability.entity.ICapabilityUsingTile;
import melonslise.lambda.common.network.LambdaNetworks;
import melonslise.lambda.common.network.message.client.ClientMessageUseTile;
import melonslise.lambda.common.network.message.server.ServerMessageUseTile;
import melonslise.lambda.utility.LambdaUtilities;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CapabilityUsingTile
implements ICapabilityUsingTile {
    private static final ResourceLocation id = LambdaUtilities.createLambdaDomain("using.tile");
    private EntityPlayer player;
    private boolean state;
    private BlockPos position;
    private IBlockState focus;
    private int ticks;
    private int type;
    private EnumFacing side;
    private Vec3d hit;

    public CapabilityUsingTile(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public ResourceLocation getID() {
        return id;
    }

    @Override
    public boolean get() {
        return this.state;
    }

    @Override
    public BlockPos getPosition() {
        return this.position;
    }

    @Override
    public IBlockState getFocus() {
        return this.focus;
    }

    @Override
    public int getTicks() {
        return this.ticks;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void startUsing(BlockPos position, EnumFacing side, Vec3d hit, int type) {
        IBlockState focus = this.player.field_70170_p.func_180495_p(position);
        if (!this.state && focus.func_177230_c() instanceof ITileUsable) {
            this.synchronize(true, position, side, hit, type);
            if (((ITileUsable)focus.func_177230_c()).onStartUsing(this.player, position, focus, side, hit, type)) {
                this.state = true;
                this.position = position;
                this.focus = focus;
                this.side = side;
                this.hit = hit;
                this.ticks = 0;
                this.type = type;
            }
        }
    }

    @Override
    public void updateUsing() {
        if (this.state) {
            if (this.player.field_70170_p.field_72995_K) {
                RayTraceResult result = LambdaUtilities.rayTraceBlocks((Entity)this.player, 2.0, false, true);
                BlockPos position = result.func_178782_a();
                if (result != null && position.equals((Object)this.position) && ((ITileUsable)this.focus.func_177230_c()).continueUsing(this.player, this.position, this.focus, this.player.field_70170_p.func_180495_p(this.position))) {
                    ++this.ticks;
                    ((ITileUsable)this.focus.func_177230_c()).onUpdateUsing(this.player, this.position, this.focus, this.ticks, this.type);
                    this.side = result.field_178784_b;
                    this.hit = result.field_72307_f.func_178786_a((double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p());
                } else {
                    this.stopUsing(this.side, this.hit, this.type);
                }
            } else {
                ++this.ticks;
                ((ITileUsable)this.focus.func_177230_c()).onUpdateUsing(this.player, this.position, this.focus, this.ticks, this.type);
            }
        }
    }

    @Override
    public void stopUsing(EnumFacing side, Vec3d hit, int type) {
        if (this.state && this.type == type) {
            this.synchronize(false, this.position, side, hit, type);
            ((ITileUsable)this.focus.func_177230_c()).onStopUsing(this.player, this.position, this.focus, side, hit, this.ticks, this.type);
            this.state = false;
            this.side = side;
            this.hit = hit;
        }
    }

    @Override
    public void synchronize() {
        this.synchronize(this.state, this.position, this.side, this.hit, this.type);
    }

    protected void synchronize(boolean state, BlockPos position, EnumFacing side, Vec3d hit, int type) {
        if (position != null && side != null && hit != null) {
            if (!this.player.field_70170_p.field_72995_K) {
                LambdaNetworks.network.sendToAllTracking((IMessage)new ClientMessageUseTile((Entity)this.player, state, type, position, side, hit), (Entity)this.player);
            } else if (this.player == Minecraft.func_71410_x().field_71439_g) {
                LambdaNetworks.network.sendToServer((IMessage)new ServerMessageUseTile(state, type, position, side, hit));
            }
        }
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound nbt, EnumFacing side) {
        return nbt;
    }

    @Override
    public void deserialize(NBTBase nbt) {
    }
}

