/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.capability.entity;

import melonslise.lambda.common.capability.entity.ICapabilityPower;
import melonslise.lambda.common.network.LambdaNetworks;
import melonslise.lambda.common.network.message.client.MessagePower;
import melonslise.lambda.utility.LambdaUtilities;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CapabilityPower
implements ICapabilityPower {
    private static final ResourceLocation id = LambdaUtilities.createLambdaDomain("power");
    protected EntityPlayer player;
    private float power;
    private static final String keyPower = "power";

    public CapabilityPower(EntityPlayer player) {
        this(player, 0);
    }

    public CapabilityPower(EntityPlayer player, int power) {
        this.player = player;
        this.power = power;
    }

    @Override
    public ResourceLocation getID() {
        return id;
    }

    @Override
    public float get() {
        return this.power;
    }

    @Override
    public boolean set(float power) {
        if (power < 0.0f) {
            this.power = 0.0f;
        } else if (power > 20.0f) {
            this.power = 20.0f;
        } else {
            this.power = power;
            this.synchronize();
            return true;
        }
        this.synchronize();
        return false;
    }

    @Override
    public boolean restore(float power) {
        if (this.power != 20.0f) {
            this.set(this.power + power);
            return true;
        }
        return false;
    }

    @Override
    public boolean consume(float power) {
        if (this.power != 0.0f && this.power - power >= 0.0f) {
            this.set(this.power - power);
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound nbt, EnumFacing side) {
        nbt.func_74776_a(keyPower, this.power);
        return nbt;
    }

    @Override
    public void deserialize(NBTBase nbt) {
        this.power = ((NBTTagCompound)nbt).func_74760_g(keyPower);
    }

    @Override
    public void synchronize() {
        if (this.player instanceof EntityPlayerMP) {
            LambdaNetworks.network.sendTo((IMessage)new MessagePower(this.power), (EntityPlayerMP)this.player);
        }
    }
}

