/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.block.api.charger;

import javax.annotation.Nullable;
import melonslise.lambda.common.block.api.ITileUsable;
import melonslise.lambda.common.block.api.LambdaBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class ABlockCharger
extends LambdaBlock
implements ITileUsable {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool EMPTY = PropertyBool.func_177716_a((String)"empty");
    protected static final AxisAlignedBB BOUNDS_NORTH = new AxisAlignedBB(0.125, 0.0, 0.875, 0.875, 1.0, 1.0);
    protected static final AxisAlignedBB BOUNDS_EAST = new AxisAlignedBB(0.0, 0.0, 0.125, 0.125, 1.0, 0.875);
    protected static final AxisAlignedBB BOUNDS_SOUTH = new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 1.0, 0.125);
    protected static final AxisAlignedBB BOUNDS_WEST = new AxisAlignedBB(0.875, 0.0, 0.125, 1.0, 1.0, 0.875);

    public ABlockCharger(String name, Material material) {
        super(name, material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)EMPTY, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean onStartUsing(EntityPlayer player, BlockPos position, IBlockState state, EnumFacing side, Vec3d hit, int type) {
        TileEntity tile = player.field_70170_p.func_175625_s(position);
        if (tile instanceof ITileUsable) {
            return ((ITileUsable)tile).onStartUsing(player, position, state, side, hit, type);
        }
        return false;
    }

    @Override
    public void onUpdateUsing(EntityPlayer player, BlockPos position, IBlockState state, int ticks, int type) {
        TileEntity tile = player.field_70170_p.func_175625_s(position);
        if (tile instanceof ITileUsable) {
            ((ITileUsable)tile).onUpdateUsing(player, position, state, ticks, type);
        }
    }

    @Override
    public void onStopUsing(EntityPlayer player, BlockPos position, IBlockState state, EnumFacing side, Vec3d hit, int ticks, int type) {
        TileEntity tile = player.field_70170_p.func_175625_s(position);
        if (tile instanceof ITileUsable) {
            ((ITileUsable)tile).onStopUsing(player, position, state, side, hit, ticks, type);
        }
    }

    @Override
    public boolean continueUsing(EntityPlayer player, BlockPos position, IBlockState oldState, IBlockState newState) {
        TileEntity tile = player.field_70170_p.func_175625_s(position);
        if (tile instanceof ITileUsable) {
            return ((ITileUsable)tile).continueUsing(player, position, oldState, newState);
        }
        return ITileUsable.super.continueUsing(player, position, oldState, newState);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos position) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return BOUNDS_SOUTH;
            }
            case EAST: {
                return BOUNDS_WEST;
            }
            case SOUTH: {
                return BOUNDS_NORTH;
            }
            case WEST: {
                return BOUNDS_EAST;
            }
        }
        return field_185505_j;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos position, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, EMPTY});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)EMPTY, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        return i |= ((Boolean)state.func_177229_b((IProperty)EMPTY) != false ? 1 : 0) << 2;
    }

    public boolean func_176198_a(World world, BlockPos position, EnumFacing side) {
        return this.canAttachTo(world, position.func_177976_e(), side) || this.canAttachTo(world, position.func_177974_f(), side) || this.canAttachTo(world, position.func_177978_c(), side) || this.canAttachTo(world, position.func_177968_d(), side);
    }

    private boolean canAttachTo(World world, BlockPos position, EnumFacing facing) {
        IBlockState state = world.func_180495_p(position);
        return !ABlockCharger.func_193382_c((Block)state.func_177230_c()) && state.func_193401_d((IBlockAccess)world, position, facing) == BlockFaceShape.SOLID && !state.func_185897_m();
    }

    public IBlockState func_180642_a(World world, BlockPos position, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (facing.func_176740_k().func_176722_c() && this.canAttachTo(world, position.func_177972_a(facing.func_176734_d()), facing)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
        }
        for (EnumFacing facing1 : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canAttachTo(world, position.func_177972_a(facing1.func_176734_d()), facing1)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing1.func_176734_d());
        }
        return this.func_176223_P();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public abstract TileEntity createTileEntity(World var1, IBlockState var2);
}

