/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.block;

import javax.annotation.Nullable;
import melonslise.lambda.common.block.api.LambdaBlock;
import melonslise.lambda.common.sound.LambdaSoundTypes;
import melonslise.lambda.common.tileentity.TileEntityLaserTripmine;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLaserTripmine
extends LambdaBlock {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    protected static final AxisAlignedBB BOUNDS_NORTH = new AxisAlignedBB(0.21875, 0.3125, 1.0, 0.78125, 0.625, 0.6875);
    protected static final AxisAlignedBB BOUNDS_EAST = new AxisAlignedBB(0.0, 0.3125, 0.21875, 0.3125, 0.625, 0.78125);
    protected static final AxisAlignedBB BOUNDS_SOUTH = new AxisAlignedBB(0.21875, 0.3125, 0.0, 0.78125, 0.625, 0.3125);
    protected static final AxisAlignedBB BOUNDS_WEST = new AxisAlignedBB(1.0, 0.3125, 0.21875, 0.6875, 0.625, 0.78125);
    protected static final AxisAlignedBB BOUNDS_UP = new AxisAlignedBB(0.21875, 0.0, 0.3125, 0.78125, 0.3125, 0.625);
    protected static final AxisAlignedBB BOUNDS_DOWN = new AxisAlignedBB(0.21875, 1.0, 0.6875, 0.78125, 0.6875, 0.375);

    public BlockLaserTripmine(String name, Material material) {
        super(name, material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149672_a(LambdaSoundTypes.TRIPMINE);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos position, Block block, BlockPos position1) {
        if (this.checkForDrop(world, position, state) && !BlockLaserTripmine.canPlaceBlock(world, position, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            world.func_175698_g(position);
        }
    }

    private boolean checkForDrop(World world, BlockPos position, IBlockState state) {
        if (this.func_176196_c(world, position)) {
            return true;
        }
        world.func_175698_g(position);
        return false;
    }

    public void func_180663_b(World world, BlockPos position, IBlockState state) {
        this.explode(world, position);
    }

    public void func_180633_a(World world, BlockPos position, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.getTile(world, position).setPlacer(placer);
    }

    public void explode(World world, BlockPos position) {
        if (!world.field_72995_K) {
            world.func_72876_a((Entity)this.getTile(world, position).getPlacer(), (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), 4.0f, true);
        }
    }

    protected TileEntityLaserTripmine getTile(World world, BlockPos position) {
        return (TileEntityLaserTripmine)world.func_175625_s(position);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos position) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return BOUNDS_NORTH;
            }
            case EAST: {
                return BOUNDS_EAST;
            }
            case SOUTH: {
                return BOUNDS_SOUTH;
            }
            case WEST: {
                return BOUNDS_WEST;
            }
            case UP: {
                return BOUNDS_UP;
            }
            case DOWN: {
                return BOUNDS_DOWN;
            }
        }
        return field_185505_j;
    }

    public boolean func_176198_a(World world, BlockPos position, EnumFacing side) {
        return BlockLaserTripmine.canPlaceBlock(world, position, side);
    }

    public boolean func_176196_c(World world, BlockPos position) {
        for (EnumFacing facing : EnumFacing.values()) {
            if (!BlockLaserTripmine.canPlaceBlock(world, position, facing)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canPlaceBlock(World world, BlockPos position, EnumFacing direction) {
        BlockPos position1 = position.func_177972_a(direction.func_176734_d());
        IBlockState state = world.func_180495_p(position1);
        boolean flag = state.func_193401_d((IBlockAccess)world, position1, direction) == BlockFaceShape.SOLID;
        Block block = state.func_177230_c();
        if (direction == EnumFacing.UP) {
            return state.func_185896_q() || !BlockLaserTripmine.func_193384_b((Block)block) && flag;
        }
        return !BlockLaserTripmine.func_193382_c((Block)block) && flag;
    }

    public IBlockState func_180642_a(World world, BlockPos position, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase entity) {
        return BlockLaserTripmine.canPlaceBlock(world, position, facing) ? this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing) : this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        return i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityLaserTripmine();
    }
}

