/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.client.renderer.alien;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import melonslise.lambda.client.model.alien.ModelVortigaunt;
import melonslise.lambda.common.entity.alien.EntityVortigaunt;
import melonslise.lambda.utility.LambdaUtilities;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class RenderVortigaunt
extends RenderLiving {
    protected static final ResourceLocation texture = LambdaUtilities.createLambdaDomain("textures/entities/vortigaunt.png");
    protected static final ResourceLocation[] arcTextures = new ResourceLocation[]{LambdaUtilities.createLambdaDomain("textures/entities/arc0.png"), LambdaUtilities.createLambdaDomain("textures/entities/arc1.png"), LambdaUtilities.createLambdaDomain("textures/entities/arc2.png")};

    public RenderVortigaunt(RenderManager manager, float shadow) {
        super(manager, (ModelBase)new ModelVortigaunt(), shadow);
    }

    public void func_76986_a(EntityLiving entity, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        if (entity instanceof EntityVortigaunt) {
            EntityVortigaunt vortigaunt = (EntityVortigaunt)entity;
            Vec3d target = vortigaunt.target;
            if (vortigaunt.arc > 0 && target != null) {
                double endX = target.field_72450_a - entity.field_70165_t;
                double endY = target.field_72448_b - entity.field_70163_u;
                double endZ = target.field_72449_c - entity.field_70161_v;
                RenderVortigaunt.renderArc(this.field_76990_c, this.getArcTexture(), 128, 255, 128, 192, x, y, z, 0.0, entity.func_70047_e(), 0.0, endX, endY, endZ, 1.0);
            }
            if (vortigaunt.charge > 0) {
                if (vortigaunt.charge == 2) {
                    ThreadLocalRandom random = ThreadLocalRandom.current();
                    vortigaunt.positions.clear();
                    ArrayList positions1 = Lists.newArrayList((Iterable)BlockPos.func_191532_a((int)((int)entity.field_70165_t - 2), (int)((int)entity.field_70163_u - 1), (int)((int)entity.field_70161_v - 2), (int)((int)entity.field_70165_t + 2), (int)((int)entity.field_70163_u + (int)entity.field_70131_O + 2), (int)((int)entity.field_70161_v + 2)));
                    while (!positions1.isEmpty() && vortigaunt.positions.size() < random.nextInt(4, 7)) {
                        int index = random.nextInt(positions1.size());
                        BlockPos position = (BlockPos)positions1.get(index);
                        if (!entity.field_70170_p.func_180495_p(position).func_185904_a().func_76220_a()) continue;
                        vortigaunt.positions.add(position);
                        positions1.remove(index);
                    }
                }
                if (vortigaunt.charge > 2) {
                    for (BlockPos position : vortigaunt.positions) {
                        double endX = (double)position.func_177958_n() + Math.random() - entity.field_70165_t;
                        double endY = (double)position.func_177956_o() + 1.0 - entity.field_70163_u;
                        double endZ = (double)position.func_177952_p() + Math.random() - entity.field_70161_v;
                        RenderVortigaunt.renderArc(this.field_76990_c, this.getArcTexture(), 128, 255, 128, 192, x, y, z, 0.0, (double)entity.field_70131_O / 2.0, 0.0, endX, endY, endZ, 0.5);
                    }
                }
            }
        }
    }

    public static void renderArc(RenderManager manager, ResourceLocation texture, int red, int green, int blue, int alpha, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double endX, double endY, double endZ, double width) {
        double deltaX = endX - offsetX;
        double deltaY = endY - offsetY;
        double deltaZ = endZ - offsetZ;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        manager.field_78724_e.func_110577_a(texture);
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179137_b((double)(x + offsetX), (double)(y + offsetY), (double)(z + offsetZ));
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b(0.0, -width / 2.0, 0.0).func_187315_a(0.0, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(deltaX, deltaY - width / 2.0, deltaZ).func_187315_a(0.0, 1.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(deltaX, deltaY + width / 2.0, deltaZ).func_187315_a(1.0, 1.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(0.0, width / 2.0, 0.0).func_187315_a(1.0, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(-width / 2.0, 0.0, -width / 2.0).func_187315_a(0.0, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(deltaX - width / 2.0, deltaY, deltaZ - width / 2.0).func_187315_a(0.0, 1.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(deltaX + width / 2.0, deltaY, deltaZ + width / 2.0).func_187315_a(1.0, 1.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(width / 2.0, 0.0, width / 2.0).func_187315_a(1.0, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    public boolean func_177071_a(EntityLiving entity, ICamera camera, double camX, double camY, double camZ) {
        if (super.func_177071_a(entity, camera, camX, camY, camZ)) {
            return true;
        }
        if (entity instanceof EntityVortigaunt) {
            EntityVortigaunt vortigaunt = (EntityVortigaunt)entity;
            Vec3d target = vortigaunt.target;
            if (target != null && camera.func_78546_a(new AxisAlignedBB(entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O / 2.0, entity.field_70161_v, target.field_72450_a, target.field_72448_b, target.field_72449_c))) {
                return true;
            }
        }
        return false;
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return texture;
    }

    protected ResourceLocation getArcTexture() {
        return arcTextures[ThreadLocalRandom.current().nextInt(3)];
    }
}

