/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.client.event;

import com.google.common.collect.Lists;
import melonslise.lambda.client.effect.EffectHandler;
import melonslise.lambda.client.effect.EffectTrailHornet;
import melonslise.lambda.client.effect.EffectTrailRocket;
import melonslise.lambda.client.key.LambdaKeyBindings;
import melonslise.lambda.client.renderer.color.LambdaColors;
import melonslise.lambda.client.renderer.model.ItemModelWrapper;
import melonslise.lambda.client.renderer.weapon.RenderItemModel;
import melonslise.lambda.common.block.api.ITileUsable;
import melonslise.lambda.common.capability.entity.ICapabilityUsingItem;
import melonslise.lambda.common.capability.entity.ICapabilityUsingTile;
import melonslise.lambda.common.entity.projectile.EntityHornet;
import melonslise.lambda.common.entity.projectile.EntityRocket;
import melonslise.lambda.common.item.LambdaItems;
import melonslise.lambda.common.item.api.IItemReloadable;
import melonslise.lambda.common.item.api.IItemUsable;
import melonslise.lambda.common.item.api.armor.AItemSuit;
import melonslise.lambda.common.network.LambdaNetworks;
import melonslise.lambda.common.network.message.server.MessageActivateTile;
import melonslise.lambda.common.network.message.server.ServerMessageUseEntity;
import melonslise.lambda.common.sound.LambdaSounds;
import melonslise.lambda.common.sound.moving.api.LambdaMovingSound;
import melonslise.lambda.utility.LambdaUtilities;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="lambda", value={Side.CLIENT})
public class LambdaClientEvents {
    private static boolean wasUse;
    private static boolean wasAttack;
    private static boolean wasInteract;
    private static boolean wasReload;

    private LambdaClientEvents() {
    }

    @SubscribeEvent
    public static void onZoom(EntityViewRenderEvent.FOVModifier event) {
        if (LambdaUtilities.getZooming(event.getEntity()).get()) {
            event.setFOV(event.getFOV() / 3.0f);
        }
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        LambdaClientEvents.registerRenderers(event, LambdaItems.weapon_pistol, LambdaItems.weapon_smg, LambdaItems.weapon_revolver, LambdaItems.weapon_crossbow, LambdaItems.weapon_tau, LambdaItems.weapon_gluon, LambdaItems.weapon_snark);
    }

    private static void registerRenderer(ModelBakeEvent event, Item item) {
        IRegistry registry = event.getModelRegistry();
        ModelResourceLocation location = LambdaItems.getModel(item, "weapon/", "inventory");
        registry.func_82595_a((Object)location, (Object)new ItemModelWrapper((RenderItemModel)item.getTileEntityItemStackRenderer(), (IBakedModel)registry.func_82594_a((Object)location)));
    }

    private static void registerRenderers(ModelBakeEvent event, Item ... items) {
        for (Item item : items) {
            LambdaClientEvents.registerRenderer(event, item);
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        LambdaItems.registerModels();
    }

    @SubscribeEvent
    public static void registerColors(ColorHandlerEvent.Item event) {
        LambdaColors.registerColors(event);
    }

    @SubscribeEvent
    public static void renderOverlay(RenderGameOverlayEvent.Pre event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (LambdaUtilities.isWearingHazard((EntityLivingBase)player)) {
            ((AItemSuit)player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b()).renderDisplay(event);
        }
    }

    @SubscribeEvent
    public static void renderLiving(RenderLivingEvent.Pre event) {
        ICapabilityUsingItem using;
        if (event.getEntity() instanceof EntityPlayer && (using = LambdaUtilities.getUsingItem((Entity)event.getEntity())).get()) {
            ModelBiped model = (ModelBiped)event.getRenderer().func_177087_b();
            if (LambdaUtilities.getHandSide(event.getEntity(), using.getHand()) == EnumHandSide.RIGHT) {
                model.field_187076_m = ModelBiped.ArmPose.BOW_AND_ARROW;
            } else {
                model.field_187075_l = ModelBiped.ArmPose.BOW_AND_ARROW;
            }
        }
    }

    @SubscribeEvent
    public static void onSpawn(EntityJoinWorldEvent event) {
        if (!event.isCanceled() && event.getWorld().field_72995_K) {
            if (event.getEntity() instanceof EntityHornet) {
                EffectHandler.effects.add(new EffectTrailHornet(event.getEntity()));
            } else if (event.getEntity() instanceof EntityRocket) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new LambdaMovingSound(event.getEntity(), LambdaSounds.weapon_rpg_rocket, SoundCategory.MASTER));
                EffectHandler.effects.add(new EffectTrailRocket(event.getEntity()));
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && event.phase == TickEvent.Phase.START) {
            EntityPlayerSP player = mc.field_71439_g;
            boolean pressed = LambdaKeyBindings.fire_primary.func_151470_d();
            for (EnumHand hand : EnumHand.values()) {
                if (!(player.func_184586_b(hand).func_77973_b() instanceof IItemUsable)) continue;
                if (pressed && !wasAttack) {
                    LambdaClientEvents.useItem(true, hand, 0);
                    wasAttack = true;
                    break;
                }
                if (pressed || !wasAttack) continue;
                LambdaClientEvents.useItem(false, hand, 0);
                wasAttack = false;
                break;
            }
            pressed = LambdaKeyBindings.fire_secondary.func_151470_d();
            for (EnumHand hand : EnumHand.values()) {
                if (!(player.func_184586_b(hand).func_77973_b() instanceof IItemUsable)) continue;
                if (pressed && !wasInteract) {
                    LambdaClientEvents.useItem(true, hand, 1);
                    wasInteract = true;
                    break;
                }
                if (pressed || !wasInteract) continue;
                LambdaClientEvents.useItem(false, hand, 1);
                wasInteract = false;
                break;
            }
            pressed = LambdaKeyBindings.reload.func_151470_d();
            for (EnumHand hand : EnumHand.values()) {
                if (!(player.func_184586_b(hand).func_77973_b() instanceof IItemReloadable)) continue;
                if (pressed && !wasReload) {
                    LambdaClientEvents.reload(hand);
                    wasReload = true;
                    break;
                }
                if (pressed || !wasReload) continue;
                wasReload = false;
                break;
            }
            if ((pressed = LambdaKeyBindings.use.func_151470_d()) && !wasUse) {
                LambdaClientEvents.useFocus(true);
                wasUse = true;
            } else if (!pressed && wasUse) {
                LambdaClientEvents.useFocus(false);
                wasUse = false;
            }
        }
    }

    private static void useFocus(boolean state) {
        Vec3d end;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Vec3d start = player.func_174824_e(1.0f);
        RayTraceResult result = player.field_70170_p.func_147447_a(start, end = player.func_70040_Z().func_186678_a(2.0).func_178787_e(start), false, false, false);
        if (result != null) {
            end = result.field_72307_f;
        }
        boolean hasFocus = false;
        RayTraceResult result1 = LambdaUtilities.rayTraceClosestEntity(player.field_70170_p, start, end, Lists.newArrayList((Object[])new Entity[]{player}), null);
        if (state && result1 != null && result1.field_72308_g.func_184230_a((EntityPlayer)player, EnumHand.MAIN_HAND)) {
            hasFocus = true;
            LambdaNetworks.network.sendToServer((IMessage)new ServerMessageUseEntity(state, 0, result1.field_72308_g.func_145782_y()));
        } else if (result != null && result.func_178782_a() != null) {
            BlockPos position = result.func_178782_a();
            IBlockState focus = player.field_70170_p.func_180495_p(position);
            Vec3d hit = result.field_72307_f.func_178786_a((double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p());
            if (focus.func_177230_c() instanceof ITileUsable) {
                ICapabilityUsingTile using = LambdaUtilities.getUsingTile((Entity)player);
                if (state) {
                    using.startUsing(position, result.field_178784_b, hit, 0);
                } else {
                    using.stopUsing(result.field_178784_b, hit, 0);
                }
                hasFocus = true;
            } else if (state && focus.func_177230_c().func_180639_a(player.field_70170_p, position, focus, (EntityPlayer)player, EnumHand.MAIN_HAND, result.field_178784_b, (float)hit.field_72450_a, (float)hit.field_72448_b, (float)hit.field_72449_c)) {
                hasFocus = true;
                LambdaNetworks.network.sendToServer((IMessage)new MessageActivateTile(position, result.field_178784_b, hit));
            }
        }
        if (state && !hasFocus) {
            player.func_184185_a(LambdaSounds.denyselect, 1.0f, 1.0f);
        }
    }

    private static void useItem(boolean state, EnumHand hand, int type) {
        ICapabilityUsingItem using = LambdaUtilities.getUsingItem((Entity)Minecraft.func_71410_x().field_71439_g);
        if (state) {
            using.startUsing(hand, type);
        } else {
            using.stopUsing(hand, type);
        }
    }

    private static void reload(EnumHand hand) {
        LambdaUtilities.getReloading((Entity)Minecraft.func_71410_x().field_71439_g).startReloading(hand);
    }
}

