/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.client.effect.api;

import java.util.ArrayList;
import java.util.Iterator;
import melonslise.lambda.client.effect.api.Effect;
import melonslise.lambda.utility.LambdaUtilities;
import melonslise.lambda.utility.TrailPoint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public abstract class EffectTrail
extends Effect {
    protected Entity entity;
    protected ArrayList<TrailPoint> points = new ArrayList();
    protected float decay;
    protected double width;

    public EffectTrail(Entity entity, float decay, double width) {
        this.entity = entity;
        this.decay = decay;
        this.width = width;
    }

    public EffectTrail(Entity entity) {
        this(entity, 0.02f, 0.3);
    }

    @Override
    public void render(float partialTick) {
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        Vec3d origin = LambdaUtilities.getRenderOrigin(partialTick);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getTexture());
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        for (int a = 0; a < this.points.size() - 1; ++a) {
            TrailPoint point1 = this.points.get(a);
            TrailPoint point2 = this.points.get(a + 1);
            Vec3d offset1 = point1.getPosition().func_178788_d(origin);
            Vec3d offset2 = point2.getPosition().func_178788_d(origin);
            float alpha = point1.getAlpha(partialTick);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b(offset1.field_72450_a, offset1.field_72448_b, offset1.field_72449_c - this.width / 2.0).func_187315_a(0.0, 0.0).func_181666_a(0.8f, 0.8f, 0.8f, alpha).func_181675_d();
            buffer.func_181662_b(offset1.field_72450_a, offset1.field_72448_b, offset1.field_72449_c + this.width / 2.0).func_187315_a(0.0, 1.0).func_181666_a(0.8f, 0.8f, 0.8f, alpha).func_181675_d();
            buffer.func_181662_b(offset2.field_72450_a, offset2.field_72448_b, offset2.field_72449_c + this.width / 2.0).func_187315_a(1.0, 1.0).func_181666_a(0.8f, 0.8f, 0.8f, alpha).func_181675_d();
            buffer.func_181662_b(offset2.field_72450_a, offset2.field_72448_b, offset2.field_72449_c - this.width / 2.0).func_187315_a(1.0, 0.0).func_181666_a(0.8f, 0.8f, 0.8f, alpha).func_181675_d();
            buffer.func_181662_b(offset1.field_72450_a - this.width / 2.0, offset1.field_72448_b, offset1.field_72449_c).func_187315_a(0.0, 0.0).func_181666_a(0.8f, 0.8f, 0.8f, alpha).func_181675_d();
            buffer.func_181662_b(offset1.field_72450_a + this.width / 2.0, offset1.field_72448_b, offset1.field_72449_c).func_187315_a(0.0, 1.0).func_181666_a(0.8f, 0.8f, 0.8f, alpha).func_181675_d();
            buffer.func_181662_b(offset2.field_72450_a + this.width / 2.0, offset2.field_72448_b, offset2.field_72449_c).func_187315_a(1.0, 1.0).func_181666_a(0.8f, 0.8f, 0.8f, alpha).func_181675_d();
            buffer.func_181662_b(offset2.field_72450_a - this.width / 2.0, offset2.field_72448_b, offset2.field_72449_c).func_187315_a(1.0, 0.0).func_181666_a(0.8f, 0.8f, 0.8f, alpha).func_181675_d();
            buffer.func_181662_b(offset1.field_72450_a, offset1.field_72448_b - this.width / 2.0, offset1.field_72449_c).func_187315_a(0.0, 0.0).func_181666_a(0.8f, 0.8f, 0.8f, alpha).func_181675_d();
            buffer.func_181662_b(offset1.field_72450_a, offset1.field_72448_b + this.width / 2.0, offset1.field_72449_c).func_187315_a(0.0, 1.0).func_181666_a(0.8f, 0.8f, 0.8f, alpha).func_181675_d();
            buffer.func_181662_b(offset2.field_72450_a, offset2.field_72448_b + this.width / 2.0, offset2.field_72449_c).func_187315_a(1.0, 1.0).func_181666_a(0.8f, 0.8f, 0.8f, alpha).func_181675_d();
            buffer.func_181662_b(offset2.field_72450_a, offset2.field_72448_b - this.width / 2.0, offset2.field_72449_c).func_187315_a(1.0, 0.0).func_181666_a(0.8f, 0.8f, 0.8f, alpha).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
    }

    @Override
    public void update() {
        Iterator<TrailPoint> iterator = this.points.iterator();
        while (iterator.hasNext()) {
            TrailPoint point = iterator.next();
            float alpha = point.getAlpha();
            if (alpha <= 0.0f) {
                iterator.remove();
                continue;
            }
            if (alpha - this.decay > 0.0f) {
                point.setAlpha(alpha - this.decay);
                continue;
            }
            point.setAlpha(0.0f);
        }
        if (this.entity.field_70128_L && this.points.isEmpty()) {
            this.setExpired();
        }
        if (!this.entity.field_70128_L) {
            this.points.add(new TrailPoint(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 1.0f));
        }
    }

    protected abstract ResourceLocation getTexture();
}

