/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.compatibility;

import com.vicmatskiv.weaponlib.compatibility.CompatibleEntityJoinWorldEvent;
import com.vicmatskiv.weaponlib.compatibility.CompatibleExposureCapability;
import com.vicmatskiv.weaponlib.compatibility.CompatibleExtraEntityFlags;
import com.vicmatskiv.weaponlib.compatibility.CompatibleLivingUpdateEvent;
import com.vicmatskiv.weaponlib.compatibility.CompatiblePlayerEntityTrackerProvider;
import com.vicmatskiv.weaponlib.compatibility.CompatibleStartTrackingEvent;
import com.vicmatskiv.weaponlib.compatibility.CompatibleStopTrackingEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public abstract class CompatibleServerEventHandler {
    public abstract String getModId();

    @SubscribeEvent
    public final void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        int updatedFlags;
        if (event.phase == TickEvent.Phase.END && ((updatedFlags = CompatibleExtraEntityFlags.getFlags((Entity)event.player)) & CompatibleExtraEntityFlags.PRONING) != 0) {
            this.setSize(event.player, 0.6f, 0.6f);
        }
    }

    protected void setSize(EntityPlayer entityPlayer, float width, float height) {
        if (width != entityPlayer.field_70130_N || height != entityPlayer.field_70131_O) {
            float f = entityPlayer.field_70130_N;
            entityPlayer.field_70130_N = width;
            entityPlayer.field_70131_O = height;
            AxisAlignedBB axisalignedbb = entityPlayer.func_174813_aQ();
            entityPlayer.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)entityPlayer.field_70130_N, axisalignedbb.field_72338_b + (double)entityPlayer.field_70131_O, axisalignedbb.field_72339_c + (double)entityPlayer.field_70130_N));
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent itemTossEvent) {
        this.onCompatibleItemToss(itemTossEvent);
    }

    protected abstract void onCompatibleItemToss(ItemTossEvent var1);

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            ResourceLocation entityTrackerResourceLocation = new ResourceLocation(this.getModId(), "PLAYER_ENTITY_TRACKER");
            event.addCapability(entityTrackerResourceLocation, (ICapabilityProvider)new CompatiblePlayerEntityTrackerProvider());
            ResourceLocation extraFlagsResourceLocation = new ResourceLocation(this.getModId(), "PLAYER_ENTITY_FLAGS");
            event.addCapability(extraFlagsResourceLocation, (ICapabilityProvider)new CompatibleExtraEntityFlags());
        }
        ResourceLocation exposureResourceLocation = new ResourceLocation(this.getModId(), "EXPOSURE");
        event.addCapability(exposureResourceLocation, (ICapabilityProvider)new CompatibleExposureCapability());
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent e) {
        this.onCompatibleEntityJoinWorld(new CompatibleEntityJoinWorldEvent(e));
    }

    protected abstract void onCompatibleEntityJoinWorld(CompatibleEntityJoinWorldEvent var1);

    @SubscribeEvent
    public void playerStartedTracking(PlayerEvent.StartTracking e) {
        this.onCompatiblePlayerStartedTracking(new CompatibleStartTrackingEvent(e));
    }

    @SubscribeEvent
    public void playerStoppedTracking(PlayerEvent.StopTracking e) {
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent e) {
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent e) {
        this.onCompatibleLivingUpdateEvent(new CompatibleLivingUpdateEvent(e));
    }

    protected abstract void onCompatibleLivingDeathEvent(LivingDeathEvent var1);

    protected abstract void onCompatiblePlayerStartedTracking(CompatibleStartTrackingEvent var1);

    protected abstract void onCompatiblePlayerStoppedTracking(CompatibleStopTrackingEvent var1);

    protected abstract void onCompatibleLivingUpdateEvent(CompatibleLivingUpdateEvent var1);
}

