/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.compatibility;

import com.vicmatskiv.weaponlib.ModContext;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class CompatibleEntityPropertyProvider
implements ICapabilitySerializable<NBTBase> {
    @CapabilityInject(value=EntityPropertyContainer.class)
    static Capability<EntityPropertyContainer> entityPropertyContainer = null;
    private EntityPropertyContainer instance = (EntityPropertyContainer)entityPropertyContainer.getDefaultInstance();

    public static void register(ModContext modContext) {
        CapabilityManager.INSTANCE.register(EntityPropertyContainer.class, (Capability.IStorage)new EntityPropertyStorage(), EntityPropertyContainerImpl.class);
    }

    public static NBTTagCompound getTagCompound(Entity entity) {
        NBTTagCompound result;
        if (entity == null) {
            return null;
        }
        EntityPropertyContainer container = (EntityPropertyContainer)entity.getCapability(entityPropertyContainer, null);
        if (container != null) {
            result = container.getTagCompound();
            if (result == null) {
                result = new NBTTagCompound();
                container.init(result);
            }
        } else {
            result = null;
        }
        return result;
    }

    public final boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == entityPropertyContainer;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == entityPropertyContainer ? entityPropertyContainer.cast((Object)this.instance) : null);
    }

    public NBTBase serializeNBT() {
        return entityPropertyContainer.getStorage().writeNBT(entityPropertyContainer, (Object)this.instance, null);
    }

    public void deserializeNBT(NBTBase nbt) {
        entityPropertyContainer.getStorage().readNBT(entityPropertyContainer, (Object)this.instance, null, nbt);
    }

    public static class EntityPropertyStorage
    implements Capability.IStorage<EntityPropertyContainer> {
        public NBTBase writeNBT(Capability<EntityPropertyContainer> capability, EntityPropertyContainer instance, EnumFacing side) {
            return instance.getTagCompound();
        }

        public void readNBT(Capability<EntityPropertyContainer> capability, EntityPropertyContainer instance, EnumFacing side, NBTBase nbt) {
            instance.init((NBTTagCompound)nbt);
        }
    }

    public static class EntityPropertyContainerImpl
    implements EntityPropertyContainer {
        private NBTTagCompound tagCompound;

        @Override
        public NBTTagCompound getTagCompound() {
            if (this.tagCompound == null) {
                this.tagCompound = new NBTTagCompound();
            }
            return this.tagCompound;
        }

        @Override
        public void init(NBTTagCompound tagCompound) {
            this.tagCompound = tagCompound;
        }
    }

    public static interface EntityPropertyContainer {
        public NBTTagCompound getTagCompound();

        public void init(NBTTagCompound var1);
    }
}

