/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.network.TypeRegistry;
import com.vicmatskiv.weaponlib.state.ManagedState;
import io.netty.buffer.ByteBuf;

public enum WeaponState implements ManagedState<WeaponState>
{
    READY(false),
    LOAD_REQUESTED,
    LOAD(null, LOAD_REQUESTED, null, true),
    LOAD_ITERATION,
    LOAD_ITERATION_COMPLETED,
    ALL_LOAD_ITERATIONS_COMPLETED,
    UNLOAD_PREPARING,
    UNLOAD_REQUESTED,
    UNLOAD(UNLOAD_PREPARING, UNLOAD_REQUESTED, READY, true),
    FIRING(9),
    RECOILED(10),
    PAUSED(10),
    EJECT_REQUIRED,
    EJECTING,
    MODIFYING_REQUESTED(1),
    MODIFYING(2, null, MODIFYING_REQUESTED, null, false),
    NEXT_ATTACHMENT_REQUESTED,
    NEXT_ATTACHMENT(2, null, NEXT_ATTACHMENT_REQUESTED, null, false),
    ALERT,
    INSPECTING;

    private static final int DEFAULT_PRIORITY = 0;
    private WeaponState preparingPhase;
    private WeaponState permitRequestedPhase;
    private WeaponState commitPhase;
    private boolean isTransient;
    private int priority = 0;

    private WeaponState() {
        this(null, null, null, true);
    }

    private WeaponState(int priority) {
        this(priority, null, null, null, true);
    }

    private WeaponState(boolean isTransient) {
        this(null, null, null, isTransient);
    }

    private WeaponState(WeaponState preparingPhase, WeaponState permitRequestedState, WeaponState transactionFinalState, boolean isTransient) {
        this(0, preparingPhase, permitRequestedState, transactionFinalState, isTransient);
    }

    private WeaponState(int priority, WeaponState preparingPhase, WeaponState permitRequestedState, WeaponState transactionFinalState, boolean isTransient) {
        this.priority = priority;
        this.preparingPhase = preparingPhase;
        this.permitRequestedPhase = permitRequestedState;
        this.commitPhase = transactionFinalState;
        this.isTransient = false;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public WeaponState preparingPhase() {
        return this.preparingPhase;
    }

    @Override
    public WeaponState permitRequestedPhase() {
        return this.permitRequestedPhase;
    }

    @Override
    public WeaponState commitPhase() {
        return this.commitPhase;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public void init(ByteBuf buf) {
    }

    @Override
    public void serialize(ByteBuf buf) {
    }

    static {
        TypeRegistry.getInstance().register(WeaponState.class);
    }
}

