/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.AttachmentCategory;
import com.vicmatskiv.weaponlib.CommonModContext;
import com.vicmatskiv.weaponlib.EntityShellCasing;
import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.PlayerWeaponInstance;
import com.vicmatskiv.weaponlib.Tags;
import com.vicmatskiv.weaponlib.TryFireMessage;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.WeaponSpawnEntity;
import com.vicmatskiv.weaponlib.WeaponState;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import com.vicmatskiv.weaponlib.compatibility.CompatibleSound;
import com.vicmatskiv.weaponlib.state.Aspect;
import com.vicmatskiv.weaponlib.state.PermitManager;
import com.vicmatskiv.weaponlib.state.StateManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WeaponFireAspect
implements Aspect<WeaponState, PlayerWeaponInstance> {
    private static final Logger logger = LogManager.getLogger(WeaponFireAspect.class);
    private static final float FLASH_X_OFFSET_ZOOMED = 0.0f;
    private static final long ALERT_TIMEOUT = 500L;
    private static Predicate<PlayerWeaponInstance> readyToShootAccordingToFireRate = instance -> (float)(System.currentTimeMillis() - instance.getLastFireTimestamp()) >= 50.0f / instance.getWeapon().builder.fireRate;
    private static Predicate<PlayerWeaponInstance> postBurstTimeoutExpired = instance -> System.currentTimeMillis() - instance.getLastBurstEndTimestamp() >= instance.getWeapon().builder.burstTimeoutMilliseconds;
    private static Predicate<PlayerWeaponInstance> readyToShootAccordingToFireMode = instance -> instance.getSeriesShotCount() < instance.getMaxShots();
    private static Predicate<PlayerWeaponInstance> oneClickBurstEnabled = PlayerWeaponInstance::isOneClickBurstAllowed;
    private static Predicate<PlayerWeaponInstance> seriesResetAllowed = PlayerWeaponInstance::isSeriesResetAllowed;
    private static Predicate<PlayerWeaponInstance> hasAmmo = instance -> instance.getAmmo() > 0 && Tags.getAmmo(instance.getItemStack()) > 0;
    private static Predicate<PlayerWeaponInstance> ejectSpentRoundRequired = instance -> instance.getWeapon().ejectSpentRoundRequired();
    private static Predicate<PlayerWeaponInstance> ejectSpentRoundTimeoutExpired = instance -> System.currentTimeMillis() >= instance.getWeapon().builder.pumpTimeoutMilliseconds + instance.getStateUpdateTimestamp();
    private static Predicate<PlayerWeaponInstance> alertTimeoutExpired = instance -> System.currentTimeMillis() >= 500L + instance.getStateUpdateTimestamp();
    private static Predicate<PlayerWeaponInstance> sprinting = instance -> instance.getPlayer().func_70051_ag();
    private static final Set<WeaponState> allowedFireOrEjectFromStates = new HashSet<WeaponState>(Arrays.asList(WeaponState.READY, WeaponState.PAUSED, WeaponState.EJECT_REQUIRED));
    private static final Set<WeaponState> allowedUpdateFromStates = new HashSet<WeaponState>(Arrays.asList(WeaponState.EJECTING, WeaponState.PAUSED, WeaponState.FIRING, WeaponState.RECOILED, WeaponState.PAUSED, WeaponState.ALERT));
    private ModContext modContext;
    private StateManager<WeaponState, ? super PlayerWeaponInstance> stateManager;

    public WeaponFireAspect(CommonModContext modContext) {
        this.modContext = modContext;
    }

    @Override
    public void setPermitManager(PermitManager permitManager) {
    }

    @Override
    public void setStateManager(StateManager<WeaponState, ? super PlayerWeaponInstance> stateManager) {
        this.stateManager = stateManager;
        stateManager.in(this).change(WeaponState.READY).to(WeaponState.ALERT).when(hasAmmo.negate()).withAction(this::cannotFire).manual().in(this).change(WeaponState.ALERT).to(WeaponState.READY).when(alertTimeoutExpired).automatic().in(this).change(WeaponState.READY).to(WeaponState.FIRING).when(hasAmmo.and(sprinting.negate()).and(readyToShootAccordingToFireRate)).withAction(this::fire).manual().in(this).change(WeaponState.FIRING).to(WeaponState.RECOILED).automatic().in(this).change(WeaponState.RECOILED).to(WeaponState.PAUSED).automatic().in(this).change(WeaponState.PAUSED).to(WeaponState.EJECT_REQUIRED).when(ejectSpentRoundRequired).manual().in(this).change(WeaponState.EJECT_REQUIRED).to(WeaponState.EJECTING).withAction(this::ejectSpentRound).manual().in(this).change(WeaponState.EJECTING).to(WeaponState.READY).when(ejectSpentRoundTimeoutExpired).automatic().in(this).change(WeaponState.PAUSED).to(WeaponState.FIRING).when(hasAmmo.and(sprinting.negate()).and(readyToShootAccordingToFireMode).and(readyToShootAccordingToFireRate)).withAction(this::fire).manual().in(this).change(WeaponState.PAUSED).to(WeaponState.FIRING).when(hasAmmo.and(sprinting.negate()).and(oneClickBurstEnabled).and(readyToShootAccordingToFireMode).and(readyToShootAccordingToFireRate)).withAction(this::fire).automatic().in(this).change(WeaponState.PAUSED).to(WeaponState.READY).when(ejectSpentRoundRequired.negate().and(oneClickBurstEnabled).and(readyToShootAccordingToFireMode.negate().or(hasAmmo.negate())).and(seriesResetAllowed).and(postBurstTimeoutExpired)).withAction(PlayerWeaponInstance::resetCurrentSeries).automatic().in(this).change(WeaponState.PAUSED).to(WeaponState.READY).when(ejectSpentRoundRequired.negate().and(oneClickBurstEnabled.negate())).withAction(PlayerWeaponInstance::resetCurrentSeries).manual();
    }

    void onFireButtonDown(EntityPlayer player) {
        PlayerWeaponInstance weaponInstance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerWeaponInstance.class);
        if (weaponInstance != null) {
            this.stateManager.changeStateFromAnyOf(this, weaponInstance, allowedFireOrEjectFromStates, new WeaponState[]{WeaponState.FIRING, WeaponState.EJECTING, WeaponState.ALERT});
        }
    }

    void onFireButtonRelease(EntityPlayer player) {
        PlayerWeaponInstance weaponInstance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerWeaponInstance.class);
        if (weaponInstance != null) {
            weaponInstance.setSeriesResetAllowed(true);
            this.stateManager.changeState(this, weaponInstance, new WeaponState[]{WeaponState.EJECT_REQUIRED, WeaponState.READY});
        }
    }

    void onUpdate(EntityPlayer player) {
        PlayerWeaponInstance weaponInstance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerWeaponInstance.class);
        if (weaponInstance != null) {
            this.stateManager.changeStateFromAnyOf(this, weaponInstance, allowedUpdateFromStates, new WeaponState[0]);
        }
    }

    private void cannotFire(PlayerWeaponInstance weaponInstance) {
        if (weaponInstance.getAmmo() == 0 || Tags.getAmmo(weaponInstance.getItemStack()) == 0) {
            String message = weaponInstance.getWeapon().getAmmoCapacity() == 0 && this.modContext.getAttachmentAspect().getActiveAttachment(weaponInstance, AttachmentCategory.MAGAZINE) == null ? CompatibilityProvider.compatibility.getLocalizedString("gui.noMagazine", new Object[0]) : CompatibilityProvider.compatibility.getLocalizedString("gui.noAmmo", new Object[0]);
            this.modContext.getStatusMessageCenter().addAlertMessage(message, 3, 250L, 200L);
            if (weaponInstance.getPlayer() instanceof EntityPlayer) {
                CompatibilityProvider.compatibility.playSound((EntityLivingBase)((EntityPlayer)weaponInstance.getPlayer()), this.modContext.getNoAmmoSound(), 1.0f, 1.0f);
            }
        }
    }

    private void fire(PlayerWeaponInstance weaponInstance) {
        int seriesShotCount;
        int currentAmmo;
        EntityLivingBase player = weaponInstance.getPlayer();
        Weapon weapon = (Weapon)weaponInstance.getItem();
        Random random = player.func_70681_au();
        this.modContext.getChannel().getChannel().sendToServer((IMessage)new TryFireMessage(true));
        boolean silencerOn = this.modContext.getAttachmentAspect().isSilencerOn(weaponInstance);
        CompatibleSound shootSound = null;
        if (oneClickBurstEnabled.test(weaponInstance)) {
            CompatibleSound burstShootSound = null;
            if (silencerOn) {
                burstShootSound = weapon.getSilencedBurstShootSound();
            }
            if (burstShootSound == null) {
                burstShootSound = weapon.getBurstShootSound();
            }
            if (burstShootSound != null) {
                if (weaponInstance.getSeriesShotCount() == 0) {
                    shootSound = burstShootSound;
                }
            } else {
                shootSound = silencerOn ? weapon.getSilencedShootSound() : weapon.getShootSound();
            }
        } else {
            CompatibleSound compatibleSound = shootSound = silencerOn ? weapon.getSilencedShootSound() : weapon.getShootSound();
        }
        if (shootSound != null) {
            CompatibilityProvider.compatibility.playSound(player, shootSound, silencerOn ? weapon.getSilencedShootSoundVolume() : weapon.getShootSoundVolume(), 1.0f);
        }
        if ((currentAmmo = weaponInstance.getAmmo()) == 1 && weapon.getEndOfShootSound() != null) {
            CompatibilityProvider.compatibility.playSound(player, weapon.getEndOfShootSound(), 1.0f, 1.0f);
        }
        player.field_70125_A -= weaponInstance.getRecoil();
        float rotationYawFactor = -1.0f + random.nextFloat() * 2.0f;
        player.field_70177_z += weaponInstance.getRecoil() * rotationYawFactor;
        Boolean muzzleFlash = this.modContext.getConfigurationManager().getProjectiles().isMuzzleEffects();
        if (muzzleFlash == null || muzzleFlash.booleanValue()) {
            if (weapon.builder.flashIntensity > 0.0f) {
                this.modContext.getEffectManager().spawnFlashParticle(player, weapon.builder.flashIntensity, weapon.builder.flashScale.get().floatValue(), weaponInstance.isAimed() ? 0.0f : CompatibilityProvider.compatibility.getEffectOffsetX() + weapon.builder.flashOffsetX.get().floatValue(), CompatibilityProvider.compatibility.getEffectOffsetY() + weapon.builder.flashOffsetY.get().floatValue());
            }
            this.modContext.getEffectManager().spawnSmokeParticle(player, CompatibilityProvider.compatibility.getEffectOffsetX() + weapon.builder.smokeOffsetX.get().floatValue(), CompatibilityProvider.compatibility.getEffectOffsetY() + weapon.builder.smokeOffsetY.get().floatValue());
        }
        if ((seriesShotCount = weaponInstance.getSeriesShotCount()) == 0) {
            weaponInstance.setSeriesResetAllowed(false);
        }
        weaponInstance.setSeriesShotCount(seriesShotCount + 1);
        if (currentAmmo == 1 || weaponInstance.getSeriesShotCount() == weaponInstance.getMaxShots()) {
            weaponInstance.setLastBurstEndTimestamp(System.currentTimeMillis());
        }
        weaponInstance.setLastFireTimestamp(System.currentTimeMillis());
        weaponInstance.setAmmo(currentAmmo - 1);
    }

    private void ejectSpentRound(PlayerWeaponInstance weaponInstance) {
        EntityLivingBase player = weaponInstance.getPlayer();
        CompatibilityProvider.compatibility.playSound(player, weaponInstance.getWeapon().getEjectSpentRoundSound(), 1.0f, 1.0f);
    }

    public void serverFire(EntityLivingBase player, ItemStack itemStack) {
        this.serverFire(player, itemStack, null);
    }

    public void serverFire(EntityLivingBase player, ItemStack itemStack, BiFunction<Weapon, EntityLivingBase, ? extends WeaponSpawnEntity> spawnEntityWith) {
        EntityShellCasing entityShellCasing;
        if (!(itemStack.func_77973_b() instanceof Weapon)) {
            return;
        }
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        int currentServerAmmo = Tags.getAmmo(itemStack);
        if (currentServerAmmo <= 0) {
            logger.error("No server ammo");
            return;
        }
        Tags.setAmmo(itemStack, --currentServerAmmo);
        if (spawnEntityWith == null) {
            spawnEntityWith = weapon.builder.spawnEntityWith;
        }
        for (int i = 0; i < weapon.builder.pellets; ++i) {
            WeaponSpawnEntity spawnEntity = spawnEntityWith.apply(weapon, player);
            CompatibilityProvider.compatibility.spawnEntity(player, spawnEntity);
        }
        PlayerWeaponInstance playerWeaponInstance = Tags.getInstance(itemStack, PlayerWeaponInstance.class);
        if (weapon.isShellCasingEjectEnabled() && playerWeaponInstance != null && (entityShellCasing = weapon.builder.spawnShellWith.apply(playerWeaponInstance, player)) != null) {
            CompatibilityProvider.compatibility.spawnEntity(player, entityShellCasing);
        }
        boolean silencerOn = playerWeaponInstance != null && this.modContext.getAttachmentAspect().isSilencerOn(playerWeaponInstance);
        CompatibilityProvider.compatibility.playSoundToNearExcept(player, silencerOn ? weapon.getSilencedShootSound() : weapon.getShootSound(), silencerOn ? weapon.getSilencedShootSoundVolume() : weapon.getShootSoundVolume(), 1.0f);
    }
}

