/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.CustomArmor;
import com.vicmatskiv.weaponlib.MiscUtils;
import com.vicmatskiv.weaponlib.SpreadableExposure;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import com.vicmatskiv.weaponlib.compatibility.CompatibleExposureCapability;
import com.vicmatskiv.weaponlib.shader.DynamicShaderGroupSource;
import com.vicmatskiv.weaponlib.shader.DynamicShaderGroupSourceProvider;
import com.vicmatskiv.weaponlib.shader.DynamicShaderPhase;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

class PipelineShaderGroupSourceProvider
implements DynamicShaderGroupSourceProvider {
    private boolean nightVisionEnabled;
    private boolean blurEnabled;
    private boolean vignetteEnabled;
    private float sepiaRatio;
    private float exposureProgress;
    private float vignetteRadius;
    private float brightness;
    private SpreadableExposure spreadableExposure;
    final DynamicShaderGroupSource source = new DynamicShaderGroupSource(UUID.randomUUID(), new ResourceLocation("weaponlib:/com/vicmatskiv/weaponlib/resources/post-processing-pipeline.json")).withUniform("NightVisionEnabled", context -> Float.valueOf(this.nightVisionEnabled ? 1.0f : 0.0f)).withUniform("BlurEnabled", context -> Float.valueOf(this.blurEnabled ? 1.0f : 0.0f)).withUniform("BlurVignetteRadius", context -> Float.valueOf(0.0f)).withUniform("Radius", context -> Float.valueOf(10.0f)).withUniform("Progress", context -> Float.valueOf(this.exposureProgress)).withUniform("VignetteEnabled", context -> Float.valueOf(this.vignetteEnabled ? 1.0f : 0.0f)).withUniform("VignetteRadius", context -> Float.valueOf(this.vignetteRadius)).withUniform("Brightness", context -> Float.valueOf(this.brightness)).withUniform("SepiaRatio", context -> Float.valueOf(this.sepiaRatio)).withUniform("IntensityAdjust", context -> Float.valueOf(40.0f - Minecraft.func_71410_x().field_71474_y.field_74333_Y * 38.0f)).withUniform("NoiseAmplification", context -> Float.valueOf(2.0f + 3.0f * Minecraft.func_71410_x().field_71474_y.field_74333_Y));

    PipelineShaderGroupSourceProvider() {
    }

    @Override
    public DynamicShaderGroupSource getShaderSource(DynamicShaderPhase phase) {
        this.spreadableExposure = CompatibleExposureCapability.getExposure((Entity)CompatibilityProvider.compatibility.clientPlayer(), SpreadableExposure.class);
        this.exposureProgress = MiscUtils.smoothstep(0.0f, 1.0f, this.spreadableExposure != null ? this.spreadableExposure.getTotalDose() : 0.0f);
        this.updateNightVision();
        this.updateVignette();
        this.updateBlur();
        this.updateSepia();
        this.updateBrightness();
        this.spreadableExposure = null;
        return this.nightVisionEnabled || this.blurEnabled || this.vignetteEnabled || this.sepiaRatio > 0.0f ? this.source : null;
    }

    private void updateBrightness() {
        this.brightness = 1.0f;
        if (this.spreadableExposure != null && !CompatibilityProvider.compatibility.clientPlayer().field_70128_L) {
            SpreadableExposure.Blackout blackout = this.spreadableExposure.getBlackout();
            blackout.update();
            switch (blackout.getPhase()) {
                case ENTER: {
                    this.brightness = 1.0f - blackout.getEnterProgress();
                    break;
                }
                case EXIT: {
                    this.brightness = blackout.getExitProgress();
                    break;
                }
                case DARK: {
                    this.brightness = 0.0f;
                    break;
                }
                case NONE: {
                    this.brightness = 1.0f;
                }
            }
        }
    }

    private void updateBlur() {
        this.blurEnabled = this.exposureProgress > 0.01f;
    }

    private void updateVignette() {
        this.vignetteEnabled = this.nightVisionEnabled;
        ItemStack helmetStack = CompatibilityProvider.compatibility.getHelmet();
        if (this.nightVisionEnabled && helmetStack != null && helmetStack.func_77973_b() instanceof CustomArmor) {
            CustomArmor helmet = (CustomArmor)helmetStack.func_77973_b();
            this.vignetteEnabled = helmet.isVignetteEnabled();
        }
        this.vignetteRadius = 0.55f;
    }

    private void updateNightVision() {
        NBTTagCompound tagCompound;
        ItemStack helmetStack = CompatibilityProvider.compatibility.getHelmet();
        this.nightVisionEnabled = helmetStack != null ? ((tagCompound = CompatibilityProvider.compatibility.getTagCompound(helmetStack)) != null ? tagCompound.func_74767_n("nv") : false) : false;
    }

    private void updateSepia() {
        this.sepiaRatio = this.exposureProgress;
    }
}

