/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.core;

import com.vicmatskiv.weaponlib.ClassInfo;
import com.vicmatskiv.weaponlib.compatibility.CompatibleClassInfoProvider;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class WeaponlibClassTransformer
implements IClassTransformer {
    private static ClassInfo worldServerClassInfo = CompatibleClassInfoProvider.getInstance().getClassInfo("net/minecraft/world/WorldServer");
    private static ClassInfo entityRendererClassInfo = CompatibleClassInfoProvider.getInstance().getClassInfo("net/minecraft/client/renderer/EntityRenderer");
    private static ClassInfo renderBipedClassInfo = CompatibleClassInfoProvider.getInstance().getClassInfo("net/minecraft/client/renderer/entity/RenderBiped");
    private static ClassInfo renderPlayerClassInfo = CompatibleClassInfoProvider.getInstance().getClassInfo("net/minecraft/client/renderer/entity/RenderPlayer");
    private static ClassInfo itemBlockClassInfo = CompatibleClassInfoProvider.getInstance().getClassInfo("net/minecraft/item/ItemBlock");
    private static ClassInfo renderLivingEntityClassInfo = CompatibleClassInfoProvider.getInstance().getClassInfo("net/minecraft/client/renderer/entity/RendererLivingEntity");
    private static ClassInfo modelBaseClassInfo = CompatibleClassInfoProvider.getInstance().getClassInfo("net/minecraft/client/model/ModelBase");
    private static ClassInfo modelRendererClassInfo = CompatibleClassInfoProvider.getInstance().getClassInfo("net/minecraft/client/model/ModelRenderer");
    private static ClassInfo entityPlayerSPClassInfo = CompatibleClassInfoProvider.getInstance().getClassInfo("net/minecraft/client/entity/EntityPlayerSP");
    private static ClassInfo renderNpcHumanClassInfo = CompatibleClassInfoProvider.getInstance().getClassInfo("noppes/npcs/client/renderer/RenderNPCHumanMale");

    public byte[] transform(String par1, String className, byte[] bytecode) {
        if (worldServerClassInfo.classMatches(className) || entityRendererClassInfo.classMatches(className) || renderBipedClassInfo != null && renderBipedClassInfo.classMatches(className) || renderPlayerClassInfo != null && renderPlayerClassInfo.classMatches(className) || entityPlayerSPClassInfo != null && entityPlayerSPClassInfo.classMatches(className) || renderLivingEntityClassInfo != null && renderLivingEntityClassInfo.classMatches(className) || renderNpcHumanClassInfo != null && renderNpcHumanClassInfo.classMatches(className)) {
            ClassReader cr = new ClassReader(bytecode);
            ClassWriter cw = new ClassWriter(cr, 1);
            CVTransform cv = new CVTransform((ClassVisitor)cw);
            cr.accept((ClassVisitor)cv, 0);
            return cw.toByteArray();
        }
        return bytecode;
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            if (worldServerClassInfo.classMatches(this.classname)) {
                if (interfaces == null) {
                    interfaces = new String[]{"com/vicmatskiv/weaponlib/compatibility/CompatibleEntityProvider"};
                } else {
                    String[] updatedInterfaces = new String[interfaces.length + 1];
                    System.arraycopy(interfaces, 0, updatedInterfaces, 0, interfaces.length);
                    updatedInterfaces[updatedInterfaces.length - 1] = "com/vicmatskiv/weaponlib/compatibility/CompatibleEntityProvider";
                    interfaces = updatedInterfaces;
                }
            }
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public void visitSource(String source, String debug) {
            if (worldServerClassInfo.classMatches(this.classname)) {
                FieldVisitor fv = this.cv.visitField(18, "entitiesByUuid", "Ljava/util/Map;", "Ljava/util/Map<Ljava/util/UUID;Lnet/minecraft/entity/Entity;>;", null);
                fv.visitEnd();
                MethodVisitor mv = this.cv.visitMethod(1, "getEntityByUuid", "(Ljava/util/UUID;)Lnet/minecraft/entity/Entity;", null, null);
                mv.visitCode();
                Label l0 = new Label();
                mv.visitLabel(l0);
                mv.visitLineNumber(74, l0);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, "net/minecraft/world/WorldServer", "entitiesByUuid", "Ljava/util/Map;");
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                mv.visitTypeInsn(192, "net/minecraft/entity/Entity");
                mv.visitInsn(176);
                Label l1 = new Label();
                mv.visitLabel(l1);
                mv.visitLocalVariable("this", "Lnet/minecraft/world/WorldServer;", null, l0, l1, 0);
                mv.visitLocalVariable("uuid", "Ljava/util/UUID;", null, l0, l1, 1);
                mv.visitMaxs(2, 2);
                mv.visitEnd();
            }
            super.visitSource(source, debug);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (worldServerClassInfo.classMatches(this.classname) && name.equals("<init>")) {
                return new WorldServerConstructorVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (worldServerClassInfo.methodMatches("onEntityAdded", "(Lnet/minecraft/entity/Entity;)V", this.classname, name, desc)) {
                return new OnEntityAddedMethodVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions), this.classname);
            }
            if (worldServerClassInfo.methodMatches("onEntityRemoved", "(Lnet/minecraft/entity/Entity;)V", this.classname, name, desc)) {
                return new OnEntityRemovedMethodVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions), this.classname);
            }
            if (entityRendererClassInfo.methodMatches("setupCameraTransform", "(FI)V", this.classname, name, desc)) {
                return new SetupCameraTransformMethodVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (entityRendererClassInfo.methodMatches("setupViewBobbing", "(F)V", this.classname, name, desc)) {
                return new SetupViewBobbingMethodVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (entityRendererClassInfo.methodMatches("hurtCameraEffect", "(F)V", this.classname, name, desc)) {
                return new HurtCameraEffectMethodVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (entityRendererClassInfo.methodMatches("orientCamera", "(F)V", this.classname, name, desc)) {
                return new OrientCameraMethodVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (renderBipedClassInfo != null && renderBipedClassInfo.methodMatches("renderEquippedItems", "(Lnet/minecraft/entity/EntityLiving;F)V", this.classname, name, desc)) {
                return new BipedRenderEquippedItemsMethodVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (renderPlayerClassInfo != null && renderPlayerClassInfo.methodMatches("renderEquippedItems", "(Lnet/minecraft/client/entity/AbstractClientPlayer;F)V", this.classname, name, desc)) {
                return new PlayerRenderEquippedItemsMethodVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (renderLivingEntityClassInfo != null && renderLivingEntityClassInfo.methodMatches("renderModel", "(Lnet/minecraft/entity/EntityLivingBase;FFFFFF)V", this.classname, name, desc)) {
                return new RenderModelMethodVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (renderLivingEntityClassInfo != null && renderLivingEntityClassInfo.methodMatches("doRender", "(Lnet/minecraft/entity/EntityLivingBase;DDDFF)V", this.classname, name, desc)) {
                return new DoRenderMethodVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (entityPlayerSPClassInfo != null && entityPlayerSPClassInfo.methodMatches("isSneaking", "()Z", this.classname, name, desc)) {
                return new IsSneakingMethodVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (entityPlayerSPClassInfo != null && entityPlayerSPClassInfo.methodMatches("updateEntityActionState", "()V", this.classname, name, desc)) {
                return new UpdateEntityActionStateMethodVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (renderNpcHumanClassInfo != null && renderNpcHumanClassInfo.methodMatches("renderSpecials", "(Lnoppes/npcs/entity/EntityNPCInterface;F)V", this.classname, name, desc)) {
                return new RenderSpecialsMethodVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }

    private static class UpdateEntityActionStateMethodVisitor
    extends MethodVisitor {
        public UpdateEntityActionStateMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            super.visitFieldInsn(opcode, owner, name, desc);
            if (opcode == 180 && (owner.equals("bnl") || owner.equals("net/minecraft/util/MovementInput")) && (name.equals("jump") || name.equals("g"))) {
                Label l6 = new Label();
                this.mv.visitJumpInsn(153, l6);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(184, "com/vicmatskiv/weaponlib/compatibility/Interceptors", "isProning", "(Lnet/minecraft/entity/player/EntityPlayer;)Z", false);
                this.mv.visitJumpInsn(154, l6);
                this.mv.visitInsn(4);
                Label l7 = new Label();
                this.mv.visitJumpInsn(167, l7);
                this.mv.visitLabel(l6);
                this.mv.visitFrame(4, 0, null, 1, new Object[]{owner});
                this.mv.visitInsn(3);
                this.mv.visitLabel(l7);
                this.mv.visitFrame(0, 1, new Object[]{owner}, 2, new Object[]{owner, Opcodes.INTEGER});
            }
        }
    }

    private static class IsSneakingMethodVisitor
    extends MethodVisitor {
        public IsSneakingMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitJumpInsn(int opcode, Label label) {
            this.mv.visitJumpInsn(opcode, label);
            if (opcode == 154) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(184, "com/vicmatskiv/weaponlib/compatibility/Interceptors", "isProning", "(Lnet/minecraft/entity/player/EntityPlayer;)Z", false);
                this.mv.visitJumpInsn(154, label);
            }
        }
    }

    private static class DoRenderMethodVisitor
    extends MethodVisitor {
        public DoRenderMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (modelBaseClassInfo.methodMatches("render", "(Lnet/minecraft/entity/Entity;FFFFFF)V", owner, name, desc)) {
                this.mv.visitMethodInsn(184, "com/vicmatskiv/weaponlib/compatibility/Interceptors", "renderArmorLayer", "(Lnet/minecraft/client/model/ModelBase;Lnet/minecraft/entity/Entity;FFFFFF)V", false);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }

    private static class RenderModelMethodVisitor
    extends MethodVisitor {
        public RenderModelMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (modelBaseClassInfo.methodMatches("render", "(Lnet/minecraft/entity/Entity;FFFFFF)V", owner, name, desc)) {
                this.mv.visitMethodInsn(184, "com/vicmatskiv/weaponlib/compatibility/Interceptors", "render2", "(Lnet/minecraft/client/model/ModelBase;Lnet/minecraft/entity/Entity;FFFFFF)V", false);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }

    private static class PlayerRenderEquippedItemsMethodVisitor
    extends MethodVisitor {
        private int count;

        public PlayerRenderEquippedItemsMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (opcode == 182 && modelRendererClassInfo.methodMatches("postRender", "(F)V", owner, name, desc) && this.count++ == 1) {
                this.visitInsn(88);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitVarInsn(25, 1);
                this.mv.visitVarInsn(25, 8);
                this.mv.visitInsn(1);
                this.mv.visitInsn(1);
                this.mv.visitMethodInsn(184, "com/vicmatskiv/weaponlib/compatibility/Interceptors", "positionItemSide", "(Lnet/minecraft/client/renderer/entity/RenderPlayer;Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;Lcom/vicmatskiv/weaponlib/compatibility/CompatibleTransformType;Lcom/vicmatskiv/weaponlib/compatibility/CompatibleEnumHandSide;)V", false);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }

    private static class RenderSpecialsMethodVisitor
    extends MethodVisitor {
        public RenderSpecialsMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitTypeInsn(int opcode, String type) {
            if (opcode == 193 && (type.equals(itemBlockClassInfo.getMcpClassName()) || type.equals(itemBlockClassInfo.getNotchClassName()))) {
                this.mv.visitMethodInsn(184, "com/vicmatskiv/weaponlib/compatibility/Interceptors", "is3dRenderableItem", "(Lnet/minecraft/item/Item;)Z", false);
            } else {
                super.visitTypeInsn(opcode, type);
            }
        }
    }

    private static class BipedRenderEquippedItemsMethodVisitor
    extends MethodVisitor {
        public BipedRenderEquippedItemsMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitTypeInsn(int opcode, String type) {
            if (opcode == 193 && (type.equals(itemBlockClassInfo.getMcpClassName()) || type.equals(itemBlockClassInfo.getNotchClassName()))) {
                this.mv.visitMethodInsn(184, "com/vicmatskiv/weaponlib/compatibility/Interceptors", "is3dRenderableItem", "(Lnet/minecraft/item/Item;)Z", false);
            } else {
                super.visitTypeInsn(opcode, type);
            }
        }
    }

    private static class SetupCameraTransformMethodVisitor
    extends MethodVisitor {
        public SetupCameraTransformMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (entityRendererClassInfo.methodMatches("hurtCameraEffect", "(F)V", owner, name, desc)) {
                super.visitMethodInsn(opcode, owner, name, desc);
                this.mv.visitVarInsn(23, 1);
                this.mv.visitMethodInsn(184, "com/vicmatskiv/weaponlib/compatibility/Interceptors", "setupCameraTransformAfterHurtCameraEffect", "(F)V");
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            if (opcode == 158) {
                this.mv.visitVarInsn(23, 1);
                this.mv.visitMethodInsn(184, "com/vicmatskiv/weaponlib/compatibility/Interceptors", "nauseaCameraEffect", "(F)Z", false);
                this.mv.visitJumpInsn(153, label);
            }
        }
    }

    private static class OrientCameraMethodVisitor
    extends MethodVisitor {
        private int counter;

        public OrientCameraMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
            super.visitFrame(type, nLocal, local, nStack, stack);
            if (type == 3 && ++this.counter == 4) {
                this.visitVarInsn(25, 2);
                this.mv.visitVarInsn(23, 3);
                this.mv.visitMethodInsn(184, "com/vicmatskiv/weaponlib/compatibility/Interceptors", "adjustCameraPosition", "(Lnet/minecraft/entity/EntityLivingBase;F)F", false);
                this.mv.visitVarInsn(56, 3);
                Label l58 = new Label();
                this.mv.visitLabel(l58);
            }
        }
    }

    private static class HurtCameraEffectMethodVisitor
    extends MethodVisitor {
        private boolean visited;

        public HurtCameraEffectMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            if (!this.visited && opcode == 153) {
                this.mv.visitVarInsn(23, 1);
                this.mv.visitMethodInsn(184, "com/vicmatskiv/weaponlib/compatibility/Interceptors", "hurtCameraEffect", "(F)Z", false);
                this.mv.visitJumpInsn(153, label);
                this.visited = true;
            }
        }
    }

    private static class SetupViewBobbingMethodVisitor
    extends MethodVisitor {
        public SetupViewBobbingMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            if (opcode == 153) {
                this.mv.visitVarInsn(23, 1);
                this.mv.visitMethodInsn(184, "com/vicmatskiv/weaponlib/compatibility/Interceptors", "setupViewBobbing", "(F)Z", false);
                this.mv.visitJumpInsn(153, label);
            }
        }
    }

    private static class OnEntityRemovedMethodVisitor
    extends MethodVisitor {
        private String classname;

        public OnEntityRemovedMethodVisitor(MethodVisitor mv, String classname) {
            super(262144, mv);
            this.classname = classname;
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, "net/minecraft/world/WorldServer", "entitiesByUuid", "Ljava/util/Map;");
                this.mv.visitVarInsn(25, 1);
                String getUniqueIDMethodName = worldServerClassInfo.getNotchClassName().equals(this.classname) ? "func_110124_au" : "getUniqueID";
                this.mv.visitMethodInsn(182, "net/minecraft/entity/Entity", getUniqueIDMethodName, "()Ljava/util/UUID;", false);
                this.mv.visitMethodInsn(185, "java/util/Map", "remove", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                this.mv.visitInsn(87);
                Label label = new Label();
                this.mv.visitLabel(label);
                this.mv.visitLineNumber(103, label);
            }
            super.visitInsn(opcode);
        }
    }

    private static class OnEntityAddedMethodVisitor
    extends MethodVisitor {
        private String classname;

        public OnEntityAddedMethodVisitor(MethodVisitor mv, String classname) {
            super(262144, mv);
            this.classname = classname;
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, "net/minecraft/world/WorldServer", "entitiesByUuid", "Ljava/util/Map;");
                this.mv.visitVarInsn(25, 1);
                String getUniqueIDMethodName = worldServerClassInfo.getNotchClassName().equals(this.classname) ? "func_110124_au" : "getUniqueID";
                this.mv.visitMethodInsn(182, "net/minecraft/entity/Entity", getUniqueIDMethodName, "()Ljava/util/UUID;", false);
                this.mv.visitVarInsn(25, 1);
                this.mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
                this.mv.visitInsn(87);
                Label label = new Label();
                this.mv.visitLabel(label);
            }
            super.visitInsn(opcode);
        }
    }

    private static class WorldServerConstructorVisitor
    extends MethodVisitor {
        public WorldServerConstructorVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitTypeInsn(187, "java/util/HashMap");
                this.mv.visitInsn(89);
                this.mv.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
                this.mv.visitFieldInsn(181, "net/minecraft/world/WorldServer", "entitiesByUuid", "Ljava/util/Map;");
                Label l6 = new Label();
                this.mv.visitLabel(l6);
                this.mv.visitLineNumber(70, l6);
            }
            super.visitInsn(opcode);
        }
    }
}

