/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.compatibility;

import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import com.vicmatskiv.weaponlib.tracking.PlayerEntityTracker;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtendedPlayerProperties
implements IExtendedEntityProperties {
    private static final Logger logger = LogManager.getLogger(ExtendedPlayerProperties.class);
    private static final String TAG_TRACKER = "tracker";
    private static final String EXTENDED_PROPERTY_NAME = ExtendedPlayerProperties.class.getName();
    private boolean initialized;
    private World world;
    private Container<PlayerEntityTracker, World> entityTrackerContainer = new Container();

    public static final ExtendedPlayerProperties getProperties(EntityLivingBase player) {
        if (player == null) {
            return null;
        }
        ExtendedPlayerProperties properties = (ExtendedPlayerProperties)player.getExtendedProperties(EXTENDED_PROPERTY_NAME);
        if (properties != null && !properties.initialized) {
            properties.init((Entity)player, CompatibilityProvider.compatibility.world((Entity)player));
        }
        return properties;
    }

    public static final void init(EntityLivingBase player) {
        ExtendedPlayerProperties properties = new ExtendedPlayerProperties();
        properties.init((Entity)player, CompatibilityProvider.compatibility.world((Entity)player));
        player.registerExtendedProperties(EXTENDED_PROPERTY_NAME, (IExtendedEntityProperties)properties);
    }

    public static final void set(EntityLivingBase player, ExtendedPlayerProperties properties) {
        ExtendedPlayerProperties existingProperties = ExtendedPlayerProperties.getProperties(player);
        if (existingProperties != null) {
            existingProperties.copyFrom(properties);
        } else {
            player.registerExtendedProperties(EXTENDED_PROPERTY_NAME, (IExtendedEntityProperties)properties);
        }
    }

    public static final ExtendedPlayerProperties fromBuf(ByteBuf buf) {
        return new ExtendedPlayerProperties();
    }

    private void copyFrom(ExtendedPlayerProperties properties) {
        this.entityTrackerContainer = properties.entityTrackerContainer;
    }

    ExtendedPlayerProperties() {
    }

    public void init(Entity entity, World world) {
        this.world = world;
        this.initialized = true;
        this.entityTrackerContainer.initializer = w -> new PlayerEntityTracker(() -> world);
    }

    public void saveNBTData(NBTTagCompound playerTagCompound) {
        if (!this.initialized) {
            return;
        }
        NBTTagCompound tagCompound = new NBTTagCompound();
        PlayerEntityTracker playerEntityTracker = this.entityTrackerContainer.get(this.world);
        if (playerEntityTracker != null) {
            tagCompound.func_74773_a(TAG_TRACKER, playerEntityTracker.toByteArray());
        }
        playerTagCompound.func_74782_a(EXTENDED_PROPERTY_NAME, (NBTBase)tagCompound);
    }

    public void loadNBTData(NBTTagCompound playerTagCompound) {
        byte[] bytes;
        NBTTagCompound tagCompound = playerTagCompound.func_74775_l(EXTENDED_PROPERTY_NAME);
        if (tagCompound != null && (bytes = tagCompound.func_74770_j(TAG_TRACKER)) != null) {
            this.entityTrackerContainer.initializer = w -> PlayerEntityTracker.fromByteArray(bytes, () -> w);
        }
    }

    public PlayerEntityTracker getTracker() {
        if (!this.initialized) {
            return null;
        }
        return this.entityTrackerContainer.get(this.world);
    }

    public void serialize(ByteBuf buf) {
        if (!this.initialized) {
            return;
        }
        PlayerEntityTracker et = this.entityTrackerContainer.get(this.world);
        if (et != null) {
            et.serialize(buf);
        }
    }

    public void setTracker(PlayerEntityTracker tracker) {
        this.entityTrackerContainer = new Container<PlayerEntityTracker, World>(w -> tracker);
    }

    private static class Container<T, I> {
        Function<I, T> initializer;
        T resolved;

        Container() {
        }

        Container(Function<I, T> initializer) {
            this.initializer = initializer;
        }

        public T get(I i) {
            if (this.initializer == null) {
                return null;
            }
            if (this.resolved == null) {
                this.resolved = this.initializer.apply(i);
            }
            return this.resolved;
        }
    }
}

