/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.compatibility;

import com.vicmatskiv.weaponlib.ClientModContext;
import com.vicmatskiv.weaponlib.Part;
import com.vicmatskiv.weaponlib.PlayerWeaponInstance;
import com.vicmatskiv.weaponlib.RenderContext;
import com.vicmatskiv.weaponlib.RenderableState;
import com.vicmatskiv.weaponlib.WeaponRenderer;
import com.vicmatskiv.weaponlib.animation.DebugPositioner;
import com.vicmatskiv.weaponlib.animation.MultipartPositioning;
import com.vicmatskiv.weaponlib.animation.MultipartRenderStateManager;
import com.vicmatskiv.weaponlib.compatibility.CompatibleTessellator;
import com.vicmatskiv.weaponlib.compatibility.CompatibleTransformType;
import com.vicmatskiv.weaponlib.compatibility.Framebuffers;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public abstract class CompatibleWeaponRenderer
implements IItemRenderer {
    private static final int INVENTORY_TEXTURE_WIDTH = 256;
    private static final int INVENTORY_TEXTURE_HEIGHT = 256;
    private static final int SLOT_CHEST = 3;
    private WeaponRenderer.Builder builder;

    protected CompatibleWeaponRenderer(WeaponRenderer.Builder builder) {
        this.builder = builder;
    }

    protected abstract ClientModContext getClientModContext();

    protected abstract StateDescriptor getStateDescriptor(EntityLivingBase var1, ItemStack var2);

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack weaponItemStack, Object ... data) {
        GL11.glPushMatrix();
        int originalFramebufferId = -1;
        Framebuffer framebuffer = null;
        Integer inventoryTexture = null;
        boolean inventoryTextureInitializationPhaseOn = false;
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int currentTextureId = 0;
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            currentTextureId = Framebuffers.getCurrentTexture();
            CompatibleWeaponRenderer textureMapKey = this;
            inventoryTexture = this.getClientModContext().getInventoryTextureMap().get(textureMapKey);
            if (inventoryTexture == null) {
                inventoryTextureInitializationPhaseOn = true;
                originalFramebufferId = Framebuffers.getCurrentFramebuffer();
                Framebuffers.unbindFramebuffer();
                framebuffer = new Framebuffer(256, 256, true);
                inventoryTexture = framebuffer.field_147617_g;
                this.getClientModContext().getInventoryTextureMap().put(textureMapKey, inventoryTexture);
                framebuffer.func_147610_a(true);
                this.setupInventoryRendering(256.0, 256.0);
                GL11.glScalef((float)130.0f, (float)130.0f, (float)130.0f);
                if (DebugPositioner.isDebugModeEnabled()) {
                    DebugPositioner.position(Part.INVENTORY, null);
                }
                GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glRotatef((float)25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)1.449999f, (float)1.399999f, (float)0.0f);
            }
        }
        GL11.glScaled((double)-1.0, (double)-1.0, (double)1.0);
        Object player = data.length > 1 && data[1] instanceof EntityLivingBase ? (EntityLivingBase)data[1] : Minecraft.func_71410_x().field_71439_g;
        RenderContext<RenderableState> renderContext = new RenderContext<RenderableState>(this.getClientModContext(), (EntityLivingBase)player, weaponItemStack);
        renderContext.setAgeInTicks(-0.4f);
        renderContext.setScale(0.08f);
        renderContext.setCompatibleTransformType(CompatibleTransformType.fromItemRenderType(type));
        MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner = null;
        switch (type) {
            case ENTITY: {
                this.builder.getEntityPositioning().accept(weaponItemStack);
                break;
            }
            case INVENTORY: {
                this.builder.getInventoryPositioning().accept(weaponItemStack);
                break;
            }
            case EQUIPPED: {
                this.builder.getThirdPersonPositioning().accept(renderContext);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                StateDescriptor stateDescriptor = this.getStateDescriptor((EntityLivingBase)player, weaponItemStack);
                renderContext.setPlayerItemInstance(stateDescriptor.instance);
                MultipartPositioning<Part, RenderContext<RenderableState>> multipartPositioning = stateDescriptor.stateManager.nextPositioning();
                renderContext.setTransitionProgress(multipartPositioning.getProgress());
                renderContext.setFromState(multipartPositioning.getFromState(RenderableState.class));
                renderContext.setToState(multipartPositioning.getToState(RenderableState.class));
                positioner = multipartPositioning.getPositioner();
                positioner.randomize(stateDescriptor.rate, stateDescriptor.amplitude);
                positioner.position(Part.MAIN_ITEM, renderContext);
                if (DebugPositioner.isDebugModeEnabled()) {
                    DebugPositioner.position(Part.MAIN_ITEM, renderContext);
                }
                CompatibleWeaponRenderer.renderLeftArm((EntityPlayer)player, renderContext, positioner);
                CompatibleWeaponRenderer.renderRightArm((EntityPlayer)player, renderContext, positioner);
                break;
            }
        }
        if (type != IItemRenderer.ItemRenderType.INVENTORY || inventoryTextureInitializationPhaseOn) {
            this.renderItem(weaponItemStack, renderContext, positioner);
        }
        if (type == IItemRenderer.ItemRenderType.INVENTORY && inventoryTextureInitializationPhaseOn) {
            framebuffer.func_147609_e();
            framebuffer.field_147617_g = -1;
            framebuffer.func_147608_a();
            this.restoreInventoryRendering(scaledresolution);
        }
        GL11.glPopMatrix();
        if (originalFramebufferId >= 0) {
            Framebuffers.bindFramebuffer(originalFramebufferId, true, mc.func_147110_a().field_147621_c, mc.func_147110_a().field_147618_d);
        }
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.renderCachedInventoryTexture(inventoryTexture);
            if (currentTextureId != 0) {
                Framebuffers.bindTexture(currentTextureId);
            }
        }
    }

    private void setupInventoryRendering(double projectionWidth, double projectionHeight) {
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)projectionWidth, (double)projectionHeight, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    private void restoreInventoryRendering(ScaledResolution scaledresolution) {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
    }

    private void renderCachedInventoryTexture(Integer inventoryTexture) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
        GL11.glTranslatef((float)-0.8f, (float)-0.8f, (float)-1.0f);
        GL11.glScalef((float)0.006f, (float)0.006f, (float)0.006f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glBindTexture((int)3553, (int)inventoryTexture);
        CompatibleWeaponRenderer.drawTexturedQuadFit(0.0, 0.0, 256.0, 256.0, 0.0);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        int zLevel = 50;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)zLevel, (double)((float)(u + 0) * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)zLevel, (double)((float)(u + width) * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)zLevel, (double)((float)(u + width) * f), (double)((float)(v + 0) * f1));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)zLevel, (double)((float)(u + 0) * f), (double)((float)(v + 0) * f1));
        tessellator.func_78381_a();
    }

    private static void drawTexturedQuadFit(double x, double y, double width, double height, double zLevel) {
        CompatibleTessellator tessellator = CompatibleTessellator.getInstance();
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x + 0.0, y + height, zLevel, 0.0f, 1.0f);
        tessellator.addVertexWithUV(x + width, y + height, zLevel, 1.0f, 1.0f);
        tessellator.addVertexWithUV(x + width, y + 0.0, zLevel, 1.0f, 0.0f);
        tessellator.addVertexWithUV(x + 0.0, y + 0.0, zLevel, 0.0f, 0.0f);
        tessellator.draw();
    }

    protected abstract void renderItem(ItemStack var1, RenderContext<RenderableState> var2, MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> var3);

    static void renderRightArm(EntityPlayer player, RenderContext<RenderableState> renderContext, MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner) {
        RenderPlayer render = (RenderPlayer)RenderManager.field_78727_a.func_78713_a((Entity)player);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(((AbstractClientPlayer)player).func_110306_p());
        GL11.glPushMatrix();
        GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
        GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
        GL11.glTranslatef((float)-0.25f, (float)0.0f, (float)0.2f);
        GL11.glRotatef((float)5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)25.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        positioner.position(Part.RIGHT_HAND, renderContext);
        if (DebugPositioner.isDebugModeEnabled()) {
            DebugPositioner.position(Part.RIGHT_HAND, renderContext);
        }
        CompatibleWeaponRenderer.renderRightArm(player, render.field_77109_a);
        ItemStack itemstack = CompatibleWeaponRenderer.getItemStackFromSlot((EntityLivingBase)player, 3);
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemArmor) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(RenderBiped.getArmorResource((Entity)player, (ItemStack)itemstack, (int)3, null));
            ModelBiped armorModel = CompatibleWeaponRenderer.getArmorModelHook((EntityLivingBase)player, itemstack, 3, null);
            if (armorModel != null) {
                armorModel.field_78112_f.field_78806_j = true;
                armorModel.field_78118_o = render.field_77109_a.field_78118_o;
                armorModel.field_78119_l = render.field_77109_a.field_78119_l;
                armorModel.field_78120_m = render.field_77109_a.field_78120_m;
                CompatibleWeaponRenderer.renderRightArm((EntityPlayer)((AbstractClientPlayer)player), armorModel);
            }
        }
        GL11.glPopMatrix();
    }

    protected static ModelBiped getArmorModelHook(EntityLivingBase entity, ItemStack itemStack, int slot, ModelBiped model) {
        return ForgeHooksClient.getArmorModel((EntityLivingBase)entity, (ItemStack)itemStack, (int)slot, (ModelBiped)model);
    }

    @Nullable
    public static ItemStack getItemStackFromSlot(EntityLivingBase living, int slot) {
        return living.func_71124_b(slot);
    }

    static void renderLeftArm(EntityPlayer player, RenderContext<RenderableState> renderContext, MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner) {
        RenderPlayer render = (RenderPlayer)RenderManager.field_78727_a.func_78713_a((Entity)player);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(((AbstractClientPlayer)player).func_110306_p());
        GL11.glPushMatrix();
        GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
        GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glRotatef((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        positioner.position(Part.LEFT_HAND, renderContext);
        if (DebugPositioner.isDebugModeEnabled()) {
            DebugPositioner.position(Part.LEFT_HAND, renderContext);
        }
        CompatibleWeaponRenderer.renderLeftArm(player, render.field_77109_a);
        ItemStack itemstack = CompatibleWeaponRenderer.getItemStackFromSlot((EntityLivingBase)player, 3);
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemArmor) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(RenderBiped.getArmorResource((Entity)player, (ItemStack)itemstack, (int)3, null));
            ModelBiped armorModel = CompatibleWeaponRenderer.getArmorModelHook((EntityLivingBase)player, itemstack, 3, null);
            if (armorModel != null) {
                armorModel.field_78113_g.field_78806_j = true;
                armorModel.field_78119_l = render.field_77109_a.field_78119_l;
                armorModel.field_78120_m = render.field_77109_a.field_78120_m;
                CompatibleWeaponRenderer.renderLeftArm((EntityPlayer)((AbstractClientPlayer)player), armorModel);
            }
        }
        GL11.glPopMatrix();
    }

    private static void renderLeftArm(EntityPlayer player, ModelBiped model) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        model.field_78117_n = false;
        model.field_78095_p = 0.0f;
        model.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)player);
        model.field_78113_g.func_78785_a(0.0625f);
    }

    private static void renderRightArm(EntityPlayer player, ModelBiped model) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        model.field_78117_n = false;
        model.field_78095_p = 0.0f;
        model.func_78087_a(0.0f, 0.3f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)player);
        model.field_78112_f.func_78785_a(0.0625f);
    }

    protected static class StateDescriptor {
        protected MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>> stateManager;
        protected float rate;
        protected float amplitude = 0.04f;
        private PlayerWeaponInstance instance;

        public StateDescriptor(PlayerWeaponInstance instance, MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>> stateManager, float rate, float amplitude) {
            this.instance = instance;
            this.stateManager = stateManager;
            this.rate = rate;
            this.amplitude = amplitude;
        }
    }
}

