/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.compatibility;

import com.vicmatskiv.weaponlib.CustomRenderer;
import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.ModelSource;
import com.vicmatskiv.weaponlib.RenderContext;
import com.vicmatskiv.weaponlib.RenderableState;
import com.vicmatskiv.weaponlib.StaticModelSourceRenderer;
import com.vicmatskiv.weaponlib.Tuple;
import com.vicmatskiv.weaponlib.compatibility.CompatibleTransformType;
import com.vicmatskiv.weaponlib.compatibility.CompatibleWeaponRenderer;
import com.vicmatskiv.weaponlib.compatibility.Framebuffers;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public abstract class CompatibleStaticModelSourceRenderer
implements IItemRenderer {
    protected StaticModelSourceRenderer.Builder builder;

    protected CompatibleStaticModelSourceRenderer(StaticModelSourceRenderer.Builder builder) {
        this.builder = builder;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack itemStack, Object ... data) {
        int currentTextureId = 0;
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            currentTextureId = Framebuffers.getCurrentTexture();
        }
        GL11.glPushMatrix();
        GL11.glScaled((double)-1.0, (double)-1.0, (double)1.0);
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        RenderContext<RenderableState> renderContext = new RenderContext<RenderableState>(this.getModContext(), (EntityLivingBase)player, itemStack);
        switch (type) {
            case ENTITY: {
                this.builder.getEntityPositioning().accept(itemStack);
                break;
            }
            case INVENTORY: {
                this.builder.getInventoryPositioning().accept(itemStack);
                break;
            }
            case EQUIPPED: {
                this.builder.getThirdPersonPositioning().accept((EntityPlayer)player, itemStack);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.builder.getFirstPersonPositioning().accept((EntityPlayer)player, itemStack);
                CompatibleWeaponRenderer.renderLeftArm((EntityPlayer)player, renderContext, (p, c) -> this.builder.getFirstPersonLeftHandPositioning().accept((RenderContext<RenderableState>)c));
                CompatibleWeaponRenderer.renderRightArm((EntityPlayer)player, renderContext, (p, c) -> this.builder.getFirstPersonRightHandPositioning().accept((RenderContext<RenderableState>)c));
                break;
            }
        }
        this.renderModelSource(renderContext, itemStack, type, null, 0.0f, 0.0f, -0.4f, 0.0f, 0.0f, 0.08f);
        GL11.glPopMatrix();
        if (currentTextureId != 0) {
            Framebuffers.bindTexture(currentTextureId);
        }
    }

    private void renderModelSource(RenderContext<RenderableState> renderContext, ItemStack itemStack, IItemRenderer.ItemRenderType type, Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        if (!(itemStack.func_77973_b() instanceof ModelSource)) {
            throw new IllegalArgumentException();
        }
        GL11.glPushMatrix();
        ModelSource modelSource = (ModelSource)itemStack.func_77973_b();
        for (Tuple<ModelBase, String> texturedModel : modelSource.getTexturedModels()) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(this.builder.getModId() + ":textures/models/" + texturedModel.getV()));
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8192);
            ModelBase model = texturedModel.getU();
            switch (type) {
                case ENTITY: {
                    this.builder.getEntityModelPositioning().accept(model, itemStack);
                    break;
                }
                case INVENTORY: {
                    this.builder.getInventoryModelPositioning().accept(model, itemStack);
                    break;
                }
                case EQUIPPED: {
                    this.builder.getThirdPersonModelPositioning().accept(model, itemStack);
                    break;
                }
                case EQUIPPED_FIRST_PERSON: {
                    this.builder.getFirstPersonModelPositioning().accept(model, itemStack);
                    break;
                }
            }
            model.func_78088_a(entity, f, f1, f2, f3, f4, f5);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
        CustomRenderer<?> postRenderer = modelSource.getPostRenderer();
        if (postRenderer != null) {
            renderContext.setAgeInTicks(-0.4f);
            renderContext.setScale(0.08f);
            renderContext.setCompatibleTransformType(CompatibleTransformType.fromItemRenderType(type));
            renderContext.setPlayerItemInstance(this.getModContext().getPlayerItemInstanceRegistry().getItemInstance(renderContext.getPlayer(), itemStack));
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8193);
            postRenderer.render(renderContext);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    protected abstract ModContext getModContext();
}

