/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.compatibility;

import com.vicmatskiv.weaponlib.compatibility.CompatibleEntityJoinWorldEvent;
import com.vicmatskiv.weaponlib.compatibility.CompatibleExposureCapability;
import com.vicmatskiv.weaponlib.compatibility.CompatibleExtraEntityFlags;
import com.vicmatskiv.weaponlib.compatibility.CompatibleLivingUpdateEvent;
import com.vicmatskiv.weaponlib.compatibility.CompatibleStartTrackingEvent;
import com.vicmatskiv.weaponlib.compatibility.CompatibleStopTrackingEvent;
import com.vicmatskiv.weaponlib.compatibility.ExtendedPlayerProperties;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public abstract class CompatibleServerEventHandler {
    @SubscribeEvent
    public void onItemToss(ItemTossEvent itemTossEvent) {
        this.onCompatibleItemToss(itemTossEvent);
    }

    protected abstract void onCompatibleItemToss(ItemTossEvent var1);

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            ExtendedPlayerProperties.init((EntityLivingBase)((EntityPlayer)event.entity));
            CompatibleExtraEntityFlags.init((EntityLivingBase)((EntityPlayer)event.entity));
        }
        if (event.entity instanceof EntityLivingBase) {
            CompatibleExposureCapability.init((EntityLivingBase)event.entity);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent e) {
        this.onCompatibleEntityJoinWorld(new CompatibleEntityJoinWorldEvent(e));
    }

    protected abstract void onCompatibleEntityJoinWorld(CompatibleEntityJoinWorldEvent var1);

    @SubscribeEvent
    public void playerStartedTracking(PlayerEvent.StartTracking e) {
        this.onCompatiblePlayerStartedTracking(new CompatibleStartTrackingEvent(e));
    }

    @SubscribeEvent
    public void playerStoppedTracking(PlayerEvent.StopTracking e) {
        this.onCompatiblePlayerStoppedTracking(new CompatibleStopTrackingEvent(e));
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent e) {
        this.onCompatibleLivingUpdateEvent(new CompatibleLivingUpdateEvent(e));
    }

    protected abstract void onCompatiblePlayerStartedTracking(CompatibleStartTrackingEvent var1);

    public abstract String getModId();

    protected abstract void onCompatiblePlayerStoppedTracking(CompatibleStopTrackingEvent var1);

    protected abstract void onCompatibleLivingDeathEvent(LivingDeathEvent var1);

    protected abstract void onCompatibleLivingUpdateEvent(CompatibleLivingUpdateEvent var1);
}

