/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.compatibility;

import com.vicmatskiv.weaponlib.compatibility.CompatibleBlockPos;
import com.vicmatskiv.weaponlib.compatibility.CompatibleEnumFacing;
import com.vicmatskiv.weaponlib.compatibility.CompatibleVec3;
import net.minecraft.entity.Entity;
import net.minecraft.util.MovingObjectPosition;

public class CompatibleRayTraceResult {
    private MovingObjectPosition position;
    private CompatibleBlockPos blockPos;
    private CompatibleVec3 hitVec;

    static CompatibleRayTraceResult fromMovingObjectPosition(MovingObjectPosition position) {
        if (position == null) {
            return null;
        }
        return new CompatibleRayTraceResult(position);
    }

    private CompatibleRayTraceResult(MovingObjectPosition position) {
        this.position = position;
        this.init();
    }

    public CompatibleRayTraceResult(Entity entity) {
        this.position = new MovingObjectPosition(entity);
        this.init();
    }

    private void init() {
        this.blockPos = new CompatibleBlockPos(this.position.field_72311_b, this.position.field_72312_c, this.position.field_72309_d);
        this.hitVec = this.position.field_72307_f != null ? new CompatibleVec3(this.position.field_72307_f) : null;
    }

    protected MovingObjectPosition getPosition() {
        return this.position;
    }

    public Entity getEntityHit() {
        return this.position.field_72308_g;
    }

    public Type getTypeOfHit() {
        Type result = null;
        switch (this.position.field_72313_a) {
            case BLOCK: {
                result = Type.BLOCK;
                break;
            }
            case ENTITY: {
                result = Type.ENTITY;
                break;
            }
            case MISS: {
                result = Type.MISS;
            }
        }
        return result;
    }

    public int getBlockPosX() {
        return this.position.field_72311_b;
    }

    public int getBlockPosY() {
        return this.position.field_72312_c;
    }

    public int getBlockPosZ() {
        return this.position.field_72309_d;
    }

    public CompatibleEnumFacing getSideHit() {
        return CompatibleEnumFacing.values()[this.position.field_72310_e];
    }

    public CompatibleBlockPos getBlockPos() {
        return this.blockPos;
    }

    public CompatibleVec3 getHitVec() {
        return this.hitVec;
    }

    public void setSideHit(CompatibleEnumFacing sideHit) {
        this.position.field_72310_e = sideHit.ordinal();
    }

    public void setHitVec(CompatibleVec3 hitVec) {
        this.position.field_72307_f = hitVec.getVec();
        this.hitVec = hitVec;
    }

    public String toString() {
        return this.position.toString();
    }

    public static enum Type {
        MISS,
        BLOCK,
        ENTITY;

    }
}

