/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.compatibility;

import com.vicmatskiv.weaponlib.ClientModContext;
import com.vicmatskiv.weaponlib.Part;
import com.vicmatskiv.weaponlib.RenderContext;
import com.vicmatskiv.weaponlib.animation.DebugPositioner;
import com.vicmatskiv.weaponlib.animation.MultipartPositioning;
import com.vicmatskiv.weaponlib.animation.MultipartRenderStateManager;
import com.vicmatskiv.weaponlib.compatibility.CompatibleTransformType;
import com.vicmatskiv.weaponlib.compatibility.Framebuffers;
import com.vicmatskiv.weaponlib.melee.MeleeRenderer;
import com.vicmatskiv.weaponlib.melee.PlayerMeleeInstance;
import com.vicmatskiv.weaponlib.melee.RenderableState;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public abstract class CompatibleMeleeRenderer
implements IItemRenderer {
    private MeleeRenderer.Builder builder;

    protected CompatibleMeleeRenderer(MeleeRenderer.Builder builder) {
        this.builder = builder;
    }

    protected abstract ClientModContext getClientModContext();

    protected abstract StateDescriptor getStateDescriptor(EntityPlayer var1, ItemStack var2);

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack weaponItemStack, Object ... data) {
        int currentTextureId = 0;
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            currentTextureId = Framebuffers.getCurrentTexture();
        }
        GL11.glPushMatrix();
        GL11.glScaled((double)-1.0, (double)-1.0, (double)1.0);
        Object player = data.length > 1 && data[1] instanceof EntityPlayer ? (EntityPlayer)data[1] : Minecraft.func_71410_x().field_71439_g;
        RenderContext<RenderableState> renderContext = new RenderContext<RenderableState>(this.getClientModContext(), (EntityLivingBase)player, weaponItemStack);
        renderContext.setAgeInTicks(-0.4f);
        renderContext.setScale(0.08f);
        renderContext.setCompatibleTransformType(CompatibleTransformType.fromItemRenderType(type));
        MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner = null;
        switch (type) {
            case ENTITY: {
                this.builder.getEntityPositioning().accept(weaponItemStack);
                break;
            }
            case INVENTORY: {
                this.builder.getInventoryPositioning().accept(weaponItemStack);
                break;
            }
            case EQUIPPED: {
                this.builder.getThirdPersonPositioning().accept(renderContext);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                StateDescriptor stateDescriptor = this.getStateDescriptor((EntityPlayer)player, weaponItemStack);
                renderContext.setPlayerItemInstance(stateDescriptor.instance);
                MultipartPositioning<Part, RenderContext<RenderableState>> multipartPositioning = stateDescriptor.stateManager.nextPositioning();
                renderContext.setTransitionProgress(multipartPositioning.getProgress());
                renderContext.setFromState(multipartPositioning.getFromState(RenderableState.class));
                renderContext.setToState(multipartPositioning.getToState(RenderableState.class));
                positioner = multipartPositioning.getPositioner();
                this.renderLeftArm((EntityPlayer)player, renderContext, positioner);
                this.renderRightArm((EntityPlayer)player, renderContext, positioner);
                positioner.position(Part.MAIN_ITEM, renderContext);
                if (!DebugPositioner.isDebugModeEnabled()) break;
                DebugPositioner.position(Part.MAIN_ITEM, renderContext);
                break;
            }
        }
        this.renderItem(weaponItemStack, renderContext, positioner);
        GL11.glPopMatrix();
        if (currentTextureId != 0) {
            Framebuffers.bindTexture(currentTextureId);
        }
    }

    protected abstract BiConsumer<Part, RenderContext<RenderableState>> getPartDebugPositioning();

    protected abstract void renderItem(ItemStack var1, RenderContext<RenderableState> var2, MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> var3);

    private void renderRightArm(EntityPlayer player, RenderContext<RenderableState> renderContext, MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner) {
        RenderPlayer render = (RenderPlayer)RenderManager.field_78727_a.func_78713_a((Entity)player);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(((AbstractClientPlayer)player).func_110306_p());
        GL11.glPushMatrix();
        GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
        GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
        GL11.glTranslatef((float)-0.25f, (float)0.0f, (float)0.2f);
        GL11.glRotatef((float)5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)25.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        positioner.position(Part.RIGHT_HAND, renderContext);
        if (DebugPositioner.isDebugModeEnabled()) {
            DebugPositioner.position(Part.RIGHT_HAND, renderContext);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        render.field_77109_a.field_78095_p = 0.0f;
        render.field_77109_a.func_78087_a(0.0f, 0.3f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)player);
        render.field_77109_a.field_78112_f.func_78785_a(0.0625f);
        GL11.glPopMatrix();
    }

    private void renderLeftArm(EntityPlayer player, RenderContext<RenderableState> renderContext, MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner) {
        RenderPlayer render = (RenderPlayer)RenderManager.field_78727_a.func_78713_a((Entity)player);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(((AbstractClientPlayer)player).func_110306_p());
        GL11.glPushMatrix();
        GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
        GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glRotatef((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        positioner.position(Part.LEFT_HAND, renderContext);
        if (DebugPositioner.isDebugModeEnabled()) {
            DebugPositioner.position(Part.LEFT_HAND, renderContext);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        render.field_77109_a.field_78095_p = 0.0f;
        render.field_77109_a.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)player);
        render.field_77109_a.field_78113_g.func_78785_a(0.0625f);
        GL11.glPopMatrix();
    }

    protected static class StateDescriptor {
        protected MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>> stateManager;
        protected float rate;
        protected float amplitude = 0.04f;
        private PlayerMeleeInstance instance;

        public StateDescriptor(PlayerMeleeInstance instance, MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>> stateManager, float rate, float amplitude) {
            this.instance = instance;
            this.stateManager = stateManager;
            this.rate = rate;
            this.amplitude = amplitude;
        }
    }
}

