/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.compatibility;

import com.vicmatskiv.weaponlib.CommonModContext;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class CompatibleExtraEntityFlags
implements IExtendedEntityProperties {
    private static final String EXTENDED_PROPERTY_NAME = CompatibleExtraEntityFlags.class.getSimpleName();
    public static int PRONING = 1;
    public static int FLIP = Integer.MIN_VALUE;
    private int flags;

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public static void register(CommonModContext commonModContext) {
    }

    public static int getFlags(Entity entity) {
        if (entity == null) {
            return 0;
        }
        CompatibleExtraEntityFlags properties = (CompatibleExtraEntityFlags)entity.getExtendedProperties(EXTENDED_PROPERTY_NAME);
        return properties != null ? properties.getFlags() : 0;
    }

    public static void setFlag(Entity entity, int flag, boolean on) {
        if (entity == null) {
            return;
        }
        CompatibleExtraEntityFlags properties = (CompatibleExtraEntityFlags)entity.getExtendedProperties(EXTENDED_PROPERTY_NAME);
        if (properties != null) {
            int flags = properties.getFlags();
            if (on) {
                properties.setFlags(flags | flag);
            } else {
                properties.setFlags(flags & ~flag);
            }
        }
    }

    public static void setFlags(Entity entity, int flagsToSet, int values) {
        if (entity == null) {
            return;
        }
        CompatibleExtraEntityFlags properties = (CompatibleExtraEntityFlags)entity.getExtendedProperties(EXTENDED_PROPERTY_NAME);
        if (properties != null) {
            if ((flagsToSet & FLIP) != 0) {
                values = ~(properties.getFlags() & (flagsToSet &= ~FLIP));
            }
            properties.setFlags(properties.getFlags() & ~flagsToSet | flagsToSet & values);
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74768_a(EXTENDED_PROPERTY_NAME, this.flags);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.flags = compound.func_74762_e(EXTENDED_PROPERTY_NAME);
    }

    public void init(Entity entity, World world) {
    }

    public static void init(EntityLivingBase entity) {
        CompatibleExtraEntityFlags properties = new CompatibleExtraEntityFlags();
        properties.init((Entity)entity, CompatibilityProvider.compatibility.world((Entity)entity));
        entity.registerExtendedProperties(EXTENDED_PROPERTY_NAME, (IExtendedEntityProperties)properties);
    }
}

