/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.compatibility;

import com.vicmatskiv.weaponlib.CommonModContext;
import com.vicmatskiv.weaponlib.SpreadableExposure;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import com.vicmatskiv.weaponlib.network.TypeRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class CompatibleExposureCapability
implements IExtendedEntityProperties {
    private static final String EXTENDED_PROPERTY_NAME = CompatibleExposureCapability.class.getSimpleName();
    public Map<Class<?>, SpreadableExposure> exposures = new HashMap();

    public static SpreadableExposure getExposure(Entity player, Class<SpreadableExposure> exposureClass) {
        if (player == null) {
            return null;
        }
        CompatibleExposureCapability properties = (CompatibleExposureCapability)player.getExtendedProperties(EXTENDED_PROPERTY_NAME);
        return properties != null ? properties.exposures.get(exposureClass) : null;
    }

    public static void removeExposure(Entity entity, Class<SpreadableExposure> exposureClass) {
        CompatibleExposureCapability properties = (CompatibleExposureCapability)entity.getExtendedProperties(EXTENDED_PROPERTY_NAME);
        if (properties != null) {
            properties.exposures.remove(exposureClass);
        }
    }

    public static void updateExposure(EntityLivingBase entity, SpreadableExposure exposure) {
        CompatibleExposureCapability properties = (CompatibleExposureCapability)entity.getExtendedProperties(EXTENDED_PROPERTY_NAME);
        if (properties != null) {
            properties.exposures.put(exposure.getClass(), exposure);
        }
    }

    public static void register(CommonModContext commonModContext) {
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagList tagList = new NBTTagList();
        for (SpreadableExposure exposure : this.exposures.values()) {
            ByteBuf buf = Unpooled.buffer();
            TypeRegistry.getInstance().toBytes(exposure, buf);
            NBTTagCompound wrapper = new NBTTagCompound();
            wrapper.func_74773_a("bytes", buf.array());
            tagList.func_74742_a((NBTBase)wrapper);
        }
        compound.func_74782_a(EXTENDED_PROPERTY_NAME, (NBTBase)tagList);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagList tagList = (NBTTagList)compound.func_74781_a(EXTENDED_PROPERTY_NAME);
        if (tagList != null) {
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound wrapper = tagList.func_150305_b(i);
                ByteBuf buf = Unpooled.wrappedBuffer((byte[])wrapper.func_74770_j("bytes"));
                SpreadableExposure exposure = (SpreadableExposure)TypeRegistry.getInstance().fromBytes(buf);
                this.exposures.put(exposure.getClass(), exposure);
            }
        }
    }

    public void init(Entity entity, World world) {
    }

    public static void init(EntityLivingBase entity) {
        CompatibleExposureCapability properties = new CompatibleExposureCapability();
        properties.init((Entity)entity, CompatibilityProvider.compatibility.world((Entity)entity));
        entity.registerExtendedProperties(EXTENDED_PROPERTY_NAME, (IExtendedEntityProperties)properties);
    }
}

