/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.compatibility;

import com.vicmatskiv.weaponlib.compatibility.CompatibleBlockPos;
import com.vicmatskiv.weaponlib.compatibility.CompatibleDataManager;
import com.vicmatskiv.weaponlib.compatibility.CompatibleDifficulty;
import com.vicmatskiv.weaponlib.compatibility.CompatibleSound;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class CompatibleEntityMob
extends EntityMob {
    private boolean isHandActive;
    protected CompatibleDataManager compatibleDataManager;

    public CompatibleEntityMob(World worldIn) {
        super(worldIn);
        if (worldIn != null && !worldIn.field_72995_K) {
            this.initEntityAI();
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.compatibleDataManager = new CompatibleDataManager(this.field_70180_af);
    }

    protected void initEntityAI() {
    }

    protected String func_70621_aR() {
        CompatibleSound sound = this.getCompatibleHurtSound();
        return sound != null ? sound.getSound() : null;
    }

    protected CompatibleSound getCompatibleAmbientSound() {
        return null;
    }

    protected CompatibleSound getCompatibleHurtSound() {
        return null;
    }

    protected final String func_70673_aS() {
        CompatibleSound sound = this.getCompatibleDeathSound();
        return sound != null ? sound.getSound() : null;
    }

    protected CompatibleSound getCompatibleDeathSound() {
        return null;
    }

    protected ResourceLocation getLootTable() {
        return null;
    }

    protected void setCompatibleInventoryHandsDropChances(float chance) {
        this.field_82174_bp[0] = chance;
    }

    protected void setCompatibleInventoryArmorDropChances(float chance) {
        for (int i = 1; i < 5; ++i) {
            this.field_82174_bp[i] = chance;
        }
    }

    public IEntityLivingData func_110161_a(IEntityLivingData entityLivingData) {
        return this.onCompatibleSpawn(new CompatibleDifficulty(), super.func_110161_a(entityLivingData));
    }

    protected IEntityLivingData onCompatibleSpawn(CompatibleDifficulty difficulty, IEntityLivingData entityLivingData) {
        return entityLivingData;
    }

    protected void setEquipmentBasedOnDifficulty(CompatibleDifficulty difficulty) {
    }

    protected void setEnchantmentBasedOnDifficulty(CompatibleDifficulty difficulty) {
    }

    public float func_70783_a(int x, int y, int z) {
        return this.getCompatibleBlockPathWeight(new CompatibleBlockPos(x, y, z));
    }

    public float getCompatibleBlockPathWeight(CompatibleBlockPos pos) {
        return super.func_70783_a(pos.getBlockPosX(), pos.getBlockPosY(), pos.getBlockPosZ());
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.playStepSound(new CompatibleBlockPos(x, y, z), block);
    }

    protected void playStepSound(CompatibleBlockPos pos, Block blockIn) {
    }

    public void setActiveMainHand() {
        this.isHandActive = true;
    }

    public void resetActiveHand() {
        this.isHandActive = false;
    }

    public boolean isHandActive() {
        return this.isHandActive;
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public boolean isFacingEntity(EntityLivingBase otherEntity) {
        double dx = this.field_70165_t - otherEntity.field_70165_t;
        double dz = this.field_70161_v - otherEntity.field_70161_v;
        double tan1 = -dx / dz;
        double tan2 = Math.tan((double)(this.field_70761_aq / 180.0f) * Math.PI);
        return Math.abs(tan1 - tan2) < 5.0;
    }
}

