/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.compatibility;

import com.vicmatskiv.weaponlib.Explosion;
import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.ai.EntityCustomMob;
import com.vicmatskiv.weaponlib.compatibility.Compatibility;
import com.vicmatskiv.weaponlib.compatibility.CompatibleAchievement;
import com.vicmatskiv.weaponlib.compatibility.CompatibleAxisAlignedBB;
import com.vicmatskiv.weaponlib.compatibility.CompatibleBiomeType;
import com.vicmatskiv.weaponlib.compatibility.CompatibleBlockPos;
import com.vicmatskiv.weaponlib.compatibility.CompatibleBlockState;
import com.vicmatskiv.weaponlib.compatibility.CompatibleEntityEquipmentSlot;
import com.vicmatskiv.weaponlib.compatibility.CompatibleEntityProvider;
import com.vicmatskiv.weaponlib.compatibility.CompatibleEnumFacing;
import com.vicmatskiv.weaponlib.compatibility.CompatibleItemMonsterPlacer;
import com.vicmatskiv.weaponlib.compatibility.CompatibleItems;
import com.vicmatskiv.weaponlib.compatibility.CompatibleMathHelper;
import com.vicmatskiv.weaponlib.compatibility.CompatibleParticle;
import com.vicmatskiv.weaponlib.compatibility.CompatibleParticleManager;
import com.vicmatskiv.weaponlib.compatibility.CompatibleRayTraceResult;
import com.vicmatskiv.weaponlib.compatibility.CompatibleRenderingRegistry;
import com.vicmatskiv.weaponlib.compatibility.CompatibleSharedMonsterAttributes;
import com.vicmatskiv.weaponlib.compatibility.CompatibleSound;
import com.vicmatskiv.weaponlib.compatibility.CompatibleVec3;
import com.vicmatskiv.weaponlib.shader.DynamicShaderGroup;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.shader.ShaderManager;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class Compatibility1_7_10
implements Compatibility {
    private static final float DEFAULT_SHELL_CASING_FORWARD_OFFSET = 0.0f;
    private static DamageSource GENERIC_DAMAGE_SOURCE = new DamageSource("thrown");
    private static CompatibleMathHelper mathHelper = new CompatibleMathHelper();
    private Optional<Field> shadersEnabledFieldOptional;

    @Override
    public World world(Entity entity) {
        return entity.field_70170_p;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityPlayer clientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setClientPlayer(EntityPlayer player) {
        Minecraft.func_71410_x().field_71439_g = (EntityClientPlayerMP)player;
    }

    @Override
    public void spawnEntity(EntityLivingBase player, Entity entity) {
        player.field_70170_p.func_72838_d(entity);
    }

    @Override
    public void moveParticle(CompatibleParticle particle, double motionX, double motionY, double motionZ) {
        particle.func_70091_d(motionX, motionY, motionZ);
    }

    @Override
    public int getStackSize(ItemStack consumedStack) {
        return consumedStack.field_77994_a;
    }

    @Override
    public NBTTagCompound getTagCompound(ItemStack itemStack) {
        return itemStack.field_77990_d;
    }

    @Override
    public ItemStack getItemStack(ItemTossEvent event) {
        return event.entityItem.func_92059_d();
    }

    @Override
    public EntityPlayer getPlayer(ItemTossEvent event) {
        return event.player;
    }

    @Override
    public ItemStack getHeldItemMainHand(EntityLivingBase player) {
        return player.func_70694_bm();
    }

    @Override
    public boolean consumeInventoryItem(EntityPlayer player, Item item) {
        return player.field_71071_by.func_146026_a(item);
    }

    @Override
    public void ensureTagCompound(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
    }

    @Override
    public void playSound(EntityLivingBase player, CompatibleSound sound, float volume, float pitch) {
        if (sound != null) {
            player.func_85030_a(sound.getSound(), volume, pitch);
        }
    }

    @Override
    public IAttribute getMovementSpeedAttribute() {
        return SharedMonsterAttributes.field_111263_d;
    }

    @Override
    public void setTagCompound(ItemStack itemStack, NBTTagCompound tagCompound) {
        itemStack.field_77990_d = tagCompound;
    }

    @Override
    public boolean isClientSide() {
        return FMLCommonHandler.instance().getSide() == Side.CLIENT;
    }

    @Override
    public CompatibleMathHelper getMathHelper() {
        return mathHelper;
    }

    @Override
    public void playSoundToNearExcept(EntityLivingBase player, CompatibleSound sound, float volume, float pitch) {
        if (player instanceof EntityPlayer) {
            player.field_70170_p.func_85173_a((EntityPlayer)player, sound.getSound(), volume, pitch);
        } else {
            player.field_70170_p.func_72956_a((Entity)player, sound.getSound(), volume, volume);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityPlayer getClientPlayer() {
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ScaledResolution getResolution(RenderGameOverlayEvent.Pre event) {
        return event.resolution;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderGameOverlayEvent.ElementType getEventType(RenderGameOverlayEvent.Pre event) {
        return event.type;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getHelmet() {
        return Minecraft.func_71410_x().field_71439_g.func_71124_b(4);
    }

    @Override
    public CompatibleVec3 getLookVec(EntityPlayer player) {
        return new CompatibleVec3(player.func_70040_Z());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerKeyBinding(KeyBinding key) {
        ClientRegistry.registerKeyBinding((KeyBinding)key);
    }

    @Override
    public void registerWithFmlEventBus(Object object) {
        FMLCommonHandler.instance().bus().register(object);
    }

    @Override
    public void registerWithEventBus(Object object) {
        MinecraftForge.EVENT_BUS.register(object);
    }

    @Override
    public void registerSound(CompatibleSound sound) {
    }

    @Override
    public void registerItem(Item item, String name) {
        GameRegistry.registerItem((Item)item, (String)name);
    }

    @Override
    public void registerItem(String modId, Item item, String name) {
        GameRegistry.registerItem((Item)item, (String)name);
    }

    @Override
    public void runInMainClientThread(Runnable runnable) {
        runnable.run();
    }

    @Override
    public void registerModEntity(Class<? extends Entity> entityClass, String entityName, int id, Object mod, String modId, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)id, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    @Override
    public void registerRenderingRegistry(CompatibleRenderingRegistry rendererRegistry) {
    }

    @Override
    public <T, E> T getPrivateValue(Class<? super E> classToAccess, E instance, String ... fieldNames) {
        return (T)ObfuscationReflectionHelper.getPrivateValue(classToAccess, instance, (String[])fieldNames);
    }

    @Override
    public int getButton(MouseEvent event) {
        return event.button;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityPlayer getEntity(FOVUpdateEvent event) {
        return event.entity;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityLivingBase getEntity(RenderLivingEvent.Pre event) {
        return event.entity;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setNewFov(FOVUpdateEvent event, float fov) {
        event.newfov = fov;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderPlayer getRenderer(RenderLivingEvent.Pre event) {
        return (RenderPlayer)event.renderer;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(GuiOpenEvent event) {
        return event.gui;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setAimed(RenderPlayer rp, boolean aimed) {
        rp.field_77109_a.field_78118_o = aimed;
    }

    @Override
    public CompatibleRayTraceResult getObjectMouseOver() {
        return CompatibleRayTraceResult.fromMovingObjectPosition(Minecraft.func_71410_x().field_71476_x);
    }

    @Override
    public boolean consumeInventoryItem(InventoryPlayer inventoryPlayer, Item item) {
        return inventoryPlayer.func_146026_a(item);
    }

    @Override
    public CompatibleBlockState getBlockAtPosition(World world, CompatibleRayTraceResult position) {
        return CompatibleBlockState.fromBlock(world.func_147439_a(position.getBlockPosX(), position.getBlockPosY(), position.getBlockPosZ()));
    }

    @Override
    public void destroyBlock(World world, CompatibleRayTraceResult position) {
        world.func_147480_a(position.getBlockPosX(), position.getBlockPosY(), position.getBlockPosZ(), true);
    }

    @Override
    public ItemStack itemStackForItem(Item item, Predicate<ItemStack> condition, EntityPlayer player) {
        ItemStack result = null;
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] == null || player.field_71071_by.field_70462_a[i].func_77973_b() != item || !condition.test(player.field_71071_by.field_70462_a[i])) continue;
            result = player.field_71071_by.field_70462_a[i];
            break;
        }
        return result;
    }

    @Override
    public boolean isGlassBlock(CompatibleBlockState blockState) {
        Block block = blockState.getBlock();
        return block == Blocks.field_150359_w || block == Blocks.field_150410_aZ || block == Blocks.field_150399_cn || block == Blocks.field_150397_co;
    }

    @Override
    public float getEffectOffsetX() {
        return 0.0f;
    }

    @Override
    public float getEffectOffsetY() {
        return -0.05f;
    }

    @Override
    public float getEffectScaleFactor() {
        return 15.0f;
    }

    @Override
    public int getCurrentInventoryItemIndex(EntityPlayer player) {
        return player.field_71071_by.field_70461_c;
    }

    @Override
    public ItemStack getInventoryItemStack(EntityPlayer player, int inventoryItemIndex) {
        return player.field_71071_by.func_70301_a(inventoryItemIndex);
    }

    @Override
    public int getInventorySlot(EntityPlayer player, ItemStack itemStack) {
        int slot = -1;
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] != itemStack) continue;
            slot = i;
            break;
        }
        return slot;
    }

    @Override
    public boolean addItemToPlayerInventory(EntityPlayer player, Item item, int slot) {
        boolean result = false;
        if (slot == -1) {
            player.field_71071_by.func_70441_a(new ItemStack(item));
        } else if (player.field_71071_by.field_70462_a[slot] == null) {
            player.field_71071_by.field_70462_a[slot] = new ItemStack(item);
        }
        return result;
    }

    @Override
    public boolean consumeInventoryItemFromSlot(EntityPlayer player, int slot) {
        if (player.field_71071_by.field_70462_a[slot] == null) {
            return false;
        }
        if (--player.field_71071_by.field_70462_a[slot].field_77994_a <= 0) {
            player.field_71071_by.field_70462_a[slot] = null;
        }
        return true;
    }

    @Override
    public void addShapedRecipe(ItemStack itemStack, Object ... materials) {
        GameRegistry.addShapedRecipe((ItemStack)itemStack, (Object[])materials);
    }

    @Override
    public void addShapedOreRecipe(ItemStack itemStack, Object ... materials) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, materials).setMirrored(false));
    }

    @Override
    public void disableLightMap() {
        Minecraft.func_71410_x().field_71460_t.func_78483_a(0.0);
    }

    @Override
    public void enableLightMap() {
        Minecraft.func_71410_x().field_71460_t.func_78463_b(0.0);
    }

    @Override
    public void registerBlock(String modId, Block block, String name) {
        GameRegistry.registerBlock((Block)block, (String)name);
    }

    @Override
    public void registerWorldGenerator(IWorldGenerator generator, int modGenerationWeight) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)generator, (int)modGenerationWeight);
    }

    @Override
    public ItemArmor.ArmorMaterial addArmorMaterial(String name, String textureName, int durability, int[] reductionAmounts, int enchantability, CompatibleSound soundOnEquip, float toughness) {
        return EnumHelper.addArmorMaterial((String)name, (int)durability, (int[])reductionAmounts, (int)enchantability);
    }

    @Override
    public boolean inventoryHasFreeSlots(EntityPlayer player) {
        boolean result = false;
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] != null) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public void addBlockHitEffect(int x, int y, int z, CompatibleEnumFacing enumFacing) {
        for (int i = 0; i < 6; ++i) {
            Minecraft.func_71410_x().field_71452_i.func_78867_a(x, y, z, enumFacing.ordinal());
        }
    }

    @Override
    public String getDisplayName(EntityPlayer entity) {
        return entity.getDisplayName();
    }

    @Override
    public String getPlayerName(EntityPlayer player) {
        return player.func_70005_c_();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderGlobal createCompatibleRenderGlobal() {
        return Minecraft.func_71410_x().field_71438_f;
    }

    @Override
    public CompatibleParticleManager createCompatibleParticleManager(WorldClient world) {
        return new CompatibleParticleManager(world);
    }

    @Override
    public void setRenderViewEntity(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            Minecraft.func_71410_x().field_71451_h = (EntityLivingBase)entity;
        }
    }

    @Override
    public Entity getRenderViewEntity() {
        return Minecraft.func_71410_x().field_71451_h;
    }

    @Override
    public CompatibleParticleManager getCompatibleParticleManager() {
        return new CompatibleParticleManager(Minecraft.func_71410_x().field_71452_i);
    }

    @Override
    public void addChatMessage(Entity clientPlayer, String message) {
        if (clientPlayer instanceof EntityPlayer) {
            ((EntityPlayerSP)clientPlayer).func_145747_a((IChatComponent)new ChatComponentText(message));
        }
    }

    @Override
    public boolean isAirBlock(World world, CompatibleBlockPos blockPos) {
        Block blockHit = world.func_147439_a(blockPos.getBlockPosX(), blockPos.getBlockPosY(), blockPos.getBlockPosZ());
        return blockHit.func_149688_o() == Material.field_151579_a;
    }

    @Override
    public void clickBlock(CompatibleBlockPos blockPos, CompatibleEnumFacing sideHit) {
        Minecraft.func_71410_x().field_71442_b.func_78743_b(blockPos.getBlockPosX(), blockPos.getBlockPosY(), blockPos.getBlockPosZ(), sideHit.ordinal());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addBreakingParticle(ModContext modContext, double x, double y, double z) {
        double yOffset = 1.0;
        CompatibleParticle.CompatibleParticleBreaking particle = CompatibleParticle.createParticleBreaking(modContext, this.world((Entity)this.clientPlayer()), x, y + yOffset, z);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getAspectRatio(ModContext modContext) {
        return modContext.getAspectRatio();
    }

    private static int itemSlotIndex(Item item, Predicate<ItemStack> condition, EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] == null || player.field_71071_by.field_70462_a[i].func_77973_b() != item || !condition.test(player.field_71071_by.field_70462_a[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ItemStack consumeInventoryItem(Item item, Predicate<ItemStack> condition, EntityPlayer player, int maxSize) {
        if (maxSize <= 0) {
            return null;
        }
        int i = Compatibility1_7_10.itemSlotIndex(item, condition, player);
        if (i < 0) {
            return null;
        }
        ItemStack stackInSlot = player.field_71071_by.field_70462_a[i];
        int consumedStackSize = maxSize >= stackInSlot.field_77994_a ? stackInSlot.field_77994_a : maxSize;
        ItemStack result = stackInSlot.func_77979_a(consumedStackSize);
        if (stackInSlot.field_77994_a <= 0) {
            player.field_71071_by.field_70462_a[i] = null;
        }
        return result;
    }

    private static int findGreatesItemIndex(Collection<? extends Item> compatibleItems, Comparator<ItemStack> comparator, EntityPlayer player) {
        ItemStack maxStack = null;
        int maxItemIndex = -1;
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] == null || !compatibleItems.contains(player.field_71071_by.field_70462_a[i].func_77973_b()) || maxStack != null && comparator.compare(player.field_71071_by.field_70462_a[i], maxStack) <= 0) continue;
            maxStack = player.field_71071_by.field_70462_a[i];
            maxItemIndex = i;
        }
        return maxItemIndex;
    }

    @Override
    public ItemStack tryConsumingCompatibleItem(Collection<? extends Item> compatibleItems, Comparator<ItemStack> comparator, EntityPlayer player) {
        int maxSize = 1;
        int i = Compatibility1_7_10.findGreatesItemIndex(compatibleItems, comparator, player);
        if (i < 0) {
            return null;
        }
        ItemStack stackInSlot = player.field_71071_by.field_70462_a[i];
        int consumedStackSize = maxSize >= stackInSlot.field_77994_a ? stackInSlot.field_77994_a : maxSize;
        ItemStack result = stackInSlot.func_77979_a(consumedStackSize);
        if (stackInSlot.field_77994_a <= 0) {
            player.field_71071_by.field_70462_a[i] = null;
        }
        return result;
    }

    @Override
    public ItemStack tryConsumingCompatibleItem(List<? extends Item> compatibleParts, int maxSize, EntityPlayer player, Predicate<ItemStack> ... conditions) {
        ItemStack resultStack = null;
        for (Predicate<ItemStack> condition : conditions) {
            Item item;
            Iterator<? extends Item> iterator = compatibleParts.iterator();
            while (iterator.hasNext() && (resultStack = this.consumeInventoryItem(item = iterator.next(), condition, player, maxSize)) == null) {
            }
            if (resultStack != null) break;
        }
        return resultStack;
    }

    @Override
    public void setStackSize(ItemStack itemStack, int size) {
        itemStack.field_77994_a = size;
    }

    @Override
    public Item findItemByName(String modId, String itemName) {
        return GameRegistry.findItem((String)modId, (String)itemName);
    }

    @Override
    public CompatibleRayTraceResult rayTraceBlocks(Entity entity, CompatibleVec3 vec3, CompatibleVec3 vec31) {
        return CompatibleRayTraceResult.fromMovingObjectPosition(entity.field_70170_p.func_72933_a(vec3.getVec(), vec31.getVec()));
    }

    @Override
    public CompatibleAxisAlignedBB expandEntityBoundingBox(Entity entity1, double f1, double f2, double f3) {
        return new CompatibleAxisAlignedBB(entity1.field_70121_D.func_72314_b(f1, f2, f3));
    }

    @Override
    public CompatibleAxisAlignedBB getBoundingBox(Entity entity) {
        return new CompatibleAxisAlignedBB(entity.field_70121_D);
    }

    @Override
    public List<Entity> getEntitiesWithinAABBExcludingEntity(World world, Entity entity, CompatibleAxisAlignedBB boundingBox) {
        return world.func_72839_b(entity, boundingBox.getBoundingBox());
    }

    @Override
    public void spawnParticle(World world, String particleName, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed) {
        world.func_72869_a(particleName, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed);
    }

    @Override
    public CompatibleBlockState getBlockAtPosition(World world, CompatibleBlockPos blockPos) {
        return CompatibleBlockState.fromBlock(world.func_147439_a(blockPos.getBlockPosX(), blockPos.getBlockPosY(), blockPos.getBlockPosZ()));
    }

    @Override
    public boolean isBlockPenetratableByBullets(Block block) {
        return block == Blocks.field_150350_a || block == Blocks.field_150329_H || block == Blocks.field_150362_t || block == Blocks.field_150361_u || block == Blocks.field_150480_ab || block == Blocks.field_150407_cf || block == Blocks.field_150398_cm || block == Blocks.field_150321_G || block == Blocks.field_150464_aj;
    }

    @Override
    public boolean canCollideCheck(Block block, CompatibleBlockState metadata, boolean hitIfLiquid) {
        return block.func_149678_a(metadata.getBlockMetadata(), hitIfLiquid);
    }

    @Override
    public float getCompatibleShellCasingForwardOffset() {
        return 0.0f;
    }

    @Override
    public boolean madeFromHardMaterial(CompatibleBlockState blockState) {
        Block block = blockState.getBlock();
        Material material = block.func_149688_o();
        return material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151588_w || material == Material.field_151575_d;
    }

    @Override
    public void playSoundAtEntity(Entity entity, CompatibleSound explosionSound, float volume, float pitch) {
        entity.field_70170_p.func_72956_a(entity, explosionSound.getSound(), volume, pitch);
    }

    @Override
    public double getBlockDensity(World world, CompatibleVec3 vec3, CompatibleAxisAlignedBB boundingBox) {
        return world.func_72842_a(vec3.getVec(), boundingBox.getBoundingBox());
    }

    @Override
    public boolean isImmuneToExplosions(Entity entity) {
        return false;
    }

    @Override
    public boolean isAirBlock(CompatibleBlockState blockState) {
        return blockState.getBlock().func_149688_o() == Material.field_151579_a;
    }

    private net.minecraft.world.Explosion getCompatibleExplosion(Explosion e) {
        net.minecraft.world.Explosion ce = new net.minecraft.world.Explosion(e.getWorld(), e.getExploder(), e.getExplosionX(), e.getExplosionX(), e.getExplosionZ(), e.getExplosionSize());
        return ce;
    }

    @Override
    public boolean canDropBlockFromExplosion(CompatibleBlockState blockState, Explosion explosion) {
        return blockState.getBlock().func_149659_a(this.getCompatibleExplosion(explosion));
    }

    @Override
    public void onBlockExploded(World world, CompatibleBlockState blockState, CompatibleBlockPos blockpos, Explosion explosion) {
        blockState.getBlock().onBlockExploded(world, blockpos.getBlockPosX(), blockpos.getBlockPosY(), blockpos.getBlockPosZ(), this.getCompatibleExplosion(explosion));
    }

    @Override
    public float getExplosionResistance(World world, CompatibleBlockState blockState, CompatibleBlockPos blockpos, Entity entity, Explosion explosion) {
        return blockState.getBlock().func_149638_a(entity);
    }

    @Override
    public float getExplosionResistance(World world, Entity exploder, Explosion explosion, CompatibleBlockPos blockpos, CompatibleBlockState blockState) {
        return exploder.func_145772_a(this.getCompatibleExplosion(explosion), world, blockpos.getBlockPosX(), blockpos.getBlockPosY(), blockpos.getBlockPosZ(), blockState.getBlock());
    }

    @Override
    public boolean isSpectator(EntityPlayer entityplayer) {
        return false;
    }

    @Override
    public boolean isCreative(EntityPlayer entityplayer) {
        return entityplayer.field_71075_bZ.field_75098_d;
    }

    @Override
    public boolean isFlying(EntityPlayer entityplayer) {
        return entityplayer.field_71075_bZ.field_75100_b;
    }

    @Override
    public void setBlockToFire(World world, CompatibleBlockPos blockpos1) {
        world.func_147449_b(blockpos1.getBlockPosX(), blockpos1.getBlockPosY(), blockpos1.getBlockPosZ(), (Block)Blocks.field_150480_ab);
    }

    @Override
    public DamageSource getDamageSource(Explosion explosion) {
        return DamageSource.func_94539_a((net.minecraft.world.Explosion)this.getCompatibleExplosion(explosion));
    }

    @Override
    public double getBlastDamageReduction(EntityLivingBase entity, double d10) {
        return EnchantmentProtection.func_92092_a((Entity)entity, (double)d10);
    }

    @Override
    public boolean verifyExplosion(World world, Entity exploder, Explosion explosion, CompatibleBlockPos blockpos, CompatibleBlockState blockState, float f) {
        return exploder.func_145774_a(this.getCompatibleExplosion(explosion), world, blockpos.getBlockPosX(), blockpos.getBlockPosY(), blockpos.getBlockPosZ(), blockState.getBlock(), f);
    }

    @Override
    public CompatibleBlockState getBlockBelow(World world, CompatibleBlockPos blockpos1) {
        return CompatibleBlockState.fromBlock(world.func_147439_a(blockpos1.getBlockPosX(), blockpos1.getBlockPosY() - 1, blockpos1.getBlockPosZ()));
    }

    @Override
    public boolean isFullBlock(CompatibleBlockState blockState) {
        return blockState.getBlock().func_149730_j();
    }

    @Override
    public void dropBlockAsItemWithChance(World world, CompatibleBlockState blockState, CompatibleBlockPos blockpos, float f, int i) {
        int blockMetadata = world.func_72805_g(blockpos.getBlockPosX(), blockpos.getBlockPosY(), blockpos.getBlockPosZ());
        blockState.getBlock().func_149690_a(world, blockpos.getBlockPosX(), blockpos.getBlockPosY(), blockpos.getBlockPosZ(), blockMetadata, f, i);
    }

    @Override
    public void playSound(World world, double posX, double posY, double posZ, CompatibleSound sound, float volume, float pitch) {
        if (sound != null) {
            world.func_72908_a(posX, posY, posZ, sound.getSound(), volume, pitch);
        }
    }

    @Override
    public boolean isBlockPenetratableByGrenades(Block block) {
        return block == Blocks.field_150350_a || block == Blocks.field_150329_H || block == Blocks.field_150362_t || block == Blocks.field_150361_u || block == Blocks.field_150480_ab || block == Blocks.field_150407_cf || block == Blocks.field_150398_cm || block == Blocks.field_150321_G || block == Blocks.field_150464_aj;
    }

    @Override
    public DamageSource genericDamageSource() {
        return GENERIC_DAMAGE_SOURCE;
    }

    @Override
    public boolean isCollided(CompatibleParticle particle) {
        return particle.field_70132_H;
    }

    @Override
    public ItemStack createItemStack(CompatibleItems compatibleItem, int stackSize, int damage) {
        return new ItemStack(compatibleItem.getItem(), stackSize, damage);
    }

    @Override
    public void addSmelting(Block block, ItemStack output, float f) {
        GameRegistry.addSmelting((Block)block, (ItemStack)output, (float)f);
    }

    @Override
    public void addSmelting(Item item, ItemStack output, float f) {
        GameRegistry.addSmelting((Item)item, (ItemStack)output, (float)f);
    }

    @Override
    public String getLocalizedString(String format, Object ... args) {
        return StatCollector.func_74837_a((String)format, (Object[])args);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ShaderUniform getShaderUniform(ShaderManager shaderManager, String uniformName) {
        return shaderManager.func_147991_a(uniformName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setUniform(ShaderUniform uniform, float value) {
        uniform.func_148090_a(value);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setUniform(ShaderUniform uniform, float value1, float value2) {
        uniform.func_148087_a(value1, value2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setUniform(ShaderUniform uniform, float value1, float value2, float value3) {
        uniform.func_148095_a(value1, value2, value3);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setUniform(ShaderUniform uniform, float value1, float value2, float value3, float value4) {
        uniform.func_148092_b(value1, value2, value3, value4);
    }

    @Override
    public ItemStack getHelmet(EntityLivingBase entity) {
        return entity.func_71124_b(4);
    }

    @Override
    public CompatibleVec3 getLookVec(EntityLivingBase player) {
        return new CompatibleVec3(player.func_70040_Z());
    }

    @Override
    public void setEntityAttribute(EntityLivingBase entity, CompatibleSharedMonsterAttributes attributes, double value) {
        IAttributeInstance attributeInstance = entity.func_110140_aT().func_111151_a(attributes.getAttributes());
        if (attributeInstance != null) {
            attributeInstance.func_111128_a(value);
        }
    }

    @Override
    public EnumDifficulty getDifficulty(World world) {
        return world.field_73013_u;
    }

    @Override
    public void addStat(EntityPlayer entityplayer, CompatibleAchievement achievementList) {
    }

    @Override
    public float getLightBrightness(World world, CompatibleBlockPos pos) {
        return world.func_72801_o(pos.getBlockPosX(), pos.getBlockPosY(), pos.getBlockPosZ());
    }

    @Override
    public void setItemStackToSlot(Entity entity, CompatibleEntityEquipmentSlot compatibleEquipmentSlot, ItemStack itemStack) {
        entity.func_70062_b(compatibleEquipmentSlot.getEntityEquipmentSlot(), itemStack);
    }

    @Override
    public boolean isStrafingSupported() {
        return false;
    }

    @Override
    public void strafe(EntityCustomMob entity, float forward, float strafe) {
        throw new UnsupportedOperationException("Not supported in this version of minecraft");
    }

    @Override
    public void addSpawn(Class<? extends EntityLiving> entity, int weightedProb, int min, int max, CompatibleBiomeType ... biomeTypes) {
        ArrayList<BiomeGenBase> biomes = new ArrayList<BiomeGenBase>();
        for (CompatibleBiomeType compatibleType : biomeTypes) {
            for (BiomeDictionary.Type incompatibleType : compatibleType.getTypes()) {
                BiomeGenBase[] biomesForType;
                for (BiomeGenBase b : biomesForType = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)incompatibleType)) {
                    biomes.add(b);
                }
            }
        }
        EntityRegistry.addSpawn(entity, (int)weightedProb, (int)min, (int)max, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes.toArray(new BiomeGenBase[0]));
    }

    @Override
    public void registerEgg(ModContext context, Class<? extends Entity> entityClass, String entityName, int primaryEggColor, int secondaryEggColor) {
        Item itemSpawnEgg = new CompatibleItemMonsterPlacer(context, entityName, primaryEggColor, secondaryEggColor).func_77655_b("spawn_egg_" + entityName.toLowerCase()).func_111206_d("spawn_egg");
        GameRegistry.registerItem((Item)itemSpawnEgg, (String)("spawnEgg" + entityName));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void useShader(EntityRenderer entityRenderer, boolean value) {
    }

    @Override
    public boolean is3dRenderable(Item item) {
        return item instanceof Weapon || item instanceof ItemBlock;
    }

    @Override
    public float getCompatibleAimingRotationYaw(EntityLivingBase thrower) {
        return thrower instanceof EntityPlayer ? thrower.field_70177_z : thrower.field_70761_aq;
    }

    @Override
    public <T> void setPrivateValue(Class<T> class1, T instance, Object value, String ... fieldNames) {
        ObfuscationReflectionHelper.setPrivateValue(class1, instance, (Object)value, (String[])fieldNames);
    }

    @Override
    public ItemStack createItemStack(NBTTagCompound nbt) {
        return ItemStack.func_77949_a((NBTTagCompound)nbt);
    }

    @Override
    public EntityAITarget createAINearestAttackableTarget(EntityLivingBase e, Class<? extends EntityLivingBase> targetClass, boolean checkSight) {
        return new EntityAINearestAttackableTarget((EntityCreature)e, targetClass, 0, checkSight);
    }

    @Override
    public EntityAIBase createAiAvoidEntity(EntityLivingBase e, Class<? extends EntityLivingBase> entityClassToAvoid, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
        return new EntityAIAvoidEntity((EntityCreature)e, entityClassToAvoid, avoidDistanceIn, farSpeedIn, nearSpeedIn);
    }

    @Override
    public Entity getTrueDamageSource(DamageSource cause) {
        return cause.func_76364_f();
    }

    @Override
    public ShaderGroup getShaderGroup(EntityRenderer entityRenderer) {
        return (ShaderGroup)this.getPrivateValue(EntityRenderer.class, entityRenderer, "theShaderGroup", "field_147707_d");
    }

    @Override
    public void setShaderGroup(EntityRenderer entityRenderer, DynamicShaderGroup shaderGroup) {
        this.setPrivateValue(EntityRenderer.class, entityRenderer, (Object)shaderGroup, "theShaderGroup", "field_147707_d");
    }

    @Override
    public WorldType getWorldType(World world) {
        return world.func_72912_H().func_76067_t();
    }

    @Override
    public ItemStack getItemStackFromSlot(CompatibleEntityEquipmentSlot slot) {
        return this.getClientPlayer().func_82169_q(slot.getEntityEquipmentSlot());
    }

    @Override
    public boolean isStencilEnabled(Framebuffer framebuffer) {
        return true;
    }

    @Override
    public void enableStencil(Framebuffer framebuffer) {
        if (!OpenGlHelper.func_148822_b()) {
            return;
        }
        framebuffer.func_147613_a(framebuffer.field_147621_c, framebuffer.field_147618_d);
    }

    @Override
    public void resizeEntityBoundingBox(Entity entity, double x, double y, double z) {
        entity.field_70121_D.field_72336_d = entity.field_70121_D.field_72340_a + x;
        entity.field_70121_D.field_72337_e = entity.field_70121_D.field_72338_b + y;
        entity.field_70121_D.field_72334_f = entity.field_70121_D.field_72339_c + z;
    }

    @Override
    public void renderRightArmwear(ModelBiped model, float scale) {
    }

    @Override
    public void renderLeftArmwear(ModelBiped model, float scale) {
    }

    @Override
    public void renderRightLegwear(ModelBiped model, float scale) {
    }

    @Override
    public void renderLeftLegwear(ModelBiped model, float scale) {
    }

    @Override
    public void renderBodywear(ModelBiped model, float scale) {
    }

    @Override
    public void renderHeadwear(ModelBiped model, float scale) {
        model.field_78114_d.func_78785_a(scale);
    }

    @Override
    public boolean isShadersModEnabled() {
        boolean result = Loader.isModLoaded((String)"shadersmod");
        if (result) {
            if (this.shadersEnabledFieldOptional == null) {
                try {
                    Class<?> shadersClass = Loader.instance().getModClassLoader().loadClass("shadersmodcore.client.Shaders");
                    this.shadersEnabledFieldOptional = Optional.of(shadersClass.getField("isInitialized"));
                }
                catch (Exception e) {
                    this.shadersEnabledFieldOptional = Optional.empty();
                }
            }
            if (this.shadersEnabledFieldOptional != null) {
                try {
                    Field field = this.shadersEnabledFieldOptional.orElse(null);
                    result = field != null && field.getBoolean(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    @Override
    public float getFlashIntencityFactor() {
        return 5.0f;
    }

    @Override
    public void setUniqueId(NBTTagCompound tagCompound, String tag, UUID uuid) {
        tagCompound.func_74772_a(tag + "Most", uuid.getMostSignificantBits());
        tagCompound.func_74772_a(tag + "Least", uuid.getLeastSignificantBits());
    }

    @Override
    public UUID getUniqueId(NBTTagCompound tagCompound, String tag) {
        return new UUID(tagCompound.func_74763_f(tag + "Most"), tagCompound.func_74763_f(tag + "Least"));
    }

    @Override
    public Entity getEntityByUuid(UUID uuid, World world) {
        if (world instanceof CompatibleEntityProvider) {
            Entity e = ((CompatibleEntityProvider)world).getEntityByUuid(uuid);
            return e;
        }
        return null;
    }

    @Override
    public float getSmokeEffectScaleFactor() {
        return 2.0f;
    }
}

