/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.blocks;

import com.vicmatskiv.weaponlib.blocks.BlockSmith;
import com.vicmatskiv.weaponlib.blocks.DeconstructingInputQuantity;
import com.vicmatskiv.weaponlib.blocks.DeconstructingRecipeHandler;
import com.vicmatskiv.weaponlib.blocks.InventoryDeconstructResult;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ContainerDeconstructor
extends Container {
    public InventoryCrafting inputInventory = new InventoryCrafting((Container)this, 1, 1);
    public int inputSlotNumber;
    public InventoryDeconstructResult outputInventory = new InventoryDeconstructResult();
    public DeconstructingRecipeHandler deconstructingRecipeHandler;
    private final World worldObj;
    public InventoryPlayer playerInventory;
    public String resultString = "deconstructing.result.ready";
    public State deconstructingState = State.READY;
    public int x = 0;
    public int y = 0;
    public int z = 0;

    public ContainerDeconstructor(InventoryPlayer parPlayerInventory, World parWorld, int parX, int parY, int parZ) {
        this.x = parX;
        this.y = parY;
        this.z = parZ;
        this.worldObj = parWorld;
        this.deconstructingRecipeHandler = new DeconstructingRecipeHandler();
        for (int outputSlotIndexX = 0; outputSlotIndexX < 3; ++outputSlotIndexX) {
            for (int outputSlotIndexY = 0; outputSlotIndexY < 3; ++outputSlotIndexY) {
                this.func_75146_a(new Slot((IInventory)this.outputInventory, outputSlotIndexY + outputSlotIndexX * 3, 112 + outputSlotIndexY * 18, 17 + outputSlotIndexX * 18));
            }
        }
        this.inputSlotNumber = this.func_75146_a((Slot)new Slot((IInventory)this.inputInventory, (int)0, (int)45, (int)35)).field_75222_d;
        for (int playerSlotIndexY = 0; playerSlotIndexY < 3; ++playerSlotIndexY) {
            for (int playerSlotIndexX = 0; playerSlotIndexX < 9; ++playerSlotIndexX) {
                this.func_75146_a(new Slot((IInventory)parPlayerInventory, playerSlotIndexX + playerSlotIndexY * 9 + 9, 8 + playerSlotIndexX * 18, 84 + playerSlotIndexY * 18));
            }
        }
        for (int hotbarSlotIndex = 0; hotbarSlotIndex < 9; ++hotbarSlotIndex) {
            this.func_75146_a(new Slot((IInventory)parPlayerInventory, hotbarSlotIndex, 8 + hotbarSlotIndex * 18, 142));
        }
        this.playerInventory = parPlayerInventory;
    }

    public void func_75130_a(IInventory parInventory) {
        if (parInventory == this.inputInventory) {
            if (this.inputInventory.func_70301_a(0) == null) {
                this.resultString = I18n.func_135052_a((String)"deconstructing.result.ready", (Object[])new Object[0]);
                this.deconstructingState = State.READY;
                return;
            }
            int amountRequired = DeconstructingInputQuantity.getStackSizeNeeded(this.inputInventory.func_70301_a(0));
            System.out.println("Amount required = " + amountRequired);
            if (amountRequired > this.inputInventory.func_70301_a((int)0).field_77994_a) {
                this.resultString = I18n.func_135052_a((String)"deconstructing.result.needMoreStacks", (Object[])new Object[]{amountRequired - this.inputInventory.func_70301_a((int)0).field_77994_a});
                this.deconstructingState = State.ERROR;
                return;
            }
            if (amountRequired <= 0) {
                this.resultString = I18n.func_135052_a((String)"deconstructing.result.impossible", (Object[])new Object[0]);
                this.deconstructingState = State.ERROR;
                return;
            }
            ItemStack[] outputItemStackArray = this.deconstructingRecipeHandler.getDeconstructResults(this.inputInventory.func_70301_a(0));
            if (outputItemStackArray == null) {
                this.resultString = I18n.func_135052_a((String)"deconstructing.result.impossible", (Object[])new Object[0]);
                this.deconstructingState = State.ERROR;
                return;
            }
            while (this.inputInventory.func_70301_a(0) != null && amountRequired > 0 && amountRequired <= this.inputInventory.func_70301_a((int)0).field_77994_a) {
                int i;
                if (!this.outputInventory.isEmpty()) {
                    for (i = 0; i < this.outputInventory.func_70302_i_(); ++i) {
                        ItemStack itemStackInOutputSlot = this.outputInventory.func_70301_a(i);
                        if (itemStackInOutputSlot == null || outputItemStackArray[i] == null || itemStackInOutputSlot.func_77969_a(outputItemStackArray[i])) continue;
                        if (!this.playerInventory.func_70441_a(itemStackInOutputSlot)) {
                            EntityItem entityItem = this.playerInventory.field_70458_d.func_70099_a(itemStackInOutputSlot, 0.5f);
                            entityItem.field_70165_t = this.playerInventory.field_70458_d.field_70165_t;
                            entityItem.field_70163_u = this.playerInventory.field_70458_d.field_70163_u;
                            entityItem.field_70161_v = this.playerInventory.field_70458_d.field_70161_v;
                        }
                        this.outputInventory.func_70299_a(i, null);
                    }
                }
                for (i = 0; i < outputItemStackArray.length; ++i) {
                    ItemStack outputItemStack = outputItemStackArray[i];
                    ItemStack currentStack = this.outputInventory.func_70301_a(i);
                    if (outputItemStack == null) continue;
                    int metadata = outputItemStack.func_77960_j();
                    if (metadata == Short.MAX_VALUE) {
                        metadata = 0;
                    }
                    ItemStack newStack = null;
                    if (currentStack != null && 1 + currentStack.field_77994_a <= outputItemStack.func_77976_d()) {
                        newStack = new ItemStack(outputItemStack.func_77973_b(), 1 + currentStack.field_77994_a, metadata);
                    } else {
                        if (currentStack != null && !this.playerInventory.func_70441_a(currentStack)) {
                            EntityItem entityItem = this.playerInventory.field_70458_d.func_70099_a(currentStack, 0.5f);
                            entityItem.field_70165_t = this.playerInventory.field_70458_d.field_70165_t;
                            entityItem.field_70163_u = this.playerInventory.field_70458_d.field_70163_u;
                            entityItem.field_70161_v = this.playerInventory.field_70458_d.field_70161_v;
                        }
                        newStack = new ItemStack(outputItemStack.func_77973_b(), 1, metadata);
                    }
                    this.outputInventory.func_70299_a(i, newStack);
                }
                this.playerInventory.field_70458_d.func_71064_a(BlockSmith.deconstructedItemsStat, amountRequired);
                this.playerInventory.field_70458_d.func_71029_a(BlockSmith.deconstructAny);
                this.inputInventory.func_70298_a(0, amountRequired);
            }
        } else {
            this.resultString = I18n.func_135052_a((String)"deconstructing.result.impossible", (Object[])new Object[0]);
            this.deconstructingState = State.ERROR;
        }
    }

    public ItemStack func_75144_a(int parSlotId, int parMouseButtonId, int parClickMode, EntityPlayer parPlayer) {
        ItemStack clickItemStack = super.func_75144_a(parSlotId, parMouseButtonId, parClickMode, parPlayer);
        if (this.field_75151_b.size() > parSlotId && parSlotId >= 0 && this.field_75151_b.get(parSlotId) != null && ((Slot)this.field_75151_b.get((int)parSlotId)).field_75224_c == this.inputInventory) {
            this.func_75130_a((IInventory)this.inputInventory);
        }
        return clickItemStack;
    }

    public void func_75134_a(EntityPlayer parPlayer) {
        if (this.playerInventory.func_70445_o() != null) {
            parPlayer.func_70099_a(this.playerInventory.func_70445_o(), 0.5f);
        }
        if (!this.worldObj.field_72995_K) {
            ItemStack itemStack = this.inputInventory.func_70304_b(0);
            if (itemStack != null) {
                parPlayer.func_70099_a(itemStack, 0.5f);
            }
            for (int i = 0; i < this.outputInventory.func_70302_i_(); ++i) {
                itemStack = this.outputInventory.func_70304_b(i);
                if (itemStack == null) continue;
                parPlayer.func_70099_a(itemStack, 0.5f);
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer parPlayer, int parSlotIndex) {
        Slot slot = (Slot)this.field_75151_b.get(parSlotIndex);
        if (slot != null && slot.func_75216_d()) {
            if (slot.field_75224_c.equals(this.inputInventory) || slot.field_75224_c.equals(this.outputInventory)) {
                if (!this.playerInventory.func_70441_a(slot.func_75211_c())) {
                    return null;
                }
                slot.func_75215_d(null);
                slot.func_75218_e();
            } else if (slot.field_75224_c.equals(this.playerInventory)) {
                System.out.println("Shift-clicked on player inventory slot");
                if (!((Slot)this.field_75151_b.get(this.inputSlotNumber)).func_75216_d()) {
                    ((Slot)this.field_75151_b.get(this.inputSlotNumber)).func_75215_d(slot.func_75211_c());
                    slot.func_75215_d(null);
                    slot.func_75218_e();
                } else {
                    System.out.println("There is already something in the input slot");
                }
            }
        }
        return null;
    }

    public Slot func_75139_a(int parSlotIndex) {
        if (parSlotIndex >= this.field_75151_b.size()) {
            parSlotIndex = this.field_75151_b.size() - 1;
        }
        return super.func_75139_a(parSlotIndex);
    }

    public static enum State {
        ERROR,
        READY;

    }
}

