/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.animation;

import com.vicmatskiv.weaponlib.animation.PlayerRawPitchAnimation;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;

public class PlayerRawPitchAnimationManager {
    private Map<EntityPlayer, PlayerRawPitchAnimation> animations = new HashMap<EntityPlayer, PlayerRawPitchAnimation>();
    private float maxYaw = 2.0f;
    private float maxPitch = 2.0f;
    private long transitionDuration = 2000L;

    public PlayerRawPitchAnimationManager setMaxYaw(float maxYaw) {
        this.maxYaw = maxYaw;
        return this;
    }

    public PlayerRawPitchAnimationManager setMaxPitch(float maxPitch) {
        this.maxPitch = maxPitch;
        return this;
    }

    public PlayerRawPitchAnimationManager setTransitionDuration(long transitionDuration) {
        this.transitionDuration = transitionDuration;
        return this;
    }

    public void update(EntityPlayer player) {
        this.getAnimation(player).update();
    }

    public void reset(EntityPlayer player) {
        this.getAnimation(player).reset();
    }

    private PlayerRawPitchAnimation getAnimation(EntityPlayer player) {
        return this.animations.computeIfAbsent(player, p -> new PlayerRawPitchAnimation().setMaxPitch(this.maxPitch).setMaxYaw(this.maxYaw).setPlayer(player).setTransitionDuration(this.transitionDuration));
    }
}

