/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.EntityProjectile;
import com.vicmatskiv.weaponlib.Explosion;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import com.vicmatskiv.weaponlib.compatibility.CompatibleBlockState;
import com.vicmatskiv.weaponlib.compatibility.CompatibleRayTraceResult;
import com.vicmatskiv.weaponlib.compatibility.CompatibleTargetPoint;
import com.vicmatskiv.weaponlib.config.Projectiles;
import com.vicmatskiv.weaponlib.particle.SpawnParticleMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WeaponSpawnEntity
extends EntityProjectile {
    private static final Logger logger = LogManager.getLogger(WeaponSpawnEntity.class);
    private static final String TAG_ENTITY_ITEM = "entityItem";
    private static final String TAG_DAMAGE = "damage";
    private static final String TAG_EXPLOSION_RADIUS = "explosionRadius";
    private float explosionRadius;
    private float damage = 6.0f;
    private Weapon weapon;

    public WeaponSpawnEntity(World world) {
        super(world);
    }

    public WeaponSpawnEntity(Weapon weapon, World world, EntityLivingBase player, float speed, float gravityVelocity, float inaccuracy, float damage, float explosionRadius, Material ... damageableBlockMaterials) {
        super(world, player, speed, gravityVelocity, inaccuracy);
        this.weapon = weapon;
        this.damage = damage;
        this.explosionRadius = explosionRadius;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    @Override
    protected void onImpact(CompatibleRayTraceResult position) {
        if (CompatibilityProvider.compatibility.world((Entity)this).field_72995_K) {
            return;
        }
        if (this.weapon == null) {
            return;
        }
        if (this.explosionRadius > 0.0f) {
            Explosion.createServerSideExplosion(this.weapon.getModContext(), CompatibilityProvider.compatibility.world(this), this, position.getHitVec().getXCoord(), position.getHitVec().getYCoord(), position.getHitVec().getZCoord(), this.explosionRadius, false, true);
        } else if (position.getEntityHit() != null) {
            Projectiles projectilesConfig = this.weapon.getModContext().getConfigurationManager().getProjectiles();
            if (this.getThrower() != null && (projectilesConfig.isKnockbackOnHit() == null || projectilesConfig.isKnockbackOnHit().booleanValue())) {
                position.getEntityHit().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.getThrower()), this.damage);
            } else {
                position.getEntityHit().func_70097_a(CompatibilityProvider.compatibility.genericDamageSource(), this.damage);
            }
            position.getEntityHit().field_70172_ad = 0;
            position.getEntityHit().field_70126_B = (float)((double)position.getEntityHit().field_70126_B - 0.3);
            logger.debug("Hit entity {}", new Object[]{position.getEntityHit()});
            CompatibleTargetPoint point = new CompatibleTargetPoint(position.getEntityHit().field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 100.0);
            double magnitude = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y) + 1.0;
            Float bleedingCoefficient = projectilesConfig.getBleedingOnHit();
            if (bleedingCoefficient != null && bleedingCoefficient.floatValue() > 0.0f) {
                int count = (int)((float)this.getParticleCount(this.damage) * bleedingCoefficient.floatValue());
                logger.debug("Generating {} particle(s) per damage {}", new Object[]{count, Float.valueOf(this.damage)});
                this.weapon.getModContext().getChannel().sendToAllAround(new SpawnParticleMessage(SpawnParticleMessage.ParticleType.BLOOD, count, position.getEntityHit().field_70165_t - this.field_70159_w / magnitude, position.getEntityHit().field_70163_u - this.field_70181_x / magnitude, position.getEntityHit().field_70161_v - this.field_70179_y / magnitude), point);
            }
        } else if (position.getTypeOfHit() == CompatibleRayTraceResult.Type.BLOCK) {
            this.weapon.onSpawnEntityBlockImpact(CompatibilityProvider.compatibility.world(this), null, this, position);
        }
        this.func_70106_y();
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeInt(Item.func_150891_b((Item)this.weapon));
        buffer.writeFloat(this.damage);
        buffer.writeFloat(this.explosionRadius);
    }

    @Override
    public void readSpawnData(ByteBuf buffer) {
        super.readSpawnData(buffer);
        this.weapon = (Weapon)Item.func_150899_d((int)buffer.readInt());
        this.damage = buffer.readFloat();
        this.explosionRadius = buffer.readFloat();
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        Item item = Item.func_150899_d((int)tagCompound.func_74762_e(TAG_ENTITY_ITEM));
        if (item instanceof Weapon) {
            this.weapon = (Weapon)item;
        }
        this.damage = tagCompound.func_74760_g(TAG_DAMAGE);
        this.explosionRadius = tagCompound.func_74760_g(TAG_EXPLOSION_RADIUS);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a(TAG_ENTITY_ITEM, Item.func_150891_b((Item)this.weapon));
        tagCompound.func_74776_a(TAG_DAMAGE, this.damage);
        tagCompound.func_74776_a(TAG_EXPLOSION_RADIUS, this.explosionRadius);
    }

    Weapon getWeapon() {
        return this.weapon;
    }

    boolean isDamageableEntity(Entity entity) {
        return false;
    }

    int getParticleCount(float damage) {
        return (int)(-0.11 * (double)(damage - 30.0f) * (double)(damage - 30.0f) + 100.0);
    }

    @Override
    public boolean canCollideWithBlock(Block block, CompatibleBlockState metadata) {
        return !CompatibilityProvider.compatibility.isBlockPenetratableByBullets(block) && super.canCollideWithBlock(block, metadata);
    }
}

