/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.ClientModContext;
import com.vicmatskiv.weaponlib.Part;
import com.vicmatskiv.weaponlib.PlayerTransitionProvider;
import com.vicmatskiv.weaponlib.RenderContext;
import com.vicmatskiv.weaponlib.RenderableState;
import com.vicmatskiv.weaponlib.animation.MultipartPositioning;
import com.vicmatskiv.weaponlib.animation.MultipartRenderStateManager;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import com.vicmatskiv.weaponlib.compatibility.CompatibleEnumHandSide;
import com.vicmatskiv.weaponlib.compatibility.CompatibleExtraEntityFlags;
import com.vicmatskiv.weaponlib.compatibility.CompatibleTransformType;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class PlayerRenderer {
    private static final Logger logger = LogManager.getLogger(PlayerRenderer.class);
    private PlayerTransitionProvider transitionProvider;
    private ThreadLocal<MultipartPositioning.Positioner<Part, RenderContext<RenderableState>>> currentPositioner = new ThreadLocal();
    private int currentFlags;
    private int newFlags;
    private long renderingStartTimestamp;
    private long playerStopMovingTimestamp;
    private ClientModContext clientModContext;
    private MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>> stateManager;

    public PlayerRenderer(ClientModContext clientModContext) {
        this.clientModContext = clientModContext;
        this.transitionProvider = clientModContext.getPlayerTransitionProvider();
    }

    private StateDescriptor getStateDescriptor(EntityPlayer player) {
        if (this.currentFlags != this.newFlags) {
            this.stateManager = null;
        }
        if (this.stateManager == null) {
            this.stateManager = new MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>>(RenderableState.NORMAL, this.transitionProvider, () -> this.currentTime(player));
        } else if (player.field_70140_Q == player.field_70141_P) {
            this.stateManager.setState(RenderableState.PRONING_AIMING, true, true, true);
        } else {
            this.stateManager.setCycleState(RenderableState.PRONING, false);
        }
        return new StateDescriptor(this.stateManager, 0.0f, 0.0f);
    }

    private long currentTime(EntityPlayer player) {
        int renderingStartThreshold;
        long elapseRenderingStart = System.currentTimeMillis() - this.renderingStartTimestamp;
        if (elapseRenderingStart < (long)(renderingStartThreshold = 400)) {
            return elapseRenderingStart;
        }
        long afterStopMovingTimeout = 0L;
        if (player.field_70140_Q == player.field_70141_P) {
            if (this.playerStopMovingTimestamp == 0L) {
                this.playerStopMovingTimestamp = System.currentTimeMillis();
            } else if (afterStopMovingTimeout < 1000L) {
                afterStopMovingTimeout = System.currentTimeMillis() - this.playerStopMovingTimestamp;
            }
        } else {
            this.playerStopMovingTimestamp = 0L;
        }
        return (long)((float)renderingStartThreshold + player.field_70140_Q * 600.0f + (float)afterStopMovingTimeout);
    }

    public void renderModel(ModelBiped modelPlayer, EntityPlayer player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.newFlags = CompatibleExtraEntityFlags.getFlags((Entity)player);
        if (this.newFlags != this.currentFlags) {
            this.renderingStartTimestamp = System.currentTimeMillis();
        }
        if ((this.newFlags & CompatibleExtraEntityFlags.PRONING) != 0) {
            this.renderProningModel2(modelPlayer, player, ageInTicks, netHeadYaw, headPitch, scale);
        } else {
            modelPlayer.func_78088_a((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        }
        this.currentFlags = this.newFlags;
    }

    private void renderProningModel2(ModelBiped modelPlayer, EntityPlayer player, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        StateDescriptor stateDescriptor = this.getStateDescriptor(player);
        MultipartPositioning<Part, RenderContext<RenderableState>> multipartPositioning = stateDescriptor.stateManager.nextPositioning();
        MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner = multipartPositioning.getPositioner();
        this.currentPositioner.set(positioner);
        GL11.glPushMatrix();
        RenderContext<RenderableState> renderContext = new RenderContext<RenderableState>(this.clientModContext, (EntityLivingBase)player, null);
        renderContext.setAgeInTicks(ageInTicks);
        renderContext.setScale(scale);
        renderContext.setLimbSwing(0.0f);
        renderContext.setNetHeadYaw(netHeadYaw);
        renderContext.setHeadPitch(headPitch);
        renderContext.setCompatibleTransformType(CompatibleTransformType.NONE);
        modelPlayer.func_78087_a(0.0f, 0.0f, renderContext.getAgeInTicks(), renderContext.getNetHeadYaw(), renderContext.getHeadPitch(), renderContext.getScale(), (Entity)renderContext.getPlayer());
        positioner.position(Part.MAIN, renderContext);
        this.renderBody(positioner, modelPlayer, renderContext);
        this.renderHead(positioner, modelPlayer, renderContext);
        this.renderLeftArm(positioner, modelPlayer, renderContext);
        this.renderRightArm(positioner, modelPlayer, renderContext);
        this.renderLeftLeg(positioner, modelPlayer, renderContext);
        this.renderRightLeg(positioner, modelPlayer, renderContext);
        GL11.glPopMatrix();
    }

    private void renderBody(MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner, ModelBiped modelPlayer, RenderContext<RenderableState> renderContext) {
        GL11.glPushMatrix();
        modelPlayer.field_78115_e.func_78785_a(renderContext.getScale());
        CompatibilityProvider.compatibility.renderBodywear(modelPlayer, renderContext.getScale());
        GL11.glPopMatrix();
    }

    private void renderHead(MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner, ModelBiped modelPlayer, RenderContext<RenderableState> renderContext) {
        GL11.glPushMatrix();
        positioner.position(Part.HEAD, renderContext);
        modelPlayer.field_78116_c.func_78785_a(renderContext.getScale());
        CompatibilityProvider.compatibility.renderHeadwear(modelPlayer, renderContext.getScale());
        GL11.glPopMatrix();
    }

    private void renderRightArm(MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner, ModelBiped modelPlayer, RenderContext<RenderableState> renderContext) {
        GL11.glPushMatrix();
        positioner.position(Part.RIGHT_HAND, renderContext);
        modelPlayer.field_78112_f.func_78785_a(renderContext.getScale());
        CompatibilityProvider.compatibility.renderRightArmwear(modelPlayer, renderContext.getScale());
        GL11.glPopMatrix();
    }

    private void renderLeftArm(MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner, ModelBiped modelPlayer, RenderContext<RenderableState> renderContext) {
        GL11.glPushMatrix();
        positioner.position(Part.LEFT_HAND, renderContext);
        modelPlayer.field_78113_g.func_78785_a(renderContext.getScale());
        CompatibilityProvider.compatibility.renderLeftArmwear(modelPlayer, renderContext.getScale());
        GL11.glPopMatrix();
    }

    private void renderRightLeg(MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner, ModelBiped modelPlayer, RenderContext<RenderableState> renderContext) {
        GL11.glPushMatrix();
        positioner.position(Part.RIGHT_LEG, renderContext);
        modelPlayer.field_78123_h.func_78785_a(renderContext.getScale());
        CompatibilityProvider.compatibility.renderRightLegwear(modelPlayer, renderContext.getScale());
        GL11.glPopMatrix();
    }

    private void renderLeftLeg(MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner, ModelBiped modelPlayer, RenderContext<RenderableState> renderContext) {
        GL11.glPushMatrix();
        positioner.position(Part.LEFT_LEG, renderContext);
        modelPlayer.field_78124_i.func_78785_a(renderContext.getScale());
        CompatibilityProvider.compatibility.renderLeftLegwear(modelPlayer, renderContext.getScale());
        GL11.glPopMatrix();
    }

    public boolean renderArmor(ModelBiped modelPlayer, EntityPlayer player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if ((this.currentFlags & CompatibleExtraEntityFlags.PRONING) != 0) {
            return this.renderArmor2(modelPlayer, player, ageInTicks, netHeadYaw, headPitch, scale);
        }
        return false;
    }

    private boolean renderArmor2(ModelBiped modelPlayer, EntityPlayer player, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner = this.currentPositioner.get();
        if (positioner != null) {
            GL11.glPushMatrix();
            RenderContext<RenderableState> renderContext = new RenderContext<RenderableState>(this.clientModContext, (EntityLivingBase)player, null);
            renderContext.setAgeInTicks(ageInTicks);
            renderContext.setScale(scale);
            renderContext.setLimbSwing(0.0f);
            renderContext.setNetHeadYaw(netHeadYaw);
            renderContext.setHeadPitch(headPitch);
            renderContext.setCompatibleTransformType(CompatibleTransformType.NONE);
            modelPlayer.func_78087_a(0.0f, 0.0f, renderContext.getAgeInTicks(), renderContext.getNetHeadYaw(), renderContext.getHeadPitch(), renderContext.getScale(), (Entity)renderContext.getPlayer());
            positioner.position(Part.MAIN, renderContext);
            this.renderBody(positioner, modelPlayer, renderContext);
            this.renderHead(positioner, modelPlayer, renderContext);
            this.renderLeftArm(positioner, modelPlayer, renderContext);
            this.renderRightArm(positioner, modelPlayer, renderContext);
            this.renderLeftLeg(positioner, modelPlayer, renderContext);
            this.renderRightLeg(positioner, modelPlayer, renderContext);
            GL11.glPopMatrix();
        }
        return positioner != null;
    }

    public boolean positionItemSide(EntityPlayer player, ItemStack itemStack, CompatibleTransformType transformType, CompatibleEnumHandSide handSide) {
        MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner = this.currentPositioner.get();
        if (positioner != null) {
            RenderContext renderContext = new RenderContext(this.clientModContext, (EntityLivingBase)player, null);
            positioner.position(Part.MAIN, renderContext);
            if (handSide == CompatibleEnumHandSide.LEFT) {
                positioner.position(Part.LEFT_HAND, renderContext);
            } else if (handSide == null || handSide == CompatibleEnumHandSide.RIGHT) {
                positioner.position(Part.RIGHT_HAND, renderContext);
            }
            GL11.glTranslatef((float)-0.35f, (float)0.1f, (float)-0.0f);
            GL11.glRotatef((float)-378.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)360.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        return positioner != null;
    }

    protected static class StateDescriptor {
        protected MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>> stateManager;
        protected float rate;
        protected float amplitude = 0.04f;

        public StateDescriptor(MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>> stateManager, float rate, float amplitude) {
            this.stateManager = stateManager;
            this.rate = rate;
            this.amplitude = amplitude;
        }
    }
}

