/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.ambientsounds;

import com.creativemd.ambientsounds.AmbientCondition;
import com.creativemd.ambientsounds.AmbientDimension;
import com.creativemd.ambientsounds.AmbientSound;
import com.creativemd.ambientsounds.AmbientSounds;
import com.creativemd.ambientsounds.TickHandler;
import com.google.common.base.Charsets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.commons.io.IOUtils;

public class AmbientSoundLoader {
    public static ResourceLocation engine = new ResourceLocation("ambientsounds", "engine.json");
    public static LinkedHashMap<String, AmbientCondition> regions = new LinkedHashMap();
    public static ArrayList<AmbientSound> sounds = new ArrayList();
    public static ArrayList<AmbientDimension> dimensions = new ArrayList();
    private static Minecraft mc = Minecraft.func_71410_x();
    private static JsonParser parser = new JsonParser();

    public static AmbientDimension getDimension(World world) {
        for (int i = 0; i < dimensions.size(); ++i) {
            if (!dimensions.get(i).is(world)) continue;
            return dimensions.get(i);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void reloadAmbientSounds() {
        AmbientSounds.config.load();
        regions.clear();
        sounds.clear();
        dimensions.clear();
        for (int i = 0; i < TickHandler.playing.size(); ++i) {
            TickHandler.playing.get(i).stopSound();
        }
        TickHandler.playing.clear();
        try {
            JsonObject object;
            int i;
            IResource resource = mc.func_110442_L().func_110536_a(engine);
            JsonObject root = parser.parse(IOUtils.toString((InputStream)resource.func_110527_b(), (Charset)Charsets.UTF_8)).getAsJsonObject();
            JsonArray array = root.get("regions").getAsJsonArray();
            for (i = 0; i < array.size(); ++i) {
                try {
                    if (!array.get(i).isJsonObject()) throw new IllegalArgumentException("Invalid child of 'regions' array!");
                    object = array.get(i).getAsJsonObject();
                    JsonElement name = object.get("name");
                    if (!name.isJsonPrimitive() || !((JsonPrimitive)name).isString()) throw new IllegalArgumentException("Invalid name of child in 'regions' array!");
                    AmbientCondition condition = AmbientCondition.parser.parseCondition((JsonElement)object);
                    if (condition == null) {
                        throw new IllegalArgumentException("Invalid condition of child in 'regions' array!");
                    }
                    regions.put(name.getAsString(), condition);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AmbientSounds.logger.error("Could not load " + i + ". child of 'regions' array!");
                }
            }
            array = root.get("dimensions").getAsJsonArray();
            for (i = 0; i < array.size(); ++i) {
                try {
                    if (!array.get(i).isJsonObject()) {
                        throw new IllegalArgumentException("Invalid child of 'dimensions' array!");
                    }
                    dimensions.add(new AmbientDimension(array.get(i)));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AmbientSounds.logger.error("Could not load " + i + ". child of 'dimensions' array!");
                }
            }
            array = root.get("sounds").getAsJsonArray();
            for (i = 0; i < array.size(); ++i) {
                try {
                    if (!array.get(i).isJsonObject()) {
                        throw new IllegalArgumentException("Invalid child of 'sounds' array!");
                    }
                    object = array.get(i).getAsJsonObject();
                    AmbientSound sound = new AmbientSound(object);
                    sound.volumeSetting = AmbientSounds.config.getFloat(sound.name.toString(), "volume", 1.0f, 0.0f, 1.0f, "");
                    sounds.add(sound);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AmbientSounds.logger.error("Could not load " + i + ". child of 'sounds' array!");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AmbientSounds.logger.error("Sound engine crashed, no sounds will be played!");
            regions.clear();
            sounds.clear();
        }
        AmbientSounds.config.save();
    }
}

