/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.ambientsounds;

import com.creativemd.ambientsounds.AmbientSounds;
import com.creativemd.ambientsounds.IEnhancedPositionSound;
import io.netty.util.internal.ThreadLocalRandom;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.sound.PlaySoundSourceEvent;
import net.minecraftforge.client.event.sound.PlayStreamingSourceEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import paulscode.sound.Library;
import paulscode.sound.SoundSystem;

public class AmbientSoundEngine {
    public SoundManager manager;
    public GameSettings settings;
    public List<IEnhancedPositionSound> sounds = new ArrayList<IEnhancedPositionSound>();
    private static Field system = ReflectionHelper.findField(SoundManager.class, (String[])new String[]{"sndSystem", "field_148620_e"});
    private static Field loaded = ReflectionHelper.findField(SoundManager.class, (String[])new String[]{"loaded", "field_148617_f"});

    public SoundSystem getSystem() {
        try {
            return (SoundSystem)system.get(this.manager);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return null;
        }
    }

    public AmbientSoundEngine(SoundManager manager, GameSettings settings) {
        this.settings = settings;
        this.manager = manager;
    }

    public void tick() {
        SoundSystem system = this.getSystem();
        Library library = (Library)ReflectionHelper.getPrivateValue(SoundSystem.class, (Object)system, (String[])new String[]{"soundLibrary"});
        Iterator<IEnhancedPositionSound> iterator = this.sounds.iterator();
        try {
            if (!loaded.getBoolean(this.manager)) {
                return;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        while (iterator.hasNext()) {
            IEnhancedPositionSound sound = iterator.next();
            if (!system.playing(sound.systemName)) {
                if (!sound.hasBeenAdded) continue;
                if (sound.repeat && AmbientSounds.debugging) {
                    System.out.println("Unexpected ending sound " + sound.func_147650_b() + " " + sound.systemName);
                }
                sound.playing = false;
                if (library != null) {
                    library.removeSource(sound.systemName);
                } else {
                    System.out.println("No library found. Something went wrong!");
                }
                iterator.remove();
                continue;
            }
            sound.hasBeenAdded = true;
        }
        for (IEnhancedPositionSound itickablesound : this.sounds) {
            itickablesound.func_73660_a();
            system.setVolume(itickablesound.systemName, this.getClampedVolume((ISound)itickablesound));
            system.setPitch(itickablesound.systemName, this.getClampedPitch((ISound)itickablesound));
            system.setPosition(itickablesound.systemName, itickablesound.func_147649_g(), itickablesound.func_147654_h(), itickablesound.func_147651_i());
        }
    }

    public void play(IEnhancedPositionSound p_sound) {
        try {
            if (!loaded.getBoolean(this.manager)) {
                return;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        SoundSystem system = this.getSystem();
        SoundEventAccessor soundeventaccessor = p_sound.func_184366_a(this.manager.field_148622_c);
        ResourceLocation resourcelocation = p_sound.func_147650_b();
        Sound sound = p_sound.func_184364_b();
        float f3 = p_sound.func_147653_e();
        float f = 16.0f;
        if (f3 > 1.0f) {
            f *= f3;
        }
        SoundCategory soundcategory = p_sound.func_184365_d();
        float f1 = this.getClampedVolume((ISound)p_sound);
        float f2 = this.getClampedPitch((ISound)p_sound);
        if (f1 > 0.0f) {
            boolean flag = p_sound.func_147657_c() && p_sound.func_147652_d() == 0;
            String s = MathHelper.func_180182_a((Random)ThreadLocalRandom.current()).toString();
            ResourceLocation resourcelocation1 = sound.func_188721_b();
            if (sound.func_188723_h()) {
                system.newStreamingSource(false, s, AmbientSoundEngine.getURLForSoundResource(resourcelocation1), resourcelocation1.toString(), flag, p_sound.func_147649_g(), p_sound.func_147654_h(), p_sound.func_147651_i(), p_sound.func_147656_j().func_148586_a(), f);
                MinecraftForge.EVENT_BUS.post((Event)new PlayStreamingSourceEvent(this.manager, (ISound)p_sound, s));
            } else {
                system.newSource(false, s, AmbientSoundEngine.getURLForSoundResource(resourcelocation1), resourcelocation1.toString(), flag, p_sound.func_147649_g(), p_sound.func_147654_h(), p_sound.func_147651_i(), p_sound.func_147656_j().func_148586_a(), f);
                MinecraftForge.EVENT_BUS.post((Event)new PlaySoundSourceEvent(this.manager, (ISound)p_sound, s));
            }
            p_sound.systemName = s;
            system.setPitch(s, f2);
            system.setVolume(s, f1);
            system.play(s);
            p_sound.playing = true;
            this.sounds.add(p_sound);
        }
    }

    private static URL getURLForSoundResource(final ResourceLocation p_148612_0_) {
        String s = String.format("%s:%s:%s", "mcsounddomain", p_148612_0_.func_110624_b(), p_148612_0_.func_110623_a());
        URLStreamHandler urlstreamhandler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL p_openConnection_1_) {
                return new URLConnection(p_openConnection_1_){

                    @Override
                    public void connect() throws IOException {
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return Minecraft.func_71410_x().func_110442_L().func_110536_a(p_148612_0_).func_110527_b();
                    }
                };
            }
        };
        try {
            return new URL((URL)null, s, urlstreamhandler);
        }
        catch (MalformedURLException var4) {
            throw new Error("TODO: Sanely handle url exception! :D");
        }
    }

    private float getClampedPitch(ISound soundIn) {
        return MathHelper.func_76131_a((float)soundIn.func_147655_f(), (float)0.5f, (float)2.0f);
    }

    private float getClampedVolume(ISound soundIn) {
        return MathHelper.func_76131_a((float)(soundIn.func_147653_e() * this.getVolume(soundIn.func_184365_d())), (float)0.0f, (float)1.0f);
    }

    private float getVolume(SoundCategory category) {
        return category != null && category != SoundCategory.MASTER ? this.settings.func_186711_a(category) : 1.0f;
    }

    public void stop(IEnhancedPositionSound sound) {
        SoundSystem system = this.getSystem();
        sound.playing = false;
        system.stop(sound.systemName);
        system.removeSource(sound.systemName);
        this.sounds.remove(sound);
    }
}

