/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.ambientsounds;

import com.creativemd.ambientsounds.AmbientCondition;
import com.creativemd.ambientsounds.AmbientSituation;
import com.creativemd.ambientsounds.AmbientSoundEngine;
import com.creativemd.ambientsounds.AmbientSoundResult;
import com.creativemd.ambientsounds.IEnhancedPositionSound;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class AmbientSound {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static SoundManager manager = (SoundManager)ReflectionHelper.getPrivateValue(SoundHandler.class, (Object)mc.func_147118_V(), (String[])new String[]{"sndManager", "field_147694_f"});
    public static AmbientSoundEngine engine = new AmbientSoundEngine(manager, AmbientSound.mc.field_71474_y);
    private static Random rand = new Random();
    public static AmbientSoundSelectorParser parser = new AmbientSoundSelectorParser();
    public static LinkedHashMap<String, AmbientPropertyType> propertiesTypes = new LinkedHashMap();
    public ResourceLocation name;
    public boolean isFull;
    public int playingTime = -1;
    public int pause = 0;
    public IEnhancedPositionSound sound;
    public float currentVolume;
    public float aimedVolume;
    public float currentPitch;
    public float aimedPitch;
    public final HashMap<String, Object> properties = new HashMap();
    public AmbientCondition condition;
    public boolean inTickList = false;
    public boolean keepVolume = false;
    public float fadeInAmount = 0.0f;
    public float fadeOutAmount = 0.0f;
    public float fadePitch = 0.01f;
    public float mutingFactor = 0.0f;
    public float volumeSetting = 1.0f;

    public static Object getValue(HashMap<String, Object> values, String identifier, Object defaultValue) {
        Object value = values.get(identifier);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public AmbientSound(JsonObject object) throws IllegalArgumentException {
        block0: for (Map.Entry entry : object.entrySet()) {
            if (((String)entry.getKey()).equals("source")) {
                if (AmbientPropertyType.STRING.isElementValid((JsonElement)entry.getValue())) {
                    this.name = new ResourceLocation(((JsonElement)entry.getValue()).getAsString());
                } else {
                    throw new IllegalArgumentException("Expected 'name' to be a string!");
                }
            }
            if (((String)entry.getKey()).equals("full")) {
                if (AmbientPropertyType.BOOLEAN.isElementValid((JsonElement)entry.getValue())) {
                    this.isFull = ((JsonElement)entry.getValue()).getAsBoolean();
                } else {
                    throw new IllegalArgumentException("Expected 'full' to be a boolean!");
                }
            }
            if (((String)entry.getKey()).equals("selector")) {
                this.condition = parser.parseCondition((JsonElement)entry.getValue());
            }
            if (this.condition == null) {
                this.condition = new AmbientCondition(){

                    @Override
                    public boolean is(AmbientSituation situation, AmbientSoundResult result) {
                        return true;
                    }
                };
            }
            for (Map.Entry<String, AmbientPropertyType> property : propertiesTypes.entrySet()) {
                if (!property.getKey().equals(entry.getKey())) continue;
                if (property.getValue().isElementValid((JsonElement)entry.getValue())) {
                    this.properties.put(property.getKey(), property.getValue().getElementValue((JsonElement)entry.getValue()));
                    continue block0;
                }
                throw new IllegalArgumentException("Expected '" + (String)entry.getKey() + "' to be a " + property.getValue().name().toLowerCase() + "!");
            }
        }
        if (this.name == null) {
            throw new IllegalArgumentException("No 'name' given!");
        }
    }

    public boolean isSoundPlaying() {
        return this.sound != null;
    }

    public void stopSound() {
        if (this.isSoundPlaying()) {
            engine.stop(this.sound);
            this.sound = null;
        }
    }

    public void tick(float mute) {
        if (this.isSoundPlaying() && (this.pause == 0 || this.sound.playing)) {
            float aimedVolume;
            if (!this.sound.playing) {
                engine.play(this.sound);
            }
            if (this.currentVolume < (aimedVolume = this.aimedVolume * mute)) {
                this.currentVolume += Math.min(this.fadeInAmount, aimedVolume - this.currentVolume);
            } else if (this.currentVolume > aimedVolume) {
                this.currentVolume -= Math.min(this.fadeOutAmount, this.currentVolume - aimedVolume);
            }
            if (this.currentPitch < this.aimedPitch) {
                this.currentPitch += Math.min(this.fadePitch, this.aimedPitch - this.currentPitch);
            } else if (this.currentPitch > this.aimedPitch) {
                this.currentPitch -= Math.min(this.fadePitch, this.currentPitch - this.aimedPitch);
            }
            this.sound.pitch = this.currentPitch;
            this.sound.volume = this.currentVolume * mute;
            if (aimedVolume == 0.0f && this.currentVolume == 0.0f) {
                this.stopSound();
            }
        } else if (!(this.pause <= 0 || this.sound != null && this.sound.playing)) {
            this.sound = null;
            this.keepVolume = true;
            --this.pause;
        }
    }

    public boolean update(AmbientSituation situation) {
        float fade;
        AmbientSoundResult result = new AmbientSoundResult();
        if (!this.condition.is(situation, result)) {
            this.aimedVolume = 0.0f;
            return false;
        }
        float volume = result.volume;
        HashMap<String, Object> values = new HashMap<String, Object>(this.properties);
        for (int i = 0; i < result.conditions.size(); ++i) {
            if (result.conditions.get((int)i).unknownValues == null) continue;
            values.putAll(result.conditions.get((int)i).unknownValues);
        }
        if (this.isFull && !result.takeBiome) {
            situation.selectedBiomes.clear();
        }
        int minPause = (int)((Double)AmbientSound.getValue(values, "minPause", 0.0)).doubleValue();
        int maxPause = (int)((Double)AmbientSound.getValue(values, "maxPause", 0.0)).doubleValue();
        int length = (int)((Double)AmbientSound.getValue(values, "length", 0.0)).doubleValue();
        float configVolume = 1.0f;
        if (values.containsKey("volume")) {
            configVolume = (float)((Double)AmbientSound.getValue(values, "volume", 0.0)).doubleValue();
        }
        float day = (float)((Double)AmbientSound.getValue(values, "day", 1.0)).doubleValue();
        float night = (float)((Double)AmbientSound.getValue(values, "night", 1.0)).doubleValue();
        this.fadeInAmount = this.fadeOutAmount = (fade = (float)((Double)AmbientSound.getValue(values, "fade", 0.002)).doubleValue());
        if (values.containsKey("fadeIn")) {
            this.fadeInAmount = (float)((Double)AmbientSound.getValue(values, "fadeIn", 0.002)).doubleValue();
        }
        if (values.containsKey("fadeOut")) {
            this.fadeOutAmount = (float)((Double)AmbientSound.getValue(values, "fadeOut", 0.002)).doubleValue();
        }
        volume = situation.isNight ? (volume *= night) : (volume *= day);
        if (result.takeBiome) {
            float biomeVolume = 0.0f;
            for (int i = 0; i < situation.selectedBiomes.size(); ++i) {
                biomeVolume = Math.max(biomeVolume, situation.biomes.get(situation.selectedBiomes.get(i)).floatValue());
            }
            volume *= biomeVolume;
        }
        this.mutingFactor = (float)((Double)AmbientSound.getValue(values, "mute", 0.0)).doubleValue();
        if ((volume *= configVolume * this.volumeSetting) > 0.0f && this.pause == 0 && !this.isSoundPlaying()) {
            if (this.isFull) {
                situation.playedFull = true;
            }
            if (!this.keepVolume) {
                this.currentVolume = 0.001f;
                this.currentPitch = 1.0f;
                this.keepVolume = false;
            }
            this.sound = new IEnhancedPositionSound(this.name, this.currentVolume, 1.0f);
            this.sound.repeat = minPause == 0 && maxPause == 0;
            this.pause = maxPause > minPause && maxPause > 0 ? rand.nextInt(maxPause - minPause) + minPause : 0;
            engine.play(this.sound);
        }
        this.aimedVolume = volume;
        this.aimedPitch = result.pitch;
        return volume > 0.0f;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.name + ", " + this.currentVolume + "/" + this.aimedVolume);
        if (this.pause > 0) {
            builder.append(" pause: " + this.pause);
        }
        return builder.toString();
    }

    static {
        propertiesTypes.put("mute", AmbientPropertyType.NUMBER);
        propertiesTypes.put("minPause", AmbientPropertyType.NUMBER);
        propertiesTypes.put("maxPause", AmbientPropertyType.NUMBER);
        propertiesTypes.put("length", AmbientPropertyType.NUMBER);
        propertiesTypes.put("volume", AmbientPropertyType.NUMBER);
        propertiesTypes.put("day", AmbientPropertyType.NUMBER);
        propertiesTypes.put("night", AmbientPropertyType.NUMBER);
        propertiesTypes.put("fade", AmbientPropertyType.NUMBER);
        propertiesTypes.put("fadeIn", AmbientPropertyType.NUMBER);
        propertiesTypes.put("fadeOut", AmbientPropertyType.NUMBER);
    }

    public static enum AmbientPropertyType {
        STRING{

            @Override
            public boolean isElementValid(JsonElement element) {
                return element.isJsonPrimitive() && ((JsonPrimitive)element).isString();
            }

            @Override
            public Object getElementValue(JsonElement element) {
                return element.getAsString();
            }
        }
        ,
        BOOLEAN{

            @Override
            public boolean isElementValid(JsonElement element) {
                return element.isJsonPrimitive() && ((JsonPrimitive)element).isBoolean();
            }

            @Override
            public Object getElementValue(JsonElement element) {
                return element.getAsBoolean();
            }
        }
        ,
        NUMBER{

            @Override
            public boolean isElementValid(JsonElement element) {
                return element.isJsonPrimitive();
            }

            @Override
            public Object getElementValue(JsonElement element) {
                return element.getAsDouble();
            }
        };


        public abstract boolean isElementValid(JsonElement var1);

        public abstract Object getElementValue(JsonElement var1);
    }

    public static class AmbientSoundSelectorParser
    extends AmbientCondition.AmbientConditionObjectParser {
        @Override
        public void treatUnknownValues(AmbientCondition condition, HashMap<String, JsonElement> unknown) {
            condition.unknownValues = new HashMap();
            block0: for (Map.Entry<String, JsonElement> entry : unknown.entrySet()) {
                for (Map.Entry<String, AmbientPropertyType> property : propertiesTypes.entrySet()) {
                    if (!property.getKey().equals(entry.getKey())) continue;
                    if (property.getValue().isElementValid(entry.getValue())) {
                        condition.unknownValues.put(property.getKey(), property.getValue().getElementValue(entry.getValue()));
                        continue block0;
                    }
                    throw new IllegalArgumentException("Expected '" + entry.getKey() + "' to be a " + property.getValue().name().toLowerCase() + "!");
                }
            }
        }
    }
}

