/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.ambientsounds;

import com.creativemd.ambientsounds.AmbientCondition;
import com.creativemd.ambientsounds.AmbientSituation;
import com.creativemd.ambientsounds.AmbientSoundResult;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class AmbientDimension {
    public final String name;
    public final ArrayList<AmbientDimensionProperty> properties = new ArrayList();
    public static LinkedHashMap<String, AmbientDimensionPropertyParser> dimensionParser = new LinkedHashMap();

    public AmbientDimension(JsonElement element) throws IllegalArgumentException {
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            this.name = object.get("name").getAsString();
            for (Map.Entry<String, AmbientDimensionPropertyParser> entry : dimensionParser.entrySet()) {
                AmbientDimensionProperty ambientDimensionProperty;
                JsonElement property = object.get(entry.getKey());
                if (property == null || (ambientDimensionProperty = entry.getValue().parseCondition(property)) == null) continue;
                this.properties.add(ambientDimensionProperty);
            }
        } else {
            throw new IllegalArgumentException("Invalid Dimension " + element);
        }
    }

    public boolean is(World world) {
        for (int i = 0; i < this.properties.size(); ++i) {
            if (this.properties.get(i).is(world)) continue;
            return false;
        }
        return true;
    }

    public void manipulateSituation(AmbientSituation situation) {
        for (int i = 0; i < this.properties.size(); ++i) {
            this.properties.get(i).manipulateSituation(situation);
        }
    }

    static {
        dimensionParser.put("id", new AmbientDimensionPropertyParser(){

            @Override
            public AmbientDimensionProperty parseCondition(final JsonElement element) throws IllegalArgumentException {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isNumber()) {
                    return new AmbientDimensionProperty(){

                        @Override
                        public void manipulateSituation(AmbientSituation situation) {
                        }

                        @Override
                        public boolean is(World world) {
                            return world.field_73011_w.getDimension() == element.getAsInt();
                        }
                    };
                }
                if (element.isJsonArray()) {
                    JsonArray array = element.getAsJsonArray();
                    final int[] ids = new int[array.size()];
                    for (int i = 0; i < array.size(); ++i) {
                        JsonElement e = array.get(i);
                        if (!e.isJsonPrimitive() || !((JsonPrimitive)e).isNumber()) {
                            throw new IllegalArgumentException("Expected a number instead of '" + element + "'!");
                        }
                        ids[i] = e.getAsInt();
                    }
                    return new AmbientDimensionProperty(){

                        @Override
                        public void manipulateSituation(AmbientSituation situation) {
                        }

                        @Override
                        public boolean is(World world) {
                            return ArrayUtils.contains((int[])ids, (int)world.field_73011_w.getDimension());
                        }
                    };
                }
                throw new IllegalArgumentException("Expected a number instead of '" + element + "'!");
            }
        });
        dimensionParser.put("rain", new AmbientDimensionPropertyParser(){

            @Override
            public AmbientDimensionProperty parseCondition(final JsonElement element) throws IllegalArgumentException {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isBoolean()) {
                    return new AmbientDimensionProperty(){

                        @Override
                        public void manipulateSituation(AmbientSituation situation) {
                            situation.isRaining = ((JsonPrimitive)element).getAsBoolean();
                        }

                        @Override
                        public boolean is(World world) {
                            return true;
                        }
                    };
                }
                throw new IllegalArgumentException("Expected a boolean instead of '" + element + "'!");
            }
        });
        dimensionParser.put("storm", new AmbientDimensionPropertyParser(){

            @Override
            public AmbientDimensionProperty parseCondition(final JsonElement element) throws IllegalArgumentException {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isBoolean()) {
                    return new AmbientDimensionProperty(){

                        @Override
                        public void manipulateSituation(AmbientSituation situation) {
                            situation.isThundering = ((JsonPrimitive)element).getAsBoolean();
                        }

                        @Override
                        public boolean is(World world) {
                            return true;
                        }
                    };
                }
                throw new IllegalArgumentException("Expected a boolean instead of '" + element + "'!");
            }
        });
        dimensionParser.put("average-height", new AmbientDimensionPropertyParser(){

            @Override
            public AmbientDimensionProperty parseCondition(final JsonElement element) throws IllegalArgumentException {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isNumber()) {
                    return new AmbientDimensionProperty(){

                        @Override
                        public void manipulateSituation(AmbientSituation situation) {
                            situation.relativeHeight = ((JsonPrimitive)element).getAsFloat();
                        }

                        @Override
                        public boolean is(World world) {
                            return true;
                        }
                    };
                }
                throw new IllegalArgumentException("Expected a number instead of '" + element + "'!");
            }
        });
        dimensionParser.put("isNight", new AmbientDimensionPropertyParser(){

            @Override
            public AmbientDimensionProperty parseCondition(final JsonElement element) throws IllegalArgumentException {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isBoolean()) {
                    return new AmbientDimensionProperty(){

                        @Override
                        public void manipulateSituation(AmbientSituation situation) {
                            situation.isNight = ((JsonPrimitive)element).getAsBoolean();
                        }

                        @Override
                        public boolean is(World world) {
                            return true;
                        }
                    };
                }
                throw new IllegalArgumentException("Expected a boolean instead of '" + element + "'!");
            }
        });
        dimensionParser.put("biome-selector", new AmbientDimensionPropertyParser(){

            @Override
            public AmbientDimensionProperty parseCondition(JsonElement element) throws IllegalArgumentException {
                final AmbientCondition condition = AmbientCondition.parser.parseCondition(element);
                if (condition != null) {
                    return new AmbientDimensionProperty(){

                        @Override
                        public void manipulateSituation(AmbientSituation situation) {
                            AmbientSoundResult result = new AmbientSoundResult();
                            situation.biomeVolume = condition.is(situation, result) ? result.volume : 0.0f;
                        }

                        @Override
                        public boolean is(World world) {
                            return true;
                        }
                    };
                }
                throw new IllegalArgumentException("Missing condition");
            }
        });
    }

    public static abstract class AmbientDimensionPropertyParser {
        public abstract AmbientDimensionProperty parseCondition(JsonElement var1) throws IllegalArgumentException;
    }

    public static abstract class AmbientDimensionProperty {
        public abstract boolean is(World var1);

        public abstract void manipulateSituation(AmbientSituation var1);
    }
}

