/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.ambientsounds;

import com.creativemd.ambientsounds.AmbientDimension;
import com.creativemd.ambientsounds.AmbientSituation;
import com.creativemd.ambientsounds.AmbientSound;
import com.creativemd.ambientsounds.AmbientSoundEngine;
import com.creativemd.ambientsounds.AmbientSoundLoader;
import com.creativemd.ambientsounds.AmbientSounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.client.event.sound.SoundSetupEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import paulscode.sound.SoundSystemConfig;

public class TickHandler {
    public static ArrayList<AmbientSound> playing = new ArrayList();
    public int timer = 0;
    public int envUpdateTickTime = 60;
    public int soundTickTime = 2;
    private static Minecraft mc = Minecraft.func_71410_x();
    public static AmbientSituation situation = null;

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            return;
        }
        for (int i = 0; i < playing.size(); ++i) {
            try {
                playing.get(i).stopSound();
            }
            catch (Exception exception) {
                // empty catch block
            }
            TickHandler.playing.get((int)i).inTickList = false;
        }
        playing.clear();
        situation = null;
        this.timer = 0;
    }

    public static float calculateAverageHeight(World world, EntityPlayer player) {
        float sum = 0.0f;
        int count = 0;
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                int posX = (int)(player.field_70165_t + (double)(x * 2));
                int posZ = (int)(player.field_70161_v + (double)(z * 2));
                int height = TickHandler.getHeightBlock(world, posX, posZ);
                sum += (float)height;
                ++count;
            }
        }
        float average = sum / (float)count;
        float y = (float)player.field_70163_u;
        return y - average;
    }

    public static int getHeightBlock(World world, int x, int z) {
        int heighest = 2;
        for (int y = 45; y < 256; ++y) {
            IBlockState state = world.func_180495_p(new BlockPos(x, y, z));
            if ((!state.func_185914_p() || state.func_177230_c() instanceof BlockLeaves) && state.func_177230_c() != Blocks.field_150355_j) continue;
            heighest = y;
        }
        return heighest;
    }

    private static LinkedHashMap<AmbientSituation.BiomeArea, Float> sortByFloatValue(Map<AmbientSituation.BiomeArea, Float> unsortMap) {
        LinkedList<Map.Entry<AmbientSituation.BiomeArea, Float>> list = new LinkedList<Map.Entry<AmbientSituation.BiomeArea, Float>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<AmbientSituation.BiomeArea, Float>>(){

            @Override
            public int compare(Map.Entry<AmbientSituation.BiomeArea, Float> o1, Map.Entry<AmbientSituation.BiomeArea, Float> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        LinkedHashMap<AmbientSituation.BiomeArea, Float> sortedMap = new LinkedHashMap<AmbientSituation.BiomeArea, Float>();
        for (Map.Entry entry : list) {
            sortedMap.put((AmbientSituation.BiomeArea)entry.getKey(), (Float)entry.getValue());
        }
        return sortedMap;
    }

    public static LinkedHashMap<AmbientSituation.BiomeArea, Float> calculateBiomes(World world, EntityPlayer player, float volume) {
        LinkedHashMap<AmbientSituation.BiomeArea, Float> biomes = new LinkedHashMap<AmbientSituation.BiomeArea, Float>();
        if (world.field_73011_w.getDimension() == -1 || world.field_73011_w.getDimension() == 1) {
            volume = 1.0f;
        }
        if ((double)volume > 0.0) {
            int range = 10;
            int stepSize = 5;
            int posX = (int)player.field_70165_t;
            int posZ = (int)player.field_70161_v;
            BlockPos center = new BlockPos(posX, 0, posZ);
            for (int x = -range; x <= range; x += stepSize) {
                for (int z = -range; z <= range; z += stepSize) {
                    BlockPos pos = new BlockPos(posX + x, 0, posZ + z);
                    Biome biome = world.func_180494_b(pos);
                    float biomeVolume = (float)((1.0 - Math.sqrt(center.func_177951_i((Vec3i)pos)) / (double)(range * 2)) * (double)volume);
                    AmbientSituation.BiomeArea area = new AmbientSituation.BiomeArea(biome, pos);
                    if (biomes.containsKey(area)) {
                        biomes.put(area, Float.valueOf(Math.max(biomes.get(area).floatValue(), biomeVolume)));
                        continue;
                    }
                    biomes.put(area, Float.valueOf(biomeVolume));
                }
            }
            return TickHandler.sortByFloatValue(biomes);
        }
        return biomes;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            AmbientSound.engine.tick();
            WorldClient world = TickHandler.mc.field_71441_e;
            EntityPlayerSP player = TickHandler.mc.field_71439_g;
            if (world != null && player != null && TickHandler.mc.field_71474_y.func_186711_a(SoundCategory.AMBIENT) > 0.0f) {
                if (situation == null) {
                    situation = new AmbientSituation((World)world, (EntityPlayer)player, new LinkedHashMap<AmbientSituation.BiomeArea, Float>(), 0.0f, false);
                }
                TickHandler.situation.playedFull = false;
                if (this.timer % this.envUpdateTickTime == 0) {
                    TickHandler.situation.world = world;
                    TickHandler.situation.player = player;
                    TickHandler.situation.biomeVolume = 1.0f;
                    float angle = world.func_72826_c(mc.func_184121_ak());
                    TickHandler.situation.isNight = !(angle > 0.75f) && !(angle < 0.25f);
                    TickHandler.situation.relativeHeight = TickHandler.calculateAverageHeight((World)world, (EntityPlayer)player);
                    AmbientDimension dimension = AmbientSoundLoader.getDimension((World)world);
                    TickHandler.situation.isRaining = world.func_175727_C(player.func_180425_c());
                    TickHandler.situation.isThundering = world.func_72911_I();
                    TickHandler.situation.biomeVolume = 1.0f;
                    TickHandler.situation.selectedBiomes = new ArrayList();
                    if (dimension != null) {
                        dimension.manipulateSituation(situation);
                    }
                    if (TickHandler.situation.biomeVolume > 0.0f) {
                        TickHandler.situation.biomes = TickHandler.calculateBiomes((World)world, (EntityPlayer)player, TickHandler.situation.biomeVolume);
                    } else if (TickHandler.situation.biomes != null) {
                        TickHandler.situation.biomes.clear();
                    } else {
                        TickHandler.situation.biomes = new LinkedHashMap();
                    }
                }
                if (this.timer % this.soundTickTime == 0) {
                    int i;
                    ArrayList<AmbientSituation.BiomeArea> biomesFull = new ArrayList<AmbientSituation.BiomeArea>(TickHandler.situation.biomes.keySet());
                    for (i = 0; i < AmbientSoundLoader.sounds.size(); ++i) {
                        AmbientSound sound = AmbientSoundLoader.sounds.get(i);
                        TickHandler.situation.selectedBiomes = sound.isFull ? new ArrayList<AmbientSituation.BiomeArea>(biomesFull) : new ArrayList<AmbientSituation.BiomeArea>(TickHandler.situation.biomes.keySet());
                        boolean canBePlayed = sound.update(situation);
                        if (canBePlayed && sound.isFull) {
                            biomesFull.removeAll(TickHandler.situation.selectedBiomes);
                        }
                        if ((canBePlayed || sound.isSoundPlaying()) && !sound.inTickList) {
                            playing.add(sound);
                            sound.inTickList = true;
                            continue;
                        }
                        if (canBePlayed || sound.isSoundPlaying() || !sound.inTickList) continue;
                        sound.inTickList = false;
                        playing.remove(sound);
                    }
                    if (AmbientSounds.debugging) {
                        System.out.println("================Playing================");
                        for (i = 0; i < playing.size(); ++i) {
                            System.out.println(playing.get(i));
                        }
                    }
                }
                float mutingFactor = 0.0f;
                mutingFactor = Math.min(1.0f, mutingFactor);
                for (int i = 0; i < playing.size(); ++i) {
                    if (!(TickHandler.playing.get((int)i).mutingFactor * TickHandler.playing.get((int)i).currentVolume > mutingFactor)) continue;
                    mutingFactor = TickHandler.playing.get((int)i).mutingFactor * TickHandler.playing.get((int)i).currentVolume;
                }
                float mute = 1.0f - mutingFactor;
                for (int i = 0; i < playing.size(); ++i) {
                    playing.get(i).tick(mutingFactor > TickHandler.playing.get((int)i).mutingFactor * TickHandler.playing.get((int)i).currentVolume ? mute : 1.0f);
                }
                ++this.timer;
            }
        }
    }

    @SubscribeEvent
    public void onSoundLoadEvent(SoundLoadEvent event) {
        AmbientSound.engine = new AmbientSoundEngine(event.getManager(), TickHandler.mc.field_71474_y);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onSoundSetup(SoundSetupEvent event) {
        SoundSystemConfig.setNumberStreamingChannels((int)AmbientSounds.streamingChannels);
        SoundSystemConfig.setNumberNormalChannels((int)AmbientSounds.normalChannels);
    }
}

